/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class BufferWrapper<T>
implements Cacheable {
    private static final Logger logger = Grizzly.logger(BufferWrapper.class);
    private static final ThreadCache.CachedTypeIndex<BufferWrapper> CACHE_IDX = ThreadCache.obtainIndex(BufferWrapper.class, (int)16);
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    private Buffer buffer;
    private BufferType type;
    private T origin;

    private BufferWrapper(T origin, Buffer buffer, BufferType type) {
        this.initialize(origin, buffer, type);
    }

    private void initialize(T origin, Buffer buffer, BufferType type) {
        this.origin = origin;
        this.buffer = buffer;
        this.type = type;
    }

    public T getOrigin() {
        return this.origin;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public BufferType getType() {
        return this.type;
    }

    public void recycle() {
        this.origin = null;
        this.buffer = null;
        this.type = null;
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    private static <T> BufferWrapper<T> create(T origin, Buffer buffer, BufferType type) {
        BufferWrapper bufferWrapper = (BufferWrapper)ThreadCache.takeFromCache(CACHE_IDX);
        if (bufferWrapper != null) {
            bufferWrapper.initialize(origin, buffer, type);
            return bufferWrapper;
        }
        return new BufferWrapper<T>(origin, buffer, type);
    }

    public static <T> BufferWrapper<T> wrap(T origin, MemoryManager memoryManager) throws IllegalArgumentException {
        BufferWrapper<T> bufferWrapper;
        Buffer buffer;
        if (origin == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        if (origin instanceof Buffer) {
            return BufferWrapper.create(origin, (Buffer)origin, BufferType.NONE);
        }
        if (memoryManager == null) {
            memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        }
        if (origin instanceof String) {
            buffer = Buffers.wrap((MemoryManager)memoryManager, (String)((String)origin));
            bufferWrapper = buffer.remaining() > 16384 ? BufferWrapper.create(origin, BufferWrapper.compressBuffer(buffer, memoryManager), BufferType.STRING_COMPRESSED) : BufferWrapper.create(origin, buffer, BufferType.STRING);
        } else if (origin instanceof byte[]) {
            byte[] originBytes = (byte[])origin;
            if (originBytes.length > 16384) {
                buffer = Buffers.wrap((MemoryManager)memoryManager, (byte[])BufferWrapper.compress(originBytes));
                bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.BYTE_ARRAY_COMPRESSED);
            } else {
                buffer = Buffers.wrap((MemoryManager)memoryManager, (byte[])originBytes);
                bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.BYTE_ARRAY);
            }
        } else if (origin instanceof ByteBuffer) {
            buffer = Buffers.wrap((MemoryManager)memoryManager, (ByteBuffer)((ByteBuffer)origin));
            bufferWrapper = buffer.remaining() > 16384 ? BufferWrapper.create(origin, BufferWrapper.compressBuffer(buffer, memoryManager), BufferType.BYTE_BUFFER_COMPRESSED) : BufferWrapper.create(origin, buffer, BufferType.BYTE_BUFFER);
        } else if (origin instanceof Byte) {
            buffer = memoryManager.allocate(1);
            buffer.put(((Byte)origin).byteValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.BYTE);
        } else if (origin instanceof Boolean) {
            buffer = memoryManager.allocate(1);
            if (((Boolean)origin).booleanValue()) {
                buffer.put((byte)49);
            } else {
                buffer.put((byte)48);
            }
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.BOOLEAN);
        } else if (origin instanceof Short) {
            buffer = memoryManager.allocate(2);
            buffer.putShort(((Short)origin).shortValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.SHORT);
        } else if (origin instanceof Integer) {
            buffer = memoryManager.allocate(4);
            buffer.putInt(((Integer)origin).intValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.INTEGER);
        } else if (origin instanceof Float) {
            buffer = memoryManager.allocate(4);
            buffer.putFloat(((Float)origin).floatValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.FLOAT);
        } else if (origin instanceof Double) {
            buffer = memoryManager.allocate(8);
            buffer.putDouble(((Double)origin).doubleValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.DOUBLE);
        } else if (origin instanceof Long) {
            buffer = memoryManager.allocate(8);
            buffer.putLong(((Long)origin).longValue());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.LONG);
        } else if (origin instanceof Date) {
            buffer = memoryManager.allocate(8);
            buffer.putLong(((Date)origin).getTime());
            buffer.flip();
            bufferWrapper = BufferWrapper.create(origin, buffer, BufferType.DATE);
        } else {
            BufferOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new BufferOutputStream(memoryManager){

                    protected Buffer allocateNewBuffer(MemoryManager memoryManager, int size) {
                        Buffer b = memoryManager.allocate(size);
                        b.allowBufferDispose(true);
                        return b;
                    }
                };
                oos = new ObjectOutputStream((OutputStream)bos);
                oos.writeObject(origin);
                buffer = bos.getBuffer();
                buffer.flip();
                bufferWrapper = buffer.remaining() > 16384 ? BufferWrapper.create(origin, BufferWrapper.compressBuffer(buffer, memoryManager), BufferType.OBJECT_COMPRESSED) : BufferWrapper.create(origin, buffer, BufferType.OBJECT);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("Non-serializable object", ie);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ignore) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (buffer != null) {
            buffer.allowBufferDispose(true);
        }
        return bufferWrapper;
    }

    public static Object unwrap(Buffer buffer, BufferType type, MemoryManager memoryManager) {
        if (buffer == null) {
            return null;
        }
        return BufferWrapper.unwrap(buffer, buffer.position(), buffer.limit(), type, memoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unwrap(Buffer buffer, int position, int limit, BufferType type, MemoryManager memoryManager) {
        if (buffer == null || position > limit || type == null) {
            return null;
        }
        switch (type) {
            case NONE: {
                return buffer;
            }
            case STRING: {
                int length = limit - position;
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                try {
                    return new String(bytes, DEFAULT_CHARSET);
                }
                catch (UnsupportedEncodingException uee) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "failed to decode the buffer", uee);
                    }
                    return null;
                }
            }
            case STRING_COMPRESSED: {
                int length2 = limit - position;
                byte[] bytes2 = new byte[length2];
                buffer.get(bytes2, 0, length2);
                byte[] decompressedBytes = BufferWrapper.decompress(bytes2);
                if (decompressedBytes == null) {
                    return null;
                }
                try {
                    return new String(decompressedBytes, DEFAULT_CHARSET);
                }
                catch (UnsupportedEncodingException uee) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "failed to decode the buffer", uee);
                    }
                    return null;
                }
            }
            case BYTE_ARRAY: {
                int length3 = limit - position;
                byte[] bytes3 = new byte[length3];
                buffer.get(bytes3, 0, length3);
                return bytes3;
            }
            case BYTE_ARRAY_COMPRESSED: {
                int length4 = limit - position;
                ByteBuffer byteBuffer = buffer.toByteBuffer(position, limit);
                return BufferWrapper.decompress(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), length4);
            }
            case BYTE_BUFFER: {
                return buffer.toByteBuffer(position, limit);
            }
            case BYTE_BUFFER_COMPRESSED: {
                Buffer decompressedBuffer2 = BufferWrapper.decompressBuffer(buffer, position, limit, memoryManager);
                if (decompressedBuffer2 == null) {
                    return null;
                }
                ByteBuffer result = decompressedBuffer2.toByteBuffer();
                decompressedBuffer2.tryDispose();
                return result;
            }
            case BYTE: {
                return buffer.get();
            }
            case BOOLEAN: {
                return buffer.get() == 49;
            }
            case SHORT: {
                return buffer.getShort();
            }
            case INTEGER: {
                return buffer.getInt();
            }
            case FLOAT: {
                return Float.valueOf(buffer.getFloat());
            }
            case DOUBLE: {
                return buffer.getDouble();
            }
            case LONG: {
                return buffer.getLong();
            }
            case DATE: {
                long dateLong = buffer.getLong();
                return new Date(dateLong);
            }
            case OBJECT: {
                BufferInputStream bis = null;
                ObjectInputStream ois = null;
                Object obj = null;
                try {
                    bis = new BufferInputStream(buffer, position, limit);
                    ois = new ObjectInputStream((InputStream)bis);
                    obj = ois.readObject();
                }
                catch (IOException ie) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to read the object", ie);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to read the object", cnfe);
                    }
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                return obj;
            }
            case OBJECT_COMPRESSED: {
                Buffer decompressedBuffer3 = BufferWrapper.decompressBuffer(buffer, position, limit, memoryManager);
                if (decompressedBuffer3 == null) {
                    return null;
                }
                BufferInputStream bis2 = null;
                ObjectInputStream ois2 = null;
                Object obj2 = null;
                try {
                    bis2 = new BufferInputStream(decompressedBuffer3);
                    ois2 = new ObjectInputStream((InputStream)bis2);
                    obj2 = ois2.readObject();
                }
                catch (IOException ie) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to read the object", ie);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to read the object", cnfe);
                    }
                }
                finally {
                    if (ois2 != null) {
                        try {
                            ois2.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (bis2 != null) {
                        try {
                            bis2.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                decompressedBuffer3.tryDispose();
                return obj2;
            }
        }
        return null;
    }

    private static Buffer compressBuffer(Buffer buffer, MemoryManager memoryManager) {
        if (buffer == null) {
            throw new IllegalArgumentException("failed to compress the buffer. buffer should be not null");
        }
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        byte[] compressed = BufferWrapper.compress(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        buffer.tryDispose();
        return Buffers.wrap((MemoryManager)memoryManager, (byte[])compressed);
    }

    private static byte[] compress(byte[] in) {
        return BufferWrapper.compress(in, 0, in.length);
    }

    private static byte[] compress(byte[] in, int offset, int length) {
        if (in == null) {
            throw new IllegalArgumentException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in, offset, length);
        }
        catch (IOException ie) {
            throw new RuntimeException("IO exception compressing data", ie);
        }
        finally {
            if (gz != null) {
                try {
                    gz.close();
                }
                catch (IOException ignore) {}
            }
            try {
                bos.close();
            }
            catch (IOException ignore) {}
        }
        return bos.toByteArray();
    }

    private static Buffer decompressBuffer(Buffer buffer, int position, int limit, MemoryManager memoryManager) {
        if (buffer == null || position > limit) {
            return null;
        }
        int length = limit - position;
        ByteBuffer byteBuffer = buffer.toByteBuffer(position, limit);
        byte[] decompressed = BufferWrapper.decompress(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), length);
        if (decompressed == null) {
            return null;
        }
        return Buffers.wrap((MemoryManager)memoryManager, (byte[])decompressed);
    }

    private static byte[] decompress(byte[] in) {
        if (in == null) {
            return null;
        }
        return BufferWrapper.decompress(in, 0, in.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decompress(byte[] in, int offset, int length) {
        byte[] result = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in, offset, length);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                int r;
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[8192];
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
                result = bos.toByteArray();
            }
            catch (IOException ie) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to decompress bytes", ie);
                }
                bos = null;
            }
            finally {
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (IOException ignore) {}
                }
                try {
                    bis.close();
                }
                catch (IOException ignore) {}
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return result;
    }

    public String toString() {
        return "BufferWrapper{buffer=" + this.buffer + ", type=" + (Object)((Object)this.type) + ", origin=" + this.origin + '}';
    }

    public static enum BufferType {
        NONE(0),
        STRING(1),
        STRING_COMPRESSED(2),
        BYTE_ARRAY(3),
        BYTE_ARRAY_COMPRESSED(4),
        BYTE_BUFFER(5),
        BYTE_BUFFER_COMPRESSED(6),
        BYTE(7),
        BOOLEAN(8),
        SHORT(9),
        INTEGER(10),
        FLOAT(11),
        DOUBLE(12),
        LONG(13),
        DATE(14),
        OBJECT(15),
        OBJECT_COMPRESSED(16);

        public final int flags;

        private BufferType(int typeFlags) {
            this.flags = typeFlags;
        }

        public static BufferType getBufferType(int flags) {
            short typeFlags = (short)(flags & 0xFFFF);
            switch (typeFlags) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return STRING;
                }
                case 2: {
                    return STRING_COMPRESSED;
                }
                case 3: {
                    return BYTE_ARRAY;
                }
                case 4: {
                    return BYTE_ARRAY_COMPRESSED;
                }
                case 5: {
                    return BYTE_BUFFER;
                }
                case 6: {
                    return BYTE_BUFFER_COMPRESSED;
                }
                case 7: {
                    return BYTE;
                }
                case 8: {
                    return BOOLEAN;
                }
                case 9: {
                    return SHORT;
                }
                case 10: {
                    return INTEGER;
                }
                case 11: {
                    return FLOAT;
                }
                case 12: {
                    return DOUBLE;
                }
                case 13: {
                    return LONG;
                }
                case 14: {
                    return DATE;
                }
                case 15: {
                    return OBJECT;
                }
                case 16: {
                    return OBJECT_COMPRESSED;
                }
            }
            throw new IllegalArgumentException("invalid type");
        }
    }
}

