/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memcached.CommandOpcodes;
import org.glassfish.grizzly.memcached.MemcachedRequest;
import org.glassfish.grizzly.memcached.MemcachedResponse;
import org.glassfish.grizzly.memcached.ResponseStatus;
import org.glassfish.grizzly.memcached.pool.ObjectPool;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.NullaryFunction;

public class MemcachedClientFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(MemcachedClientFilter.class);
    private static final int MAX_WRITE_BUFFER_SIZE_FOR_OPTIMIZING = 0x100000;
    private static final int HEADER_LENGTH = 24;
    private static final byte REQUEST_MAGIC_NUMBER = -128;
    private static final byte RESPONSE_MAGIC_NUMBER = -127;
    private final Attribute<ParsingStatus> statusAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("MemcachedClientFilter.Status");
    private final Attribute<MemcachedResponse> responseAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("MemcachedClientFilter.Response", (NullaryFunction)new NullaryFunction<MemcachedResponse>(){

        public MemcachedResponse evaluate() {
            return MemcachedResponse.create();
        }
    });
    private final Attribute<BlockingQueue<MemcachedRequest>> requestQueueAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("MemcachedClientFilter.RequestQueue", (NullaryFunction)new NullaryFunction<BlockingQueue<MemcachedRequest>>(){

        public BlockingQueue<MemcachedRequest> evaluate() {
            return DataStructures.getLTQInstance();
        }
    });
    private final Attribute<ObjectPool<SocketAddress, Connection<SocketAddress>>> connectionPoolAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("GrizzlyMemcachedCache.ConnectionPool");
    private final boolean localParsingOptimizing;
    private final boolean onceAllocationOptimizing;

    public MemcachedClientFilter() {
        this(false, true);
    }

    public MemcachedClientFilter(boolean localParsingOptimizing, boolean onceAllocationOptimizing) {
        this.localParsingOptimizing = localParsingOptimizing;
        this.onceAllocationOptimizing = onceAllocationOptimizing;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        BlockingQueue requestQueue;
        ParsingStatus status;
        Buffer input = (Buffer)ctx.getMessage();
        if (input == null) {
            throw new IOException("input message could not be null");
        }
        if (!input.hasRemaining()) {
            return ctx.getStopAction();
        }
        Connection connection = ctx.getConnection();
        if (connection == null) {
            throw new IOException("connection could not be null");
        }
        MemoryManager memoryManager = ctx.getMemoryManager();
        if (memoryManager == null) {
            memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        }
        if ((status = (ParsingStatus)((Object)this.statusAttribute.get((AttributeStorage)connection))) == null) {
            status = ParsingStatus.NONE;
            this.statusAttribute.set((AttributeStorage)connection, (Object)status);
        }
        if ((requestQueue = (BlockingQueue)this.requestQueueAttribute.get((AttributeStorage)connection)) == null) {
            throw new IOException("request queue must not be null");
        }
        MemcachedResponse response = (MemcachedResponse)this.responseAttribute.get((AttributeStorage)connection);
        block9: while (true) {
            switch (status) {
                case NONE: {
                    if (input.remaining() < 24) {
                        return ctx.getStopAction((Object)input);
                    }
                    status = ParsingStatus.READ_HEADER;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    continue block9;
                }
                case READ_HEADER: {
                    input.mark();
                    byte magic = input.get();
                    if (magic != -127) {
                        throw new IOException("invalid magic");
                    }
                    byte op = input.get();
                    MemcachedRequest sentRequest = (MemcachedRequest)requestQueue.peek();
                    if (sentRequest == null) {
                        throw new IOException("invalid response");
                    }
                    CommandOpcodes commandOpcode = sentRequest.getOp();
                    response.setOp(commandOpcode);
                    if (op != commandOpcode.opcode()) {
                        if (sentRequest.isNoReply()) {
                            status = ParsingStatus.NO_REPLY;
                            this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                            continue block9;
                        }
                        throw new IOException("invalid op: " + op);
                    }
                    short keyLength = input.getShort();
                    if (keyLength < 0) {
                        throw new IOException("invalid key length: " + keyLength);
                    }
                    response.setKeyLength(keyLength);
                    byte extraLength = input.get();
                    if (extraLength < 0) {
                        throw new IOException("invalid extra length: " + extraLength);
                    }
                    response.setExtraLength(extraLength);
                    response.setDataType(input.get());
                    response.setStatus(ResponseStatus.getResponseStatus(input.getShort()));
                    int totalBodyLength = input.getInt();
                    if (totalBodyLength < 0) {
                        throw new IOException("invalid total body length: " + totalBodyLength);
                    }
                    response.setTotalBodyLength(totalBodyLength);
                    int opaque = input.getInt();
                    if (sentRequest.isNoReply() && opaque != sentRequest.getOpaque()) {
                        status = ParsingStatus.NO_REPLY;
                        this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                        continue block9;
                    }
                    response.setOpaque(opaque);
                    response.setCas(input.getLong());
                    status = ParsingStatus.READ_EXTRAS;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    continue block9;
                }
                case READ_EXTRAS: {
                    byte extraLength = response.getExtraLength();
                    if (input.remaining() < extraLength) {
                        return ctx.getStopAction((Object)input);
                    }
                    if (extraLength == 4) {
                        response.setFlags(input.getInt());
                    } else {
                        input.position(input.position() + extraLength);
                    }
                    status = ParsingStatus.READ_KEY;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    continue block9;
                }
                case READ_KEY: {
                    int limit;
                    int currentPosition;
                    short keyLength = response.getKeyLength();
                    if (input.remaining() < keyLength) {
                        return ctx.getStopAction((Object)input);
                    }
                    if (keyLength > 0) {
                        currentPosition = input.position();
                        limit = currentPosition + keyLength;
                        response.setDecodedKey(input, currentPosition, limit, memoryManager);
                        input.position(limit);
                    } else {
                        response.setDecodedKey(null);
                    }
                    status = ParsingStatus.READ_VALUE;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    continue block9;
                }
                case READ_VALUE: {
                    MemcachedRequest sentRequest;
                    int totalBodyLength = response.getTotalBodyLength();
                    short keyLength = response.getKeyLength();
                    byte extraLength = response.getExtraLength();
                    int valueLength = totalBodyLength - keyLength - extraLength;
                    if (valueLength < 0) {
                        throw new IOException("invalid length fields: total body length=" + totalBodyLength + ", key length = " + keyLength + ", extra length = " + extraLength);
                    }
                    if (input.remaining() < valueLength) {
                        return ctx.getStopAction((Object)input);
                    }
                    int currentPosition = input.position();
                    int limit = currentPosition + valueLength;
                    if (response.getStatus() == ResponseStatus.No_Error) {
                        if (valueLength > 0) {
                            sentRequest = (MemcachedRequest)requestQueue.peek();
                            if (sentRequest == null) {
                                throw new IOException("invalid response");
                            }
                            response.setDecodedValue(input, currentPosition, limit, memoryManager);
                            input.position(limit);
                        } else {
                            response.setDecodedValue(null);
                        }
                    } else {
                        response.setDecodedValue(null);
                        input.position(limit);
                    }
                    status = ParsingStatus.DONE;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    continue block9;
                }
                case DONE: {
                    MemcachedRequest sentRequest;
                    boolean complete = response.complete();
                    if (complete) {
                        sentRequest = (MemcachedRequest)requestQueue.remove();
                        response.setResult(sentRequest.getOriginKey(), ParsingStatus.DONE);
                        if (sentRequest.disposed.compareAndSet(false, true)) {
                            sentRequest.response = response.getResult();
                            sentRequest.isError = response.isError();
                            sentRequest.notify.countDown();
                        }
                    } else {
                        sentRequest = (MemcachedRequest)requestQueue.peek();
                        response.setResult(sentRequest.getOriginKey(), ParsingStatus.DONE);
                        if (!sentRequest.disposed.get()) {
                            sentRequest.response = response.getResult();
                            sentRequest.isError = response.isError();
                            sentRequest.notify.countDown();
                        }
                    }
                    if (this.localParsingOptimizing) {
                        if (input.remaining() > 0) {
                            status = ParsingStatus.NONE;
                            this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                            response.clear();
                            continue block9;
                        }
                        input.tryDispose();
                        this.statusAttribute.remove((AttributeStorage)connection);
                        this.responseAttribute.remove((AttributeStorage)connection);
                        response.recycle();
                        return ctx.getStopAction();
                    }
                    Buffer remainder = input.remaining() > 0 ? input.split(input.position()) : null;
                    input.tryDispose();
                    this.statusAttribute.remove((AttributeStorage)connection);
                    this.responseAttribute.remove((AttributeStorage)connection);
                    response.recycle();
                    if (remainder == null) {
                        return ctx.getStopAction();
                    }
                    return ctx.getInvokeAction((Object)remainder);
                }
                case NO_REPLY: {
                    MemcachedRequest sentRequest = (MemcachedRequest)requestQueue.remove();
                    response.setResult(sentRequest.getOriginKey(), ParsingStatus.NO_REPLY);
                    sentRequest.response = response.getResult();
                    sentRequest.isError = Boolean.FALSE;
                    sentRequest.notify.countDown();
                    input.reset();
                    status = ParsingStatus.READ_HEADER;
                    this.statusAttribute.set((AttributeStorage)connection, (Object)status);
                    response.clear();
                    continue block9;
                }
            }
            break;
        }
        throw new IllegalStateException("invalid internal status");
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        int totalSize;
        MemcachedRequest[] requests = (MemcachedRequest[])ctx.getMessage();
        if (requests == null) {
            throw new IOException("Input message could not be null");
        }
        Connection connection = ctx.getConnection();
        if (connection == null) {
            throw new IOException("connection must not be null. this connection was already closed or not opened");
        }
        BlockingQueue requestQueue = (BlockingQueue)this.requestQueueAttribute.get((AttributeStorage)connection);
        if (requestQueue == null) {
            throw new IOException("request queue must not be null. this connection was already closed or not opened. connection=" + connection);
        }
        MemoryManager memoryManager = ctx.getMemoryManager();
        if (memoryManager == null) {
            memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        }
        Buffer resultBuffer = this.onceAllocationOptimizing ? ((totalSize = this.calculateTotalPacketSize(requests)) <= 0x100000 ? this.makePacketsByOnceAllocation(memoryManager, connection, requests, requestQueue, totalSize) : this.makePackets(memoryManager, connection, requests, requestQueue)) : this.makePackets(memoryManager, connection, requests, requestQueue);
        if (resultBuffer != null) {
            resultBuffer.allowBufferDispose(true);
            if (resultBuffer.isComposite()) {
                ((CompositeBuffer)resultBuffer).allowInternalBuffersDispose(true);
            }
            ctx.setMessage((Object)resultBuffer);
        }
        return ctx.getInvokeAction();
    }

    private int calculateTotalPacketSize(MemcachedRequest[] requests) {
        if (requests == null) {
            return 0;
        }
        int totalSize = requests.length * 24;
        for (MemcachedRequest request : requests) {
            totalSize += request.getExtrasLength();
            totalSize += request.getKeyLength();
            totalSize += request.getValueLength();
        }
        return totalSize;
    }

    private Buffer makePacketsByOnceAllocation(MemoryManager memoryManager, Connection connection, MemcachedRequest[] requests, BlockingQueue<MemcachedRequest> requestQueue, int totalSize) throws IOException {
        if (memoryManager == null) {
            throw new IllegalArgumentException("memory manager must not be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requestQueue == null) {
            throw new IllegalArgumentException("request queue must not be null");
        }
        if (totalSize < 24) {
            throw new IllegalArgumentException("invalid packet size");
        }
        Buffer buffer = memoryManager.allocate(totalSize);
        for (MemcachedRequest request : requests) {
            byte extrasLength = request.getExtrasLength();
            buffer.put((byte)-128);
            buffer.put(request.getOp().opcode());
            short keyLength = request.getKeyLength();
            buffer.putShort(keyLength);
            buffer.put(extrasLength);
            buffer.put(request.getDataType());
            buffer.putShort(request.getvBucketId());
            int totalLength = keyLength + request.getValueLength() + extrasLength;
            buffer.putInt(totalLength);
            buffer.putInt(request.getOpaque());
            buffer.putLong(request.getCas());
            request.fillExtras(buffer);
            Buffer keyBuffer = request.getKey();
            if (request.hasKey() && keyBuffer != null) {
                buffer.put(keyBuffer);
                keyBuffer.tryDispose();
            }
            Buffer valueBuffer = request.getValue();
            if (request.hasValue() && valueBuffer != null) {
                buffer.put(valueBuffer);
                valueBuffer.tryDispose();
            }
            try {
                requestQueue.put(request);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("failed to put the request", ie);
            }
        }
        buffer.flip();
        return buffer;
    }

    private Buffer makePackets(MemoryManager memoryManager, Connection connection, MemcachedRequest[] requests, BlockingQueue<MemcachedRequest> requestQueue) throws IOException {
        if (memoryManager == null) {
            throw new IllegalArgumentException("memory manager must not be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requestQueue == null) {
            throw new IllegalArgumentException("request queue must not be null");
        }
        Buffer resultBuffer = null;
        for (MemcachedRequest request : requests) {
            byte extrasLength = request.getExtrasLength();
            Buffer buffer = memoryManager.allocate(24 + extrasLength);
            buffer.put((byte)-128);
            buffer.put(request.getOp().opcode());
            short keyLength = request.getKeyLength();
            buffer.putShort(keyLength);
            buffer.put(extrasLength);
            buffer.put(request.getDataType());
            buffer.putShort(request.getvBucketId());
            int totalLength = keyLength + request.getValueLength() + extrasLength;
            buffer.putInt(totalLength);
            buffer.putInt(request.getOpaque());
            buffer.putLong(request.getCas());
            request.fillExtras(buffer);
            buffer.flip();
            buffer.allowBufferDispose(true);
            resultBuffer = resultBuffer == null ? buffer : Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)buffer);
            Buffer keyBuffer = request.getKey();
            if (request.hasKey() && keyBuffer != null) {
                keyBuffer.allowBufferDispose(true);
                resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)keyBuffer);
            }
            Buffer valueBuffer = request.getValue();
            if (request.hasValue() && valueBuffer != null) {
                valueBuffer.allowBufferDispose(true);
                resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)valueBuffer);
            }
            try {
                requestQueue.put(request);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("failed to put the request", ie);
            }
        }
        return resultBuffer;
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            BlockingQueue requestQueue = (BlockingQueue)this.requestQueueAttribute.get((AttributeStorage)connection);
            if (requestQueue != null) {
                requestQueue.clear();
                this.requestQueueAttribute.remove((AttributeStorage)connection);
            }
            this.responseAttribute.remove((AttributeStorage)connection);
            this.statusAttribute.remove((AttributeStorage)connection);
            ObjectPool connectionPool = (ObjectPool)this.connectionPoolAttribute.remove((AttributeStorage)connection);
            if (connectionPool != null) {
                try {
                    connectionPool.removeObject(connection.getPeerAddress(), connection);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "the connection has been removed in pool. connection={0}", connection);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        return ctx.getInvokeAction();
    }

    public <K, V> Map<K, V> getMultiResponse(Connection connection, MemcachedRequest[] requests, long timeoutInMillis, Map<K, V> result) throws InterruptedException, TimeoutException {
        Boolean isError;
        Object response;
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        int requestLen = requests.length;
        if (requestLen < 1) {
            throw new IllegalArgumentException("requests must include at least one request");
        }
        if (result == null) {
            throw new IllegalArgumentException("result must not be null");
        }
        int lastIndex = requestLen - 1;
        if (timeoutInMillis < 0L) {
            requests[lastIndex].notify.await();
            response = requests[lastIndex].response;
            isError = requests[lastIndex].isError;
        } else {
            requests[lastIndex].notify.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            response = requests[lastIndex].response;
            isError = requests[lastIndex].isError;
        }
        if (response == null && isError == null) {
            throw new TimeoutException("timed out while getting the response");
        }
        if (isError != null && !isError.booleanValue()) {
            result.put(requests[lastIndex].getOriginKey(), response);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "error status op={0}, key={1}", new Object[]{requests[lastIndex].getOp(), requests[lastIndex].getOriginKey()});
        }
        for (int i = 0; i < requestLen - 1; ++i) {
            response = requests[i].response;
            isError = requests[i].isError;
            if (response == null) continue;
            if (isError != null && !isError.booleanValue()) {
                result.put(requests[i].getOriginKey(), response);
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "error status op={0}, key={1}", new Object[]{requests[i].getOp(), requests[i].getOriginKey()});
        }
        return result;
    }

    public <V> V getCorrelatedResponse(Connection connection, MemcachedRequest request, long timeoutInMillis) throws InterruptedException, TimeoutException {
        Object result;
        Boolean isError;
        Object response;
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isNoReply()) {
            throw new IllegalArgumentException("request type is no reply");
        }
        if (timeoutInMillis < 0L) {
            request.notify.await();
            response = request.response;
            isError = request.isError;
        } else {
            request.notify.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            response = request.response;
            isError = request.isError;
        }
        if (response == null && isError == null) {
            throw new TimeoutException("timed out while getting the response");
        }
        if (isError != null && !isError.booleanValue()) {
            result = response;
        } else {
            result = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "error status op={0}, key={1}", new Object[]{request.getOp(), request.getOriginKey()});
            }
        }
        return (V)result;
    }

    public static enum ParsingStatus {
        NONE,
        READ_HEADER,
        READ_EXTRAS,
        READ_KEY,
        READ_VALUE,
        DONE,
        NO_REPLY;

    }
}

