/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memcached.BufferWrapper;
import org.glassfish.grizzly.memcached.CommandOpcodes;

public class MemcachedRequest {
    private static final int MAX_KEY_LENGTH = 250;
    private static final int MAX_VALUE_LENGTH = 0x100000;
    private final boolean hasExtras;
    private final boolean hasKey;
    private final boolean hasValue;
    private final CommandOpcodes op;
    private final boolean noReply;
    private final int opaque;
    private final long cas;
    private final byte dataType;
    private final short vBucketId;
    private final Integer flags;
    private final Long delta;
    private final Long initial;
    private final Integer expirationInSecs;
    private final Integer verbosity;
    private final BufferWrapper.BufferType originKeyType;
    private final Object originKey;
    private final Buffer key;
    private final Buffer value;
    final AtomicBoolean disposed = new AtomicBoolean();
    final CountDownLatch notify = new CountDownLatch(1);
    Object response;
    Boolean isError;

    private MemcachedRequest(Builder builder) {
        this.hasExtras = builder.hasExtras;
        this.hasKey = builder.hasKey;
        this.hasValue = builder.hasValue;
        this.op = builder.op;
        this.noReply = builder.noReply;
        this.opaque = builder.opaque;
        this.cas = builder.cas;
        this.dataType = builder.dataType;
        this.vBucketId = builder.vBucketId;
        this.flags = builder.flags;
        this.delta = builder.delta;
        this.initial = builder.initial;
        this.expirationInSecs = builder.expirationInSecs;
        this.verbosity = builder.verbosity;
        this.originKeyType = builder.originKeyType;
        this.originKey = builder.originKey;
        this.key = builder.key;
        this.value = builder.value;
    }

    public boolean hasExtras() {
        return this.hasExtras;
    }

    public boolean hasKey() {
        return this.hasKey;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public CommandOpcodes getOp() {
        return this.op;
    }

    public boolean isNoReply() {
        return this.noReply;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public long getCas() {
        return this.cas;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public short getvBucketId() {
        return this.vBucketId;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public Long getDelta() {
        return this.delta;
    }

    public Long getInitial() {
        return this.initial;
    }

    public Integer getExpirationInSecs() {
        return this.expirationInSecs;
    }

    public Integer getVerbosity() {
        return this.verbosity;
    }

    public BufferWrapper.BufferType getOriginKeyType() {
        return this.originKeyType;
    }

    public Object getOriginKey() {
        return this.originKey;
    }

    public Buffer getKey() {
        return this.key;
    }

    public Buffer getValue() {
        return this.value;
    }

    public byte getExtrasLength() {
        if (!this.hasExtras) {
            return 0;
        }
        return (byte)((this.flags != null ? 4 : 0) + (this.delta != null ? 8 : 0) + (this.initial != null ? 8 : 0) + (this.expirationInSecs != null ? 4 : 0) + (this.verbosity != null ? 4 : 0) & 0x7F);
    }

    public void fillExtras(Buffer buffer) {
        if (!this.hasExtras || buffer == null) {
            return;
        }
        switch (this.op) {
            case Set: 
            case SetQ: 
            case Add: 
            case AddQ: 
            case Replace: 
            case ReplaceQ: {
                if (this.flags != null) {
                    buffer.putInt(this.flags.intValue());
                }
                if (this.expirationInSecs == null) break;
                buffer.putInt(this.expirationInSecs.intValue());
                break;
            }
            case Increment: 
            case IncrementQ: 
            case Decrement: 
            case DecrementQ: {
                if (this.delta != null) {
                    buffer.putLong(this.delta.longValue());
                }
                if (this.initial != null) {
                    buffer.putLong(this.initial.longValue());
                }
                if (this.expirationInSecs == null) break;
                buffer.putInt(this.expirationInSecs.intValue());
                break;
            }
            case Verbosity: {
                if (this.verbosity == null) break;
                buffer.putInt(this.verbosity.intValue());
                break;
            }
            case GAT: 
            case GATQ: 
            case Touch: 
            case Flush: 
            case FlushQ: {
                if (this.expirationInSecs == null) break;
                buffer.putInt(this.expirationInSecs.intValue());
                break;
            }
        }
    }

    public short getKeyLength() {
        return this.hasKey && this.key != null ? (short)(this.key.remaining() & Short.MAX_VALUE) : (short)0;
    }

    public int getValueLength() {
        return this.hasValue && this.value != null ? this.value.remaining() : 0;
    }

    public String toString() {
        return "MemcachedRequest{hasExtras=" + this.hasExtras + ", hasKey=" + this.hasKey + ", hasValue=" + this.hasValue + ", op=" + (Object)((Object)this.op) + ", noReply=" + this.noReply + ", opaque=" + this.opaque + ", cas=" + this.cas + ", dataType=" + this.dataType + ", vBucketId=" + this.vBucketId + ", flags=" + this.flags + ", delta=" + this.delta + ", initial=" + this.initial + ", expirationInSecs=" + this.expirationInSecs + ", verbosity=" + this.verbosity + ", originKeyType=" + (Object)((Object)this.originKeyType) + ", originKey=" + this.originKey + ", key=" + this.key + ", response=" + this.response + ", isError=" + this.isError + ", value=" + this.value + '}';
    }

    public static class Builder
    implements Cacheable {
        private static final ThreadCache.CachedTypeIndex<Builder> CACHE_IDX = ThreadCache.obtainIndex(Builder.class, (int)16);
        private boolean hasExtras;
        private boolean hasKey;
        private boolean hasValue;
        private CommandOpcodes op;
        private boolean noReply;
        private int opaque;
        private long cas;
        private byte dataType;
        private short vBucketId;
        private Integer flags;
        private Long delta;
        private Long initial;
        private Integer expirationInSecs;
        private Integer verbosity;
        private BufferWrapper.BufferType originKeyType;
        private Object originKey;
        private Buffer key;
        private Buffer value;

        public static Builder create(boolean hasExtras, boolean hasKey, boolean hasValue) {
            Builder builder = (Builder)ThreadCache.takeFromCache(CACHE_IDX);
            if (builder != null) {
                builder.initialize(hasExtras, hasKey, hasValue);
                return builder;
            }
            return new Builder(hasExtras, hasKey, hasValue);
        }

        private Builder(boolean hasExtras, boolean hasKey, boolean hasValue) {
            this.initialize(hasExtras, hasKey, hasValue);
        }

        private void initialize(boolean hasExtras, boolean hasKey, boolean hasValue) {
            this.hasExtras = hasExtras;
            this.hasKey = hasKey;
            this.hasValue = hasValue;
        }

        public Builder op(CommandOpcodes op) {
            this.op = op;
            return this;
        }

        public Builder noReply(boolean noReply) {
            this.noReply = noReply;
            return this;
        }

        public Builder opaque(int opaque) {
            this.opaque = opaque;
            return this;
        }

        public Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        public Builder dataType(byte dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder vBucketId(short vBucketId) {
            this.vBucketId = vBucketId;
            return this;
        }

        public Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public Builder delta(Long delta) {
            this.delta = delta;
            return this;
        }

        public Builder initial(Long initial) {
            this.initial = initial;
            return this;
        }

        public Builder expirationInSecs(Integer expirationInSecs) throws IllegalArgumentException {
            if (expirationInSecs < 0) {
                throw new IllegalArgumentException("expiration must be greater than 0");
            }
            this.expirationInSecs = expirationInSecs;
            return this;
        }

        public Builder verbosity(Integer verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public Builder originKeyType(BufferWrapper.BufferType originKeyType) throws IllegalArgumentException {
            if (originKeyType != null) {
                this.originKeyType = originKeyType;
            }
            return this;
        }

        public Builder originKey(Object originKey) throws IllegalArgumentException {
            if (originKey != null) {
                this.originKey = originKey;
            }
            return this;
        }

        public Builder key(Buffer key) throws IllegalArgumentException {
            if (key != null) {
                int keyLen = key.remaining();
                if (keyLen > 250) {
                    throw new IllegalArgumentException("key length is in excess of 250bytes. keyLen=" + keyLen + "bytes");
                }
                this.key = key;
            }
            return this;
        }

        public Builder value(Buffer value) throws IllegalArgumentException {
            if (value != null) {
                int valueLen = value.remaining();
                if (valueLen > 0x100000) {
                    throw new IllegalArgumentException("value length is in excess of 1048576bytes. valueLen=" + valueLen + "bytes");
                }
                this.value = value;
            }
            return this;
        }

        public MemcachedRequest build() {
            return new MemcachedRequest(this);
        }

        public void recycle() {
            this.hasExtras = false;
            this.hasKey = false;
            this.hasValue = false;
            this.op = null;
            this.noReply = false;
            this.opaque = 0;
            this.cas = 0L;
            this.dataType = 0;
            this.vBucketId = 0;
            this.flags = null;
            this.delta = null;
            this.initial = null;
            this.expirationInSecs = null;
            this.verbosity = null;
            this.originKey = null;
            this.key = null;
            this.value = null;
            ThreadCache.putToCache(CACHE_IDX, (Object)this);
        }
    }
}

