/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached.zookeeper;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memcached.zookeeper.BarrierListener;
import org.glassfish.grizzly.utils.DataStructures;

public class ZKClient {
    private static final Logger logger = Grizzly.logger(ZKClient.class);
    private static final String JVM_AND_HOST_UNIQUE_ID = ManagementFactory.getRuntimeMXBean().getName();
    private static final int RETRY_COUNT_UNTIL_CONNECTED = 5;
    private static final String BASE_PATH = "/barrier";
    private static final String CURRENT_PATH = "/current";
    private static final String DATA_PATH = "/data";
    private static final String PARTICIPANTS_PATH = "/participants";
    private static final byte[] NO_DATA = new byte[0];
    private final Lock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();
    private final AtomicBoolean reconnectingFlag = new AtomicBoolean(false);
    private boolean connected;
    private Watcher.Event.KeeperState currentState;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final Map<String, BarrierListener> listenerMap = DataStructures.getConcurrentMap();
    private final ScheduledExecutorService scheduledExecutor;
    private ZooKeeper zooKeeper;
    private final String uniqueId;
    private final String uniqueIdPath;
    private final String basePath;
    private final String name;
    private final String zooKeeperServerList;
    private final long connectTimeoutInMillis;
    private final long sessionTimeoutInMillis;
    private final String rootPath;
    private final long commitDelayTimeInSecs;

    private ZKClient(Builder builder) {
        this.name = builder.name;
        this.uniqueId = JVM_AND_HOST_UNIQUE_ID + "_" + this.name;
        this.uniqueIdPath = ZKClient.normalizePath(this.uniqueId);
        this.rootPath = ZKClient.normalizePath(builder.rootPath);
        this.basePath = this.rootPath + BASE_PATH;
        this.zooKeeperServerList = builder.zooKeeperServerList;
        this.connectTimeoutInMillis = builder.connectTimeoutInMillis;
        this.sessionTimeoutInMillis = builder.sessionTimeoutInMillis;
        this.commitDelayTimeInSecs = builder.commitDelayTimeInSecs;
        this.scheduledExecutor = Executors.newScheduledThreadPool(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() throws IOException, InterruptedException {
        this.lock.lock();
        try {
            if (this.connected) {
                boolean bl = true;
                return bl;
            }
            this.zooKeeper = new ZooKeeper(this.zooKeeperServerList, (int)this.sessionTimeoutInMillis, (Watcher)new InternalWatcher(new Watcher(){

                public void process(WatchedEvent event) {
                }
            }));
            if (!this.ensureConnected(this.connectTimeoutInMillis)) {
                this.zooKeeper.close();
                this.currentState = Watcher.Event.KeeperState.Disconnected;
                this.connected = false;
            } else {
                this.connected = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "connected the zookeeper server successfully");
                }
            }
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        this.lock.lock();
        try {
            if (!this.connected) {
                return;
            }
            if (this.zooKeeper != null) {
                try {
                    this.zooKeeper.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentState = Watcher.Event.KeeperState.Disconnected;
            this.connected = false;
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "closed successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() throws IOException, InterruptedException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "trying to reconnect the zookeeper server");
        }
        boolean localReconnectingFlag = this.reconnectingFlag.get();
        this.lock.lock();
        try {
            if (!this.reconnectingFlag.compareAndSet(localReconnectingFlag, !localReconnectingFlag)) {
                return;
            }
            this.close();
            if (this.connect()) {
                for (String regionName : this.listenerMap.keySet()) {
                    this.registerEphemeralNodeAndWatcher(regionName);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "reconnected the zookeeper server successfully");
        }
    }

    public void shutdown() {
        if (!this.running.compareAndSet(true, false)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "shutting down or already shutted down");
            }
            return;
        }
        this.listenerMap.clear();
        this.close();
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "shutted down successfully");
        }
    }

    public String registerBarrier(String regionName, BarrierListener listener, byte[] initialData) {
        String currentDataPath;
        block11: {
            if (regionName == null) {
                throw new IllegalArgumentException("region name must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.listenerMap.put(regionName, listener);
            this.createWhenThereIsNoNode(this.rootPath, NO_DATA, CreateMode.PERSISTENT);
            this.createWhenThereIsNoNode(this.basePath, NO_DATA, CreateMode.PERSISTENT);
            String currentRegionPath = this.basePath + ZKClient.normalizePath(regionName);
            this.createWhenThereIsNoNode(currentRegionPath, NO_DATA, CreateMode.PERSISTENT);
            this.createWhenThereIsNoNode(currentRegionPath + CURRENT_PATH, NO_DATA, CreateMode.PERSISTENT);
            this.createWhenThereIsNoNode(currentRegionPath + PARTICIPANTS_PATH, NO_DATA, CreateMode.PERSISTENT);
            currentDataPath = currentRegionPath + DATA_PATH;
            boolean dataCreated = this.createWhenThereIsNoNode(currentDataPath, initialData == null ? NO_DATA : initialData, CreateMode.PERSISTENT);
            if (!dataCreated) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "the central data exists in the zookeeper server");
                }
                byte[] remoteDataBytes = this.getData(currentDataPath, false, null);
                try {
                    listener.onInit(regionName, currentDataPath, remoteDataBytes);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "failed to onInit. name=" + this.name + ", regionName=" + regionName + ", listener=" + listener, e);
                    }
                    break block11;
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "initial data was set because there was no remote data in the zookeeper server. initialData={0}", (Object)initialData);
            }
            try {
                listener.onInit(regionName, currentDataPath, null);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, "failed to onInit. name=" + this.name + ", regionName=" + regionName + ", listener=" + listener, e);
            }
        }
        this.registerEphemeralNodeAndWatcher(regionName);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "the path \"{0}\" will be watched. name={1}, regionName={2}", new Object[]{this.name, currentDataPath, regionName});
        }
        return currentDataPath;
    }

    private void registerEphemeralNodeAndWatcher(String regionName) {
        if (regionName == null) {
            return;
        }
        String currentRegionPath = this.basePath + ZKClient.normalizePath(regionName);
        String currentDataPath = currentRegionPath + DATA_PATH;
        this.createWhenThereIsNoNode(currentRegionPath + CURRENT_PATH + this.uniqueIdPath, NO_DATA, CreateMode.EPHEMERAL);
        this.exists(currentDataPath, new RegionWatcher(regionName));
    }

    private boolean createWhenThereIsNoNode(String path, byte[] data, CreateMode createMode) {
        if (this.exists(path, false) != null) {
            return false;
        }
        this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        return true;
    }

    public void unregisterBarrier(String regionName) {
        block4: {
            if (regionName == null) {
                return;
            }
            BarrierListener listener = this.listenerMap.remove(regionName);
            if (listener != null) {
                try {
                    listener.onDestroy(regionName);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, "failed to onDestroy. name=" + this.name + ", regionName=" + regionName + ", listener=" + listener, e);
                }
            }
        }
    }

    public String create(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this create()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ZKClient.this.zooKeeper.create(path, data, acl, createMode);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"create\". path=" + path + ", data=" + Arrays.toString(data), e);
            }
            return null;
        }
    }

    public Stat exists(final String path, final boolean watch) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this exists()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    return ZKClient.this.zooKeeper.exists(path, watch);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"exists\". path=" + path, e);
            }
            return null;
        }
    }

    public Stat exists(final String path, final Watcher watch) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this exists()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    return ZKClient.this.zooKeeper.exists(path, (Watcher)new InternalWatcher(watch));
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"exists\". path=" + path, e);
            }
            return null;
        }
    }

    public List<String> getChildren(final String path, final boolean watch) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this getChildren()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ZKClient.this.zooKeeper.getChildren(path, watch);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"getChildren\". path=" + path, e);
            }
            return null;
        }
    }

    public List<String> getChildren(final String path, final Watcher watcher) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this getChildren()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ZKClient.this.zooKeeper.getChildren(path, (Watcher)new InternalWatcher(watcher));
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"getChildren\". path=" + path, e);
            }
            return null;
        }
    }

    public byte[] getData(final String path, final boolean watch, final Stat stat) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this getData()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZKClient.this.zooKeeper.getData(path, watch, stat);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"getData\". path=" + path, e);
            }
            return null;
        }
    }

    public byte[] getData(final String path, final Watcher watcher) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this getData()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZKClient.this.zooKeeper.getData(path, (Watcher)new InternalWatcher(watcher), null);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"getData\". path=" + path, e);
            }
            return null;
        }
    }

    public Stat setData(final String path, final byte[] data, final int version) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this setData()");
            }
            return null;
        }
        try {
            return this.retryUntilConnected(new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    return ZKClient.this.zooKeeper.setData(path, data, version);
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"setData\". path=" + path + ", data=" + Arrays.toString(data) + ", version=" + version, e);
            }
            return null;
        }
    }

    public boolean delete(final String path, final int version) {
        if (this.zooKeeper == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "this client has not been connected. please call ZKClient#connect() method before calling this delete()");
            }
            return false;
        }
        try {
            this.retryUntilConnected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ZKClient.this.zooKeeper.delete(path, version);
                    return true;
                }
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to do \"delete\". path=" + path + ", version=" + version, e);
            }
            return false;
        }
        return false;
    }

    private <T> T retryUntilConnected(Callable<T> callable) throws Exception {
        for (int i = 0; i < 5; ++i) {
            try {
                return callable.call();
            }
            catch (KeeperException.ConnectionLossException cle) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "the callable will be retried because of ConnectionLossException");
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "the callable will be retried because of ConnectionLossException", cle);
                }
                this.reconnect();
                continue;
            }
            catch (KeeperException.SessionExpiredException see) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "the callable will be retried because of SessionExpiredException");
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "the callable will be retried because of SessionExpiredException", see);
                }
                this.reconnect();
            }
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "failed to retry. retryCount={0}", 5);
        }
        return null;
    }

    private boolean ensureConnected(long timeoutInMillis) {
        Date timeoutDate = timeoutInMillis < 0L ? null : new Date(System.currentTimeMillis() + timeoutInMillis);
        boolean stillWaiting = true;
        while (this.currentState != Watcher.Event.KeeperState.SyncConnected) {
            if (!stillWaiting) {
                return false;
            }
            try {
                if (timeoutDate == null) {
                    this.lockCondition.await();
                    continue;
                }
                stillWaiting = this.lockCondition.awaitUntil(timeoutDate);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processStateChanged(WatchedEvent event) {
        boolean isStateChangedEvent;
        block10: {
            if (event == null) {
                throw new IllegalArgumentException("event must not be null");
            }
            Watcher.Event.KeeperState eventState = event.getState();
            String eventPath = event.getPath();
            if (eventPath == null) {
                this.lock.lock();
                try {
                    this.currentState = eventState;
                    this.lockCondition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
                isStateChangedEvent = true;
            } else {
                isStateChangedEvent = false;
            }
            if (eventState == Watcher.Event.KeeperState.Expired) {
                try {
                    this.reconnect();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block10;
                    logger.log(Level.SEVERE, "failed to reconnect the zookeeper server", e);
                }
            }
        }
        return isStateChangedEvent;
    }

    public String toString() {
        return "ZKClient{connected=" + this.connected + ", running=" + this.running + ", currentState=" + this.currentState + ", listenerMap=" + this.listenerMap + ", name='" + this.name + '\'' + ", uniqueId='" + this.uniqueId + '\'' + ", uniqueIdPath='" + this.uniqueIdPath + '\'' + ", rootPath='" + this.rootPath + '\'' + ", basePath='" + this.basePath + '\'' + ", zooKeeperServerList='" + this.zooKeeperServerList + '\'' + ", connectTimeoutInMillis=" + this.connectTimeoutInMillis + ", sessionTimeoutInMillis=" + this.sessionTimeoutInMillis + ", commitDelayTimeInSecs=" + this.commitDelayTimeInSecs + '}';
    }

    private static String normalizePath(String path) {
        if (path == null) {
            return "/";
        }
        String temp = path.trim();
        while (temp.length() > 1 && temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        StringBuilder builder = new StringBuilder(64);
        if (!temp.startsWith("/")) {
            builder.append('/');
        }
        builder.append(temp);
        return builder.toString();
    }

    public static class Builder {
        private static final String DEFAULT_ROOT_PATH = "/";
        private static final long DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 5000L;
        private static final long DEFAULT_SESSION_TIMEOUT_IN_MILLIS = 30000L;
        private static final long DEFAULT_COMMIT_DELAY_TIME_IN_SECS = 60L;
        private final String name;
        private final String zooKeeperServerList;
        private String rootPath = "/";
        private long connectTimeoutInMillis = 5000L;
        private long sessionTimeoutInMillis = 30000L;
        private long commitDelayTimeInSecs = 60L;

        public Builder(String name, String zooKeeperServerList) {
            this.name = name;
            this.zooKeeperServerList = zooKeeperServerList;
        }

        public Builder rootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder connectTimeoutInMillis(long connectTimeoutInMillis) {
            this.connectTimeoutInMillis = connectTimeoutInMillis;
            return this;
        }

        public Builder sessionTimeoutInMillis(long sessionTimeoutInMillis) {
            this.sessionTimeoutInMillis = sessionTimeoutInMillis;
            return this;
        }

        public Builder commitDelayTimeInSecs(long commitDelayTimeInSecs) {
            this.commitDelayTimeInSecs = commitDelayTimeInSecs;
            return this;
        }

        public ZKClient build() {
            return new ZKClient(this);
        }
    }

    private class RegionWatcher
    implements Watcher {
        private final String regionName;
        private final List<String> aliveNodesExceptMyself = new ArrayList<String>();
        private final Set<String> toBeCompleted = new HashSet<String>();
        private final Lock regionLock = new ReentrantLock();
        private volatile boolean isSynchronizing = false;
        private byte[] remoteDataBytes = null;
        private Stat remoteDataStat = null;

        private RegionWatcher(String regionName) {
            this.regionName = regionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(WatchedEvent event) {
            if (event == null) {
                return;
            }
            if (ZKClient.this.listenerMap.get(this.regionName) == null) {
                if (!logger.isLoggable(Level.INFO)) return;
                logger.log(Level.INFO, "this event will be ignored because this region already has unregistered. name={0}, regionName={1}, eventState={2}, eventType={3}, eventPath={4}, watcher={5}", new Object[]{ZKClient.this.name, this.regionName, event.getState(), event.getType(), event.getPath(), this});
                return;
            }
            Watcher.Event.KeeperState eventState = event.getState();
            String eventPath = event.getPath();
            Watcher.Event.EventType eventType = event.getType();
            String currentRegionPath = ZKClient.this.basePath + ZKClient.normalizePath(this.regionName);
            String currentNodesPath = currentRegionPath + ZKClient.CURRENT_PATH;
            String currentParticipantPath = currentRegionPath + ZKClient.PARTICIPANTS_PATH;
            String currentDataPath = currentRegionPath + ZKClient.DATA_PATH;
            if ((eventType == Watcher.Event.EventType.NodeDataChanged || eventType == Watcher.Event.EventType.NodeCreated) && currentDataPath.equals(eventPath)) {
                byte[] currentDataBytes;
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "the central data has been changed in the remote zookeeper server. name={0}, regionName={1}", new Object[]{ZKClient.this.name, this.regionName});
                }
                Stat currentDataStat = new Stat();
                this.regionLock.lock();
                try {
                    this.isSynchronizing = true;
                    this.aliveNodesExceptMyself.clear();
                    this.toBeCompleted.clear();
                    List<String> currentNodes = ZKClient.this.getChildren(currentNodesPath, this);
                    this.aliveNodesExceptMyself.addAll(currentNodes);
                    this.aliveNodesExceptMyself.remove(ZKClient.this.uniqueId);
                    for (String node : currentNodes) {
                        String participant = currentParticipantPath + "/" + node;
                        if (ZKClient.this.exists(participant, this) == null) {
                            this.toBeCompleted.add(participant);
                            continue;
                        }
                        this.toBeCompleted.remove(participant);
                    }
                    currentDataBytes = ZKClient.this.getData(currentDataPath, false, currentDataStat);
                    this.remoteDataBytes = currentDataBytes;
                    this.remoteDataStat = currentDataStat;
                }
                finally {
                    this.regionLock.unlock();
                }
                if ((currentDataBytes == null || ZKClient.this.create(currentParticipantPath + ZKClient.this.uniqueIdPath, NO_DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL) == null) && logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the remote changes");
                }
                ZKClient.this.exists(currentDataPath, this);
                return;
            }
            if (this.isSynchronizing && eventType == Watcher.Event.EventType.NodeDeleted && currentDataPath.equals(eventPath)) {
                this.regionLock.lock();
                try {
                    if (this.isSynchronizing) {
                        this.isSynchronizing = false;
                        if (!this.aliveNodesExceptMyself.isEmpty() || !this.toBeCompleted.isEmpty()) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.log(Level.WARNING, "the central data deleted in the remote zookeeper server while preparing to synchronize the data. name={0}, regionName={1}", new Object[]{ZKClient.this.name, this.regionName});
                            }
                            this.aliveNodesExceptMyself.clear();
                            this.toBeCompleted.clear();
                        }
                        this.remoteDataBytes = null;
                        this.remoteDataStat = null;
                    }
                }
                finally {
                    this.regionLock.unlock();
                }
                ZKClient.this.exists(currentDataPath, this);
                return;
            }
            if (this.isSynchronizing && (eventType == Watcher.Event.EventType.NodeCreated || eventType == Watcher.Event.EventType.NodeDeleted) && eventPath != null && eventPath.startsWith(currentParticipantPath)) {
                this.regionLock.lock();
                try {
                    if (!this.isSynchronizing) return;
                    this.toBeCompleted.remove(eventPath);
                    if (!this.toBeCompleted.isEmpty()) return;
                    this.isSynchronizing = false;
                    this.scheduleCommit(event, currentDataPath, currentParticipantPath, this.remoteDataBytes, this.remoteDataStat);
                    this.remoteDataBytes = null;
                    this.remoteDataStat = null;
                    return;
                }
                finally {
                    this.regionLock.unlock();
                }
            } else if (this.isSynchronizing && eventType == Watcher.Event.EventType.NodeChildrenChanged && currentNodesPath.equals(eventPath)) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "some clients are failed or added while preparing to syncronize the data. name={0}, regionName={1}", new Object[]{ZKClient.this.name, this.regionName});
                }
                this.regionLock.lock();
                try {
                    if (!this.isSynchronizing) return;
                    List<String> currentNodes = ZKClient.this.getChildren(currentNodesPath, this);
                    currentNodes.remove(ZKClient.this.uniqueIdPath);
                    ArrayList<String> failureNodes = new ArrayList<String>(this.aliveNodesExceptMyself);
                    failureNodes.removeAll(currentNodes);
                    for (String node : failureNodes) {
                        String participant = currentParticipantPath + "/" + node;
                        this.toBeCompleted.remove(participant);
                    }
                    if (!this.toBeCompleted.isEmpty()) return;
                    this.isSynchronizing = false;
                    this.scheduleCommit(event, currentDataPath, currentParticipantPath, this.remoteDataBytes, this.remoteDataStat);
                    this.remoteDataBytes = null;
                    this.remoteDataStat = null;
                    return;
                }
                finally {
                    this.regionLock.unlock();
                }
            } else {
                if (!logger.isLoggable(Level.FINE)) return;
                logger.log(Level.FINE, "not interested. name={0}, regionName={1}, eventState={2}, eventType={3}, eventPath={4}, watcher={5}", new Object[]{ZKClient.this.name, this.regionName, eventState, eventType, eventPath, this});
            }
        }

        private void scheduleCommit(final WatchedEvent event, final String currentDataPath, final String currentParticipantPath, final byte[] currentDataBytes, Stat currnetDataStat) {
            Long scheduled;
            long remaining;
            if (event == null || currentDataPath == null || currentDataBytes == null || currnetDataStat == null) {
                return;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "all clients are prepared. name={0}, regionName={1}, commitDelayTimeInSecs={2}", new Object[]{ZKClient.this.name, this.regionName, ZKClient.this.commitDelayTimeInSecs});
            }
            if ((remaining = (scheduled = Long.valueOf(currnetDataStat.getMtime() + TimeUnit.SECONDS.toMillis(ZKClient.this.commitDelayTimeInSecs))) - System.currentTimeMillis()) < 0L) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "commitDelayTimeInSecs may be too small. so we will commit immediately. name={0}, regionName={1}, scheduledTime=before {2}ms", new Object[]{ZKClient.this.name, this.regionName, -remaining});
                }
            } else {
                Date scheduledDate = new Date(scheduled);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "the changes of the central data will be applied. name={0}, regionName={1}, scheduledDate={2}, data={3}, dataStat={4}", new Object[]{ZKClient.this.name, this.regionName, scheduledDate.toString(), currentDataBytes, currnetDataStat});
                }
            }
            ZKClient.this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        BarrierListener listener = (BarrierListener)ZKClient.this.listenerMap.get(RegionWatcher.this.regionName);
                        if (listener == null) {
                            if (logger.isLoggable(Level.INFO)) {
                                logger.log(Level.INFO, "this commit will be ignored because this region already has unregistered. eventState={0}, eventType={1}, eventPath={2}, watcher={3}", new Object[]{event.getState(), event.getType(), event.getPath(), this});
                            }
                            return;
                        }
                        try {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "name={0}, regionName={1}, scheduledTime={2}ms, commit time={3}ms", new Object[]{ZKClient.this.name, RegionWatcher.this.regionName, scheduled, System.currentTimeMillis()});
                            }
                            listener.onCommit(RegionWatcher.this.regionName, currentDataPath, currentDataBytes);
                            if (logger.isLoggable(Level.INFO)) {
                                logger.log(Level.INFO, "committed successfully. name={0}, regionName={1}, listener={2}", new Object[]{ZKClient.this.name, RegionWatcher.this.regionName, listener});
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.WARNING)) break block7;
                            logger.log(Level.WARNING, "failed to onCommit. name=" + ZKClient.this.name + ", regionName=" + RegionWatcher.this.regionName + ", listener=" + listener, e);
                        }
                    }
                    String path = currentParticipantPath + ZKClient.this.uniqueIdPath;
                    if (!ZKClient.this.delete(path, -1) && logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "there is no the participant path to be deleted because it may already has been closed. name={0}, regionName={1}, path={2}", new Object[]{ZKClient.this.name, RegionWatcher.this.regionName, path});
                    }
                }
            }, remaining, TimeUnit.MILLISECONDS);
        }

        public String toString() {
            return "RegionWatcher{regionName='" + this.regionName + '\'' + '}';
        }
    }

    private class InternalWatcher
    implements Watcher {
        private final Watcher inner;

        private InternalWatcher(Watcher inner) {
            this.inner = inner;
        }

        public void process(WatchedEvent event) {
            if (event != null && logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "received event. eventState={0}, eventType={1}, eventPath={2}, watcher={3}", new Object[]{event.getState(), event.getType(), event.getPath(), this});
            }
            if (!ZKClient.this.running.get()) {
                if (event != null && logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "this event will be ignored because this client is shutting down or already has shutted down. name={0}, eventState={1}, eventType={2}, eventPath={3}, watcher={4}", new Object[]{ZKClient.this.name, event.getState(), event.getType(), event.getPath(), this});
                }
                return;
            }
            if (ZKClient.this.processStateChanged(event)) {
                return;
            }
            if (this.inner != null) {
                this.inner.process(event);
            }
        }

        public String toString() {
            return "InternalWatcher{inner=" + this.inner + '}';
        }
    }
}

