/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import com.google.common.base.Objects;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;

public final class Tuples {
    private Tuples() {
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new PairImpl<L, R>(left, right);
    }

    public static <L, R> Pair<R, L> swap(Pair<L, R> pair) {
        return new PairImpl<R, L>(pair.right(), pair.left());
    }

    public static <T> Ref<T> of(T value) {
        return new DefaultRefImpl<T>(value);
    }

    public static <T> Ref<T> emptyRef() {
        return new DefaultRefImpl();
    }

    public static <T> Ref<T> immutableRef(T value) {
        return new ImmutableRefImpl<T>(value);
    }

    private static final class DefaultRefImpl<T>
    implements Ref<T> {
        private T reference;

        public DefaultRefImpl() {
            this.reference = null;
        }

        public DefaultRefImpl(T value) {
            this.reference = value;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public void set(T value) throws IllegalStateException {
            this.reference = value;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("reference", this.reference).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultRefImpl other = (DefaultRefImpl)obj;
            return this.reference == other.reference || this.reference != null && this.reference.equals(other.reference);
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + (this.reference != null ? this.reference.hashCode() : 0);
            return hash;
        }
    }

    private static final class ImmutableRefImpl<T>
    implements Ref<T> {
        private final T reference;

        public ImmutableRefImpl(T value) {
            this.reference = value;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public void set(T value) throws IllegalStateException {
            throw new IllegalStateException("This implementation of Ref interface is immutable.");
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("reference", this.reference).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableRefImpl other = (ImmutableRefImpl)obj;
            return this.reference == other.reference || this.reference != null && this.reference.equals(other.reference);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.reference != null ? this.reference.hashCode() : 0);
            return hash;
        }
    }

    private static final class PairImpl<L, R>
    implements Pair<L, R> {
        private final L left;
        private final R right;

        public PairImpl(L left, R right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public L left() {
            return this.left;
        }

        @Override
        public R right() {
            return this.right;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("left", this.left).add("right", this.right).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PairImpl other = (PairImpl)obj;
            if (!(this.left == other.left || this.left != null && this.left.equals(other.left))) {
                return false;
            }
            return this.right == other.right || this.right != null && this.right.equals(other.right);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.left != null ? this.left.hashCode() : 0);
            hash = 83 * hash + (this.right != null ? this.right.hashCode() : 0);
            return hash;
        }
    }
}

