/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MessageProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MutableEntity;
import org.glassfish.jersey.message.internal.MutableHeaders;

abstract class AbstractMutableMessage<M extends AbstractMutableMessage> {
    private MutableHeaders headers;
    private MutableEntity entity;
    private Map<String, Object> properties;

    protected AbstractMutableMessage() {
        this.headers = new MutableHeaders();
        this.properties = Maps.newHashMap();
        this.entity = MutableEntity.empty(this);
    }

    protected AbstractMutableMessage(AbstractMutableMessage<?> that) {
        this.headers = new MutableHeaders(that.headers);
        this.entity = new MutableEntity(this, that.entity);
        this.properties = Maps.newHashMap(that.properties);
    }

    public AbstractMutableMessage(MultivaluedMap<String, String> headers, InputStream entity, Map<String, Object> properties) {
        this();
        this.headers.replaceAll((MultivaluedMap)headers);
        this.entity.content(entity);
        this.properties.putAll(properties);
    }

    public MutableEntity entity() {
        return this.entity;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public MessageBodyWorkers entityWorkers() {
        return this.entity.workers();
    }

    public M properties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return (M)this;
    }

    public M property(String name, Object value) {
        this.properties.put(name, value);
        return (M)this;
    }

    public M clearProperties() {
        this.properties.clear();
        return (M)this;
    }

    public M build() {
        return (M)this;
    }

    public M toBuilder() {
        return (M)this;
    }

    public Type type() {
        return this.entity.type();
    }

    public boolean isEmpty() {
        return this.entity.isEmpty();
    }

    public M content(InputStream content) {
        this.entity.content(content);
        return (M)this;
    }

    public <T> M content(Object content, GenericType<T> type) {
        this.entity.content(content, (GenericType)type);
        return (M)this;
    }

    public M content(Object content, Type type) {
        this.entity.content(content, type);
        return (M)this;
    }

    public M content(Object content) {
        this.entity.content(content);
        return (M)this;
    }

    public Object content() {
        return this.entity.content();
    }

    public <T> T content(GenericType<T> type) {
        return this.entity.content(type);
    }

    public <T> T content(Class<T> type) {
        return this.entity.content(type);
    }

    public <T> T content(GenericType<T> type, Annotation[] annotations) {
        return this.entity.content(type, annotations);
    }

    public <T> T content(Class<T> type, Annotation[] annotations) {
        return this.entity.content(type, annotations);
    }

    public void bufferEntity() throws MessageProcessingException {
        this.entity.bufferEntity();
    }

    public M writeAnnotations(Annotation[] annotations) {
        this.entity.writeAnnotations(annotations);
        return (M)this;
    }

    public M entityWorkers(MessageBodyWorkers workers) {
        this.entity.workers(workers);
        return (M)this;
    }

    public M replaceAll(MultivaluedMap<String, String> headers) {
        this.headers.replaceAll((MultivaluedMap)headers);
        return (M)this;
    }

    public M replace(String name, Iterable<? extends Object> values) {
        this.headers.replace(name, (Iterable)values);
        return (M)this;
    }

    public M remove(String name) {
        this.headers.remove(name);
        return (M)this;
    }

    public M headers(Map<String, List<String>> headers) {
        this.headers.headers((Map)headers);
        return (M)this;
    }

    public M headers(MultivaluedMap<String, ? extends Object> headers) {
        this.headers.headers((MultivaluedMap)headers);
        return (M)this;
    }

    public M headers(String name, Iterable<? extends Object> values) {
        this.headers.headers(name, (Iterable)values);
        return (M)this;
    }

    public M headers(String name, Object ... values) {
        this.headers.headers(name, values);
        return (M)this;
    }

    public M headers(String name, String ... values) {
        this.headers.headers(name, values);
        return (M)this;
    }

    public MultivaluedMap<String, String> headers() {
        return this.headers.headers();
    }

    public List<String> headerValues(String name) {
        return this.headers.headerValues(name);
    }

    public M header(String name, Object value) {
        this.headers.header(name, value);
        return (M)this;
    }

    public M header(String name, String value) {
        this.headers.header(name, value);
        return (M)this;
    }

    public String header(String name) {
        return this.headers.header(name);
    }

    public M cookie(Cookie cookie) {
        this.headers.header("Cookie", cookie);
        return (M)this;
    }
}

