/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MessageProcessingException;
import javax.ws.rs.core.RequestHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.HttpHelper;
import org.glassfish.jersey.message.internal.MatchingEntityTag;
import org.glassfish.jersey.message.internal.Request;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.message.internal.VariantSelector;

final class JaxrsRequestView
implements javax.ws.rs.core.Request {
    private Request wrapped;

    public JaxrsRequestView(Request wrapped) {
        this.wrapped = wrapped;
    }

    static Request unwrap(javax.ws.rs.core.Request request) {
        if (request instanceof JaxrsRequestView) {
            return ((JaxrsRequestView)request).wrapped;
        }
        throw new IllegalArgumentException(String.format("Request class type '%s' not supported.", request.getClass().getName()));
    }

    public String getMethod() {
        return this.wrapped.method();
    }

    public URI getUri() {
        return this.wrapped.uri();
    }

    public RequestHeaders getHeaders() {
        return this.wrapped.getJaxrsHeaders();
    }

    public Object getEntity() {
        return this.wrapped.content();
    }

    public <T> T readEntity(Class<T> type) throws MessageProcessingException {
        return this.wrapped.content(type);
    }

    public <T> T readEntity(GenericType<T> entityType) throws MessageProcessingException {
        return this.wrapped.content(entityType);
    }

    public <T> T readEntity(Class<T> type, Annotation[] annotations) throws MessageProcessingException {
        return this.wrapped.content(type, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws MessageProcessingException {
        return this.wrapped.content(entityType, annotations);
    }

    public boolean hasEntity() {
        return !this.wrapped.isEmpty();
    }

    public boolean isEntityRetrievable() {
        return this.wrapped.isEntityRetrievable();
    }

    public void bufferEntity() throws MessageProcessingException {
        this.wrapped.bufferEntity();
    }

    public void close() throws MessageProcessingException {
        this.wrapped.close();
    }

    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("The list of variants is null or empty");
        }
        return VariantSelector.selectVariant(this.wrapped, variants);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        if (eTag == null) {
            throw new IllegalArgumentException("Parameter 'eTag' cannot be null.");
        }
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r != null) {
            return r;
        }
        return this.evaluateIfNoneMatch(eTag);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException("Parameter 'lastModified' cannot be null.");
        }
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r != null) {
            return r;
        }
        return this.evaluateIfModifiedSince(lastModifiedTime);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null || eTag == null) {
            throw new IllegalArgumentException("Parameters 'lastModified' and 'eTag' cannot be null.");
        }
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r != null) {
            return r;
        }
        long lastModifiedTime = lastModified.getTime();
        r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r != null) {
            return r;
        }
        boolean isGetOrHead = this.getMethod().equals("GET") || this.getMethod().equals("HEAD");
        Set<MatchingEntityTag> matchingTags = HttpHelper.getIfNoneMatch(this.wrapped);
        if (matchingTags != null && (r = this.evaluateIfNoneMatch(eTag, matchingTags, isGetOrHead)) == null) {
            return r;
        }
        String ifModifiedSinceHeader = this.wrapped.header("If-Modified-Since");
        if (ifModifiedSinceHeader != null && ifModifiedSinceHeader.length() > 0 && isGetOrHead && (r = this.evaluateIfModifiedSince(lastModifiedTime, ifModifiedSinceHeader)) != null) {
            r.tag(eTag);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        Set<MatchingEntityTag> matchingTags = HttpHelper.getIfMatch(this.wrapped);
        if (matchingTags == null) {
            return null;
        }
        return Responses.preconditionFailed(this.wrapped.toJaxrsRequest());
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        Set<MatchingEntityTag> matchingTags = HttpHelper.getIfMatch(this.wrapped);
        if (matchingTags == null) {
            return null;
        }
        if (eTag.isWeak()) {
            return Responses.preconditionFailed(this.wrapped.toJaxrsRequest());
        }
        if (matchingTags != MatchingEntityTag.ANY_MATCH && !matchingTags.contains(eTag)) {
            return Responses.preconditionFailed(this.wrapped.toJaxrsRequest());
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        Set<MatchingEntityTag> matchingTags = HttpHelper.getIfNoneMatch(this.wrapped);
        if (matchingTags == null) {
            return null;
        }
        String httpMethod = this.getMethod();
        return this.evaluateIfNoneMatch(eTag, matchingTags, httpMethod.equals("GET") || httpMethod.equals("HEAD"));
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag, Set<? super MatchingEntityTag> matchingTags, boolean isGetOrHead) {
        if (isGetOrHead) {
            if (matchingTags == MatchingEntityTag.ANY_MATCH) {
                return Responses.notModified(eTag, this.wrapped.toJaxrsRequest());
            }
            if (matchingTags.contains(eTag) || matchingTags.contains(new EntityTag(eTag.getValue(), !eTag.isWeak()))) {
                return Responses.notModified(eTag, this.wrapped.toJaxrsRequest());
            }
        } else {
            if (eTag.isWeak()) {
                return null;
            }
            if (matchingTags == MatchingEntityTag.ANY_MATCH || matchingTags.contains(eTag)) {
                return Responses.preconditionFailed(this.wrapped.toJaxrsRequest());
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(long lastModified) {
        String ifUnmodifiedSinceHeader = this.wrapped.header("If-Unmodified-Since");
        if (ifUnmodifiedSinceHeader != null && ifUnmodifiedSinceHeader.length() > 0) {
            try {
                long ifUnmodifiedSince = HttpHeaderReader.readDate(ifUnmodifiedSinceHeader).getTime();
                if (JaxrsRequestView.roundDown(lastModified) > ifUnmodifiedSince) {
                    return Responses.preconditionFailed(this.wrapped.toJaxrsRequest());
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified) {
        String ifModifiedSinceHeader = this.wrapped.header("If-Modified-Since");
        if (ifModifiedSinceHeader == null || ifModifiedSinceHeader.length() == 0) {
            return null;
        }
        String httpMethod = this.getMethod();
        if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
            return this.evaluateIfModifiedSince(lastModified, ifModifiedSinceHeader);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified, String ifModifiedSinceHeader) {
        try {
            long ifModifiedSince = HttpHeaderReader.readDate(ifModifiedSinceHeader).getTime();
            if (JaxrsRequestView.roundDown(lastModified) <= ifModifiedSince) {
                return Responses.notModified(this.wrapped.toJaxrsRequest());
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return null;
    }

    private static long roundDown(long time) {
        return time - time % 1000L;
    }

    public Map<String, Object> getProperties() {
        return this.wrapped.properties();
    }
}

