/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

public class LinkProvider
implements HeaderDelegateProvider<Link> {
    @Override
    public boolean supports(Class<?> type) {
        return Link.class.isAssignableFrom(type);
    }

    public Link fromString(String value) throws IllegalArgumentException {
        Link.Builder lb;
        StringTokenizer st = new StringTokenizer(value.trim(), "<>;=\"", true);
        try {
            this.checkToken(st, "<");
            lb = Link.fromUri((String)st.nextToken().trim());
            this.checkToken(st, ">");
            while (st.hasMoreTokens()) {
                this.checkToken(st, ";");
                String n = st.nextToken().trim();
                this.checkToken(st, "=");
                this.checkToken(st, "\"");
                String v = st.nextToken();
                this.checkToken(st, "\"");
                lb.param(n, v);
            }
        }
        catch (Throwable e) {
            lb = null;
        }
        if (lb == null) {
            throw new IllegalArgumentException("Unable to parse link " + value);
        }
        return lb.build();
    }

    private void checkToken(StringTokenizer st, String expected) throws AssertionError {
        String token;
        while ((token = st.nextToken().trim()).length() == 0) {
        }
        if (!token.equals(expected)) {
            throw new AssertionError((Object)("Expected token " + expected + " but found " + token));
        }
    }

    public String toString(Link value) {
        MultivaluedMap map = value.getParams();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(value.getUri()).append('>');
        for (Map.Entry entry : map.entrySet()) {
            sb.append("; ").append((String)entry.getKey()).append("=\"");
            boolean first = true;
            for (String v : (List)entry.getValue()) {
                sb.append(first ? "" : " ");
                sb.append(v);
                first = false;
            }
            sb.append("\"");
        }
        return sb.toString();
    }
}

