/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.RequestHeaders;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMutableMessage;
import org.glassfish.jersey.message.internal.JaxrsRequestBuilderView;
import org.glassfish.jersey.message.internal.JaxrsRequestHeadersView;
import org.glassfish.jersey.message.internal.JaxrsRequestView;
import org.glassfish.jersey.message.internal.Request;
import org.glassfish.jersey.uri.UriComponent;

class MutableRequest
extends AbstractMutableMessage<MutableRequest>
implements Request,
Request.Builder {
    private static URI DEFAULT_BASE_URI = URI.create("/");
    private transient javax.ws.rs.core.Request jaxrsView;
    private transient Request.RequestBuilder jaxrsBuilderView;
    private transient RequestHeaders jaxrsHeadersView;
    private URI baseUri;
    private URI requestUri;
    private String encodedRelativePath = null;
    private String decodedRelativePath = null;
    private String method;

    MutableRequest(MutableRequest that) {
        super(that);
        this.baseUri = that.baseUri;
        this.requestUri = that.requestUri;
        this.method = that.method;
    }

    MutableRequest(URI baseUri, URI requestUri, String method) {
        this.baseUri = baseUri != null ? this.normalizeBaseUri(baseUri) : DEFAULT_BASE_URI;
        this.requestUri = requestUri.normalize();
        this.method = method;
    }

    MutableRequest(URI baseUri, URI requestUri, String method, InputStream inputStream) {
        this.baseUri = baseUri != null ? this.normalizeBaseUri(baseUri) : DEFAULT_BASE_URI;
        this.requestUri = requestUri.normalize();
        this.method = method;
        this.entity().rawEntityStream(inputStream);
    }

    MutableRequest(String baseUri, String requestUri, String method) {
        this.baseUri = baseUri != null ? this.normalizeBaseUri(URI.create(baseUri)) : DEFAULT_BASE_URI;
        this.requestUri = URI.create(requestUri).normalize();
        this.method = method;
    }

    MutableRequest(Request request) {
        super(request.headers(), request.content(InputStream.class), request.properties());
        this.baseUri = request.baseUri();
        this.requestUri = request.uri();
        this.method = request.method();
    }

    private URI normalizeBaseUri(URI baseUri) {
        return baseUri.normalize();
    }

    @Override
    public URI baseUri() {
        return this.baseUri;
    }

    @Override
    public String relativePath(boolean decode) {
        if (decode) {
            if (this.decodedRelativePath != null) {
                return this.decodedRelativePath;
            }
            this.decodedRelativePath = UriComponent.decode(this.encodedRelativePath(), UriComponent.Type.PATH);
            return this.decodedRelativePath;
        }
        return this.encodedRelativePath();
    }

    private String encodedRelativePath() {
        String applicationRootUriRawPath;
        if (this.encodedRelativePath != null) {
            return this.encodedRelativePath;
        }
        String requestUriRawPath = this.requestUri.getRawPath();
        String result = this.baseUri == null ? requestUriRawPath : ((applicationRootUriRawPath = this.baseUri.getRawPath()).length() > requestUriRawPath.length() ? "" : requestUriRawPath.substring(applicationRootUriRawPath.length()));
        if (result.isEmpty()) {
            result = "/";
        }
        this.encodedRelativePath = result.charAt(0) == '/' ? result : '/' + result;
        return this.encodedRelativePath;
    }

    @Override
    public URI uri() {
        return this.requestUri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public MutableRequest uri(String uri) {
        this.requestUri = URI.create(uri);
        return this;
    }

    @Override
    public MutableRequest uri(URI uri) {
        this.requestUri = uri;
        return this;
    }

    @Override
    public Request.Builder uris(String baseUri, String requestUri) {
        this.baseUri = URI.create(baseUri);
        this.requestUri = URI.create(requestUri);
        return this;
    }

    @Override
    public Request.Builder uris(URI baseUri, URI requestUri) {
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        return this;
    }

    @Override
    public MutableRequest method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MutableRequest clone() {
        return new MutableRequest(this);
    }

    @Override
    public javax.ws.rs.core.Request toJaxrsRequest() {
        if (this.jaxrsView == null) {
            this.jaxrsView = new JaxrsRequestView(this);
        }
        return this.jaxrsView;
    }

    @Override
    public Request.RequestBuilder toJaxrsRequestBuilder() {
        if (this.jaxrsBuilderView == null) {
            this.jaxrsBuilderView = new JaxrsRequestBuilderView(this);
        }
        return this.jaxrsBuilderView;
    }

    @Override
    public RequestHeaders getJaxrsHeaders() {
        if (this.jaxrsHeadersView == null) {
            this.jaxrsHeadersView = new JaxrsRequestHeadersView(this);
        }
        return this.jaxrsHeadersView;
    }

    @Override
    public boolean isEntityRetrievable() {
        return this.isEmpty() || this.type() != null;
    }

    @Override
    public Request.Builder workers(MessageBodyWorkers workers) {
        this.entityWorkers(workers);
        return this;
    }

    @Override
    public MessageBodyWorkers workers() {
        return this.entityWorkers();
    }
}

