/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Monitor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;

class AsyncInflectorAdapter
extends AbstractFuture<Response>
implements Inflector<Request, ListenableFuture<Response>>,
InvocationContext {
    private static final Logger LOGGER = Logger.getLogger(AsyncInflectorAdapter.class.getName());
    private final LazyUid id = new LazyUid();
    private InvocationContext.State executionState = InvocationContext.State.RUNNING;
    private final Monitor executionStateMonitor = new Monitor();
    private final Monitor.Guard resumableState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING || AsyncInflectorAdapter.this.executionState == InvocationContext.State.SUSPENDED;
        }
    };
    private final Monitor.Guard runningState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING;
        }
    };
    private final Monitor.Guard cancellableState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING || AsyncInflectorAdapter.this.executionState == InvocationContext.State.SUSPENDED;
        }
    };
    private long defaultTimeout = 0L;
    private TimeUnit defaultTimeoutUnit = TimeUnit.MILLISECONDS;
    private AtomicReference<Response> defaultResponse = new AtomicReference();
    private final Inflector<Request, Response> wrapped;
    private final InvocationCallback callback;

    AsyncInflectorAdapter(Inflector<Request, Response> wrapped, InvocationCallback callback) {
        this.wrapped = wrapped;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Response> apply(Request request) {
        block7: {
            try {
                Response response = this.wrapped.apply(request);
                if (this.executionStateMonitor.enterIf(this.runningState)) {
                    try {
                        this.executionState = InvocationContext.State.RESUMED;
                        this.set(response);
                        break block7;
                    }
                    finally {
                        this.executionStateMonitor.leave();
                    }
                }
                if (response != null) {
                    LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_SUSPENDED_RESPONSE_IGNORED(response));
                }
            }
            catch (Exception ex) {
                this.resume(ex);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocationContext.State state() {
        this.executionStateMonitor.enter();
        try {
            InvocationContext.State state = this.executionState;
            return state;
        }
        finally {
            this.executionStateMonitor.leave();
        }
    }

    @Override
    public Future<Response> getInflectedResponse() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Object response) {
        if (this.executionStateMonitor.enterIf(this.resumableState)) {
            try {
                this.executionState = InvocationContext.State.RESUMED;
            }
            finally {
                this.executionStateMonitor.leave();
            }
        } else {
            throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.executionState, "resume"));
        }
        this.callback.resumed();
        this.set(this.toJaxrsResponse(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Exception response) {
        if (this.executionStateMonitor.enterIf(this.resumableState)) {
            try {
                this.executionState = InvocationContext.State.RESUMED;
            }
            finally {
                this.executionStateMonitor.leave();
            }
        } else {
            throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.executionState, "resume"));
        }
        this.callback.resumed();
        this.setException(response);
    }

    public void setSuspendTimeout(long time, TimeUnit unit) {
        this.defaultTimeout = time;
        this.defaultTimeoutUnit = unit;
    }

    @Override
    public boolean trySuspend() {
        return this._suspend(this.defaultTimeout, this.defaultTimeoutUnit, false);
    }

    public void suspend() {
        this._suspend(this.defaultTimeout, this.defaultTimeoutUnit, true);
    }

    public void suspend(long millis) {
        this._suspend(millis, TimeUnit.MILLISECONDS, true);
    }

    public void suspend(long time, TimeUnit unit) {
        this._suspend(time, unit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean _suspend(long time, TimeUnit unit, boolean failOnError) throws IllegalStateException {
        suspendSuccessful = false;
        try {
            this.executionStateMonitor.enter();
            switch (4.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[this.executionState.ordinal()]) {
                case 1: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    if (!failOnError) ** break;
                    throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.executionState, "suspend"));
                }
                case 4: {
                    this.executionState = InvocationContext.State.SUSPENDED;
                    suspendSuccessful = true;
                    break;
                }
                ** default:
lbl16:
                // 1 sources

                break;
            }
        }
        finally {
            this.executionStateMonitor.leave();
        }
        if (suspendSuccessful) {
            this.callback.suspended(time, unit, this);
        } else {
            AsyncInflectorAdapter.LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_SUSPEND_FAILED((Object)this.executionState));
        }
        return suspendSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.executionStateMonitor.enterIf(this.cancellableState)) {
            try {
                this.executionState = InvocationContext.State.CANCELLED;
            }
            finally {
                this.executionStateMonitor.leave();
            }
            super.cancel(true);
        } else {
            LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_CANCEL_FAILED((Object)this.executionState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        try {
            this.executionStateMonitor.enter();
            boolean bl = this.executionState == InvocationContext.State.SUSPENDED;
            return bl;
        }
        finally {
            this.executionStateMonitor.leave();
        }
    }

    protected void interruptTask() {
        this.callback.cancelled();
    }

    public void setResponse(Object response) {
        this.defaultResponse.set(this.toJaxrsResponse(response));
    }

    public Response getResponse() {
        return this.defaultResponse.get();
    }

    private Response toJaxrsResponse(Object response) {
        if (response instanceof Response) {
            return (Response)response;
        }
        return Response.ok((Object)response).build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id.value()).toString();
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State;

        static {
            $SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State = new int[InvocationContext.State.values().length];
            try {
                4.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.RESUMED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.SUSPENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

