/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.PreMatchRequestFilter;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.AbstractFilterProcessor;
import org.glassfish.jersey.process.internal.LinearAcceptor;

public class PreMatchRequestFilterAcceptor
extends AbstractFilterProcessor<PreMatchRequestFilter>
implements LinearAcceptor {
    @Override
    public Pair<Request, Optional<LinearAcceptor>> apply(Request data) {
        FilterContext filterContext = (FilterContext)this.filterContextFactory.get();
        filterContext.setRequest(data);
        assert (filterContext.getResponse() == null);
        for (PreMatchRequestFilter filter : this.getFilters(PreMatchRequestFilter.class)) {
            try {
                filter.preMatchFilter(filterContext);
                if (filterContext.getResponse() == null) continue;
                break;
            }
            catch (Exception e) {
                throw new MappableException(e);
            }
        }
        return Tuples.of(filterContext.getRequest(), Optional.absent());
    }
}

