/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Scope;
import org.glassfish.hk2.ScopeInstance;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;

public class RequestScope
implements Scope {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(RequestScope.class.getName()), Level.FINEST);
    private final ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();

    public ScopeInstance current() {
        return this.getCurrentScopeInstance();
    }

    private Instance getCurrentScopeInstance() throws IllegalStateException {
        Instance scopeInstance = this.currentScopeInstance.get();
        Preconditions.checkState((scopeInstance != null ? 1 : 0) != 0, (Object)"Not inside a request scope.");
        return scopeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot takeSnapshot() throws IllegalStateException {
        Snapshot snapshot;
        Instance scopeInstance = this.getCurrentScopeInstance();
        try {
            snapshot = new Snapshot(scopeInstance);
        }
        catch (Throwable throwable) {
            logger.debugLog("Taken snapshot of the request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Taken snapshot of the request scope instance {0}", scopeInstance);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        boolean bl;
        block5: {
            Instance scopeInstance;
            block4: {
                scopeInstance = this.currentScopeInstance.get();
                try {
                    boolean bl2 = bl = scopeInstance != null;
                    if (scopeInstance != null) break block4;
                    logger.debugLog("Active request scope instance not found", new Object[0]);
                    break block5;
                }
                catch (Throwable throwable) {
                    if (scopeInstance == null) {
                        logger.debugLog("Active request scope instance not found", new Object[0]);
                    } else {
                        logger.debugLog("Active request scope instance {0} found", scopeInstance);
                    }
                    throw throwable;
                }
            }
            logger.debugLog("Active request scope instance {0} found", scopeInstance);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter() throws IllegalStateException {
        Instance scopeInstance = new Instance();
        Preconditions.checkState((this.currentScopeInstance.get() == null ? 1 : 0) != 0, (Object)"A scoped block is already in progress.");
        try {
            this.currentScopeInstance.set(scopeInstance);
        }
        catch (Throwable throwable) {
            logger.debugLog("Entered request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Entered request scope instance {0}", scopeInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Snapshot snapshot) throws IllegalStateException {
        Instance scopeInstance = snapshot.scopeInstance;
        Preconditions.checkState((this.currentScopeInstance.get() == null ? 1 : 0) != 0, (Object)"A scoped block is already in progress.");
        try {
            this.currentScopeInstance.set(scopeInstance);
        }
        catch (Throwable throwable) {
            logger.debugLog("Resumed request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Resumed request scope instance {0}", scopeInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() throws IllegalStateException {
        Instance scopeInstance = this.currentScopeInstance.get();
        Preconditions.checkState((scopeInstance != null ? 1 : 0) != 0, (Object)"No scoped block in progress.");
        try {
            this.currentScopeInstance.remove();
            scopeInstance.release();
        }
        catch (Throwable throwable) {
            logger.debugLog("Exited request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Exited request scope instance {0}", scopeInstance);
    }

    public static final class Snapshot {
        private final Instance scopeInstance;

        private Snapshot(Instance instance) {
            this.scopeInstance = instance.snapshot();
        }
    }

    private static final class Instance
    implements ScopeInstance {
        private final LazyUid id = new LazyUid();
        private final Map<Provider<?>, Object> store = new HashMap();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        public <T> T get(Provider<T> inhabitant) {
            return (T)this.store.get(inhabitant);
        }

        public <T> T put(Provider<T> inhabitant, T value) {
            Preconditions.checkState((!this.store.containsKey(inhabitant) ? 1 : 0) != 0, (String)"An instance for the provider %s was already seeded in this scope. Old instance: %s New instance: %s", (Object[])new Object[]{inhabitant, this.store.get(inhabitant), value});
            return (T)this.store.put(inhabitant, value);
        }

        public <T> boolean contains(Provider<T> provider) {
            return this.store.containsKey(provider);
        }

        public Instance snapshot() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                try {
                    this.store.clear();
                }
                catch (Throwable throwable) {
                    logger.debugLog("Released scope instance {0}", this);
                    throw throwable;
                }
                logger.debugLog("Released scope instance {0}", this);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("id", (Object)this.id.value()).add("referenceCounter", this.referenceCounter.get()).add("store size", this.store.size()).toString();
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            RequestScope requestScope = new RequestScope();
            this.bind(RequestScope.class, new Class[0]).toInstance((Object)requestScope);
        }
    }
}

