/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GraalHPyDebugModuleBuiltins;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@CoreFunctions(defineModule="_hpy_trace")
@GenerateNodeFactory
public final class GraalHPyTraceModuleBuiltins
extends PythonBuiltins {
    public static final String J_HPY_TRACE = "_hpy_trace";
    private static final TruffleString T_GET_DURATIONS = PythonUtils.tsLiteral("get_durations");
    private static final TruffleString T_GET_CALL_COUNTS = PythonUtils.tsLiteral("get_call_counts");
    private static final TruffleString T_SET_TRACE_FUNCTIONS = PythonUtils.tsLiteral("set_trace_functions");
    private static final TruffleString T_GET_FREQUENCY = PythonUtils.tsLiteral("get_frequency");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonModule hpyTraceModule = core.lookupBuiltinModule(PythonUtils.tsLiteral(J_HPY_TRACE));
        TruffleString[] keys = new TruffleString[]{T_GET_DURATIONS, T_GET_CALL_COUNTS, T_SET_TRACE_FUNCTIONS, T_GET_FREQUENCY};
        try {
            GraalHPyContext hpyContext = GraalHPyContext.ensureHPyWasLoaded(null, core.getContext(), null, null);
            PythonModule nativeTraceModule = hpyContext.getHPyTraceModule();
            PDict nativeTraceDict = GetDictIfExistsNode.getUncached().execute(nativeTraceModule);
            for (TruffleString tkey : keys) {
                hpyTraceModule.setAttribute(tkey, nativeTraceDict.getItem(tkey));
            }
        }
        catch (LoadCExtException.ApiInitException | LoadCExtException.ImportException | IOException e) {
            PBuiltinMethod notAvailableObj = GraalHPyDebugModuleBuiltins.createFunction(core, hpyTraceModule);
            for (TruffleString tkey : keys) {
                hpyTraceModule.setAttribute(tkey, notAvailableObj);
            }
        }
    }
}

