/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.LsprofModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.Profiler;
import com.oracle.graal.python.builtins.modules.ProfilerBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.profiler.CPUSampler;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="_lsprof")
public final class LsprofModuleBuiltins
extends PythonBuiltins {
    static final StructSequence.BuiltinTypeDescriptor PROFILER_ENTRY_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PProfilerEntry, null, 6, new String[]{"code", "callcount", "reccallcount", "totaltime", "inlinetime", "calls"}, new String[]{"code object or built-in function name", "how many times this was called", "how many times called recursively", "total time in this entry", "inline time in this entry (not in subcalls)", "details of the calls"});
    static final StructSequence.BuiltinTypeDescriptor PROFILER_SUBENTRY_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PProfilerSubentry, null, 5, new String[]{"code", "callcount", "reccallcount", "totaltime", "inlinetime"}, new String[]{"called code object or built-in function name", "how many times this is called", "how many times this is called recursively", "total time spent in this call", "inline time (not in further subcalls)"});

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LsprofModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        StructSequence.initType(core, PROFILER_ENTRY_DESC);
        StructSequence.initType(core, PROFILER_SUBENTRY_DESC);
    }

    public static PythonBuiltins newProfilerBuiltins() {
        return new ProfilerBuiltins();
    }

    @Builtin(name="Profiler", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.LsprofProfiler)
    @GenerateNodeFactory
    static abstract class LsprofNew
    extends PythonBuiltinNode {
        LsprofNew() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Profiler doit(Object cls, Object[] args, PKeyword[] kwargs) {
            CPUSampler sampler;
            TruffleLanguage.Env env = this.getContext().getEnv();
            Map instruments = env.getInstruments();
            InstrumentInfo instrumentInfo = (InstrumentInfo)instruments.get("cpusampler");
            if (instrumentInfo != null && (sampler = (CPUSampler)env.lookup(instrumentInfo, CPUSampler.class)) != null) {
                PythonObjectFactory factory = PythonObjectFactory.getUncached();
                return factory.trace(new Profiler(cls, factory.getShape(cls), sampler));
            }
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.NotImplementedError, ErrorMessages.COVERAGE_TRACKER_NOT_AVAILABLE);
        }
    }
}

