/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCStructType, PythonBuiltinClassType.UnionType, PythonBuiltinClassType.PyCArrayType, PythonBuiltinClassType.PyCFuncPtrType, PythonBuiltinClassType.PyCPointerType, PythonBuiltinClassType.PyCSimpleType})
public final class CDataTypeBuiltins
extends PythonBuiltins {
    protected static final String J_FROM_PARAM = "from_param";
    protected static final TruffleString T_FROM_PARAM = PythonUtils.tsLiteral("from_param");
    protected static final String J_FROM_ADDRESS = "from_address";
    protected static final String J_FROM_BUFFER = "from_buffer";
    protected static final String J_FROM_BUFFER_COPY = "from_buffer_copy";
    protected static final String J_IN_DLL = "in_dll";
    protected static final TruffleString T__AS_PARAMETER_ = PythonUtils.tsLiteral("_as_parameter_");
    protected static final String J__HANDLE = "_handle";
    protected static final TruffleString T__HANDLE = PythonUtils.tsLiteral("_handle");
    private static final int MAX_KEY_SIZE = 256;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CDataTypeBuiltinsFactory.getFactories();
    }

    protected static CDataObject PyCData_GetContainer(CDataObject leaf, PythonObjectFactory factory) {
        CDataObject self = leaf;
        while (self.b_base != null) {
            self = self.b_base;
        }
        if (self.b_objects == null) {
            self.b_objects = self.b_length != 0 ? factory.createDict() : PNone.NONE;
        }
        return self;
    }

    static Object GetKeepedObjects(CDataObject target, PythonObjectFactory factory) {
        return CDataTypeBuiltins.PyCData_GetContainer((CDataObject)target, (PythonObjectFactory)factory).b_objects;
    }

    static TruffleString unique_key(Node inliningTarget, CDataObject cdata, int index, PRaiseNode.Lazy raiseNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.ToStringNode toStringNode, TruffleString.FromJavaStringNode fromJavaStringNode) {
        assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32);
        int bytesPerCodepoint = 4;
        CDataObject target = cdata;
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        appendStringNode.execute(sb, (AbstractTruffleString)fromJavaStringNode.execute(CDataTypeBuiltins.toHex(index), PythonUtils.TS_ENCODING));
        while (target.b_base != null) {
            int bytesLeft = 256 - sb.byteLength() / 4 - 1;
            if (bytesLeft < 8) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CTYPES_OBJECT_STRUCTURE_TOO_DEEP);
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COLON);
            appendStringNode.execute(sb, (AbstractTruffleString)fromJavaStringNode.execute(CDataTypeBuiltins.toHex(target.b_index), PythonUtils.TS_ENCODING));
            target = target.b_base;
        }
        return toStringNode.execute(sb);
    }

    @CompilerDirectives.TruffleBoundary
    private static String toHex(int value) {
        return Integer.toHexString(value);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    protected static abstract class KeepRefNode
    extends Node {
        protected KeepRefNode() {
        }

        abstract void execute(VirtualFrame var1, Node var2, CDataObject var3, int var4, Object var5);

        @Specialization
        static void none(CDataObject target, int index, PNone keep) {
        }

        @Specialization(guards={"!isNone(keep)"})
        static void KeepRef(VirtualFrame frame, Node inliningTarget, CDataObject target, int index, Object keep, @Cached(inline=false) TruffleStringBuilder.AppendStringNode appendStringNode, @Cached(inline=false) TruffleStringBuilder.ToStringNode toStringNode, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            CDataObject ob = CDataTypeBuiltins.PyCData_GetContainer(target, factory);
            if (!PGuards.isDict(ob.b_objects)) {
                ob.b_objects = keep;
                return;
            }
            PDict dict = (PDict)ob.b_objects;
            TruffleString key = CDataTypeBuiltins.unique_key(inliningTarget, target, index, raiseNode, appendStringNode, toStringNode, fromJavaStringNode);
            dict.setDictStorage(setItem.execute((Frame)frame, inliningTarget, dict.getDictStorage(), key, keep));
        }
    }

    protected static abstract class PyCDataSetNode
    extends Node {
        protected PyCDataSetNode() {
        }

        abstract void execute(VirtualFrame var1, CDataObject var2, Object var3, FFIType.FieldSet var4, Object var5, int var6, int var7, Pointer var8);

        @Specialization
        static void PyCData_set(VirtualFrame frame, CDataObject dst, Object type, FFIType.FieldSet setfunc, Object value, int index, int size, Pointer ptr, @Bind(value="this") Node inliningTarget, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached CallNode callNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached KeepRefNode keepRefNode, @Cached PointerNodes.MemcpyNode memcpyNode, @Cached PointerNodes.WritePointerNode writePointerNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!pyTypeCheck.isCDataObject(inliningTarget, dst)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NOT_A_CTYPE_INSTANCE);
            }
            Object result = PyCDataSetNode.PyCDataSetInternal(frame, inliningTarget, type, setfunc, value, size, ptr, factory, pyTypeCheck, setFuncNode, callNode, isInstanceNode, pyTypeStgDictNode, pyObjectStgDictNode, memcpyNode, writePointerNode, raiseNode);
            keepRefNode.execute(frame, inliningTarget, dst, index, result);
        }

        static Object PyCDataSetInternal(VirtualFrame frame, Node inliningTarget, Object type, FFIType.FieldSet setfunc, Object value, int size, Pointer ptr, PythonObjectFactory factory, CtypesNodes.PyTypeCheck pyTypeCheck, CFieldBuiltins.SetFuncNode setFuncNode, CallNode callNode, BuiltinFunctions.IsInstanceNode isInstanceNode, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, PointerNodes.MemcpyNode memcpyNode, PointerNodes.WritePointerNode writePointerNode, PRaiseNode.Lazy raiseNode) {
            if (setfunc != FFIType.FieldSet.nil) {
                return setFuncNode.execute(frame, setfunc, ptr, value, size);
            }
            if (!pyTypeCheck.isCDataObject(inliningTarget, value)) {
                StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, type);
                if (dict != null && dict.setfunc != FFIType.FieldSet.nil) {
                    return setFuncNode.execute(frame, dict.setfunc, ptr, value, size);
                }
                if (PGuards.isPTuple(value)) {
                    Object ob = callNode.execute((Frame)frame, type, value);
                    return PyCDataSetNode.PyCDataSetInternal(frame, inliningTarget, type, setfunc, ob, size, ptr, factory, pyTypeCheck, setFuncNode, callNode, isInstanceNode, pyTypeStgDictNode, pyObjectStgDictNode, memcpyNode, writePointerNode, raiseNode);
                }
                if (value instanceof PNone && pyTypeCheck.isPyCPointerTypeObject(inliningTarget, type)) {
                    writePointerNode.execute(inliningTarget, ptr, Pointer.NULL);
                    return PNone.NONE;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_P_INSTANCE_GOT_P, type, value);
            }
            CDataObject src = (CDataObject)value;
            if (isInstanceNode.executeWith(frame, value, type)) {
                memcpyNode.execute(inliningTarget, ptr, src.b_ptr, size);
                return CDataTypeBuiltins.GetKeepedObjects(src, factory);
            }
            if (pyTypeCheck.isPyCPointerTypeObject(inliningTarget, type) && pyTypeCheck.isArrayObject(inliningTarget, value)) {
                StgDictObject p1 = pyObjectStgDictNode.execute(inliningTarget, value);
                assert (p1 != null) : "Cannot be NULL for array instances";
                StgDictObject p2 = pyTypeStgDictNode.execute(inliningTarget, type);
                assert (p2 != null) : "Cannot be NULL for pointer types";
                if (p1.proto != p2.proto) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INCOMPATIBLE_TYPES_P_INSTANCE_INSTEAD_OF_P_INSTANCE, value, type);
                }
                writePointerNode.execute(inliningTarget, ptr, src.b_ptr);
                Object keep = CDataTypeBuiltins.GetKeepedObjects(src, factory);
                return factory.createTuple(new Object[]{keep, value});
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INCOMPATIBLE_TYPES_P_INSTANCE_INSTEAD_OF_P_INSTANCE, value, type);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={FFIType.FieldGet.class})
    protected static abstract class PyCDataGetNode
    extends Node {
        protected PyCDataGetNode() {
        }

        protected abstract Object execute(Node var1, Object var2, FFIType.FieldGet var3, CDataObject var4, int var5, int var6, Pointer var7);

        @Specialization(guards={"getfunc != nil"})
        static Object withFunc(Object type, FFIType.FieldGet getfunc, CDataObject src, int index, int size, Pointer adr, @Cached.Shared @Cached(inline=false) CFieldBuiltins.GetFuncNode getFuncNode) {
            return getFuncNode.execute(getfunc, adr, size);
        }

        @Specialization(guards={"getfunc == nil"})
        static Object withoutFunc(Node inliningTarget, Object type, FFIType.FieldGet getfunc, CDataObject src, int index, int size, Pointer adr, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached.Shared @Cached(inline=false) CFieldBuiltins.GetFuncNode getFuncNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.PyCDataFromBaseObjNode fromBaseObjNode) {
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, type);
            if (dict != null && dict.getfunc != FFIType.FieldGet.nil && !pyTypeCheck.ctypesSimpleInstance(inliningTarget, type, getBaseClassNode, isSameTypeNode)) {
                return getFuncNode.execute(dict.getfunc, adr, size);
            }
            return fromBaseObjNode.execute(inliningTarget, type, src, index, adr);
        }
    }

    protected static abstract class PyCDataAtAddress
    extends Node {
        protected PyCDataAtAddress() {
        }

        abstract CDataObject execute(Object var1, Pointer var2);

        @Specialization
        static CDataObject PyCData_AtAddress(Object type, Pointer pointer, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.CreateCDataObjectNode createCDataObjectNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject stgdict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            stgdict.flags |= 0x1000;
            CDataObject pd = createCDataObjectNode.execute(inliningTarget, type, pointer, stgdict.size, false);
            assert (pyTypeCheck.isCDataObject(inliningTarget, pd));
            pd.b_length = stgdict.length;
            return pd;
        }
    }

    @Builtin(name="in_dll", minNumOfPositionalArgs=1, parameterNames={"type", "dll", "name"}, declaresExplicitSelf=true)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class InDllNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CDataTypeBuiltinsClinicProviders.InDllNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object CDataType_in_dll(VirtualFrame frame, Object type, Object dll, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @Cached(value="create(T__HANDLE)") GetAttributeNode getAttributeNode, @Cached PyCDataAtAddress atAddress, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached CtypesModuleBuiltins.CtypesDlSymNode dlSymNode, @Cached PRaiseNode.Lazy raiseNode) {
            Pointer handlePtr;
            auditNode.audit(inliningTarget, "ctypes.dlsym", dll, name);
            Object obj = getAttributeNode.executeObject(frame, dll);
            if (!longCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.THE_HANDLE_ATTRIBUTE_OF_THE_SECOND_ARGUMENT_MUST_BE_AN_INTEGER);
            }
            try {
                handlePtr = pointerFromLongNode.execute(inliningTarget, obj);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.COULD_NOT_CONVERT_THE_HANDLE_ATTRIBUTE_TO_A_POINTER);
            }
            Object address = dlSymNode.execute(frame, handlePtr, name, PythonErrorType.ValueError);
            if (address instanceof PythonNativeVoidPtr) {
                PythonNativeVoidPtr ptr = (PythonNativeVoidPtr)address;
                address = ptr.getPointerObject();
            }
            return atAddress.execute(type, Pointer.nativeMemory(address));
        }
    }

    @Builtin(name="from_buffer_copy", minNumOfPositionalArgs=2, parameterNames={"self", "buffer", "offset"})
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class FromBufferCopyNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CDataTypeBuiltinsClinicProviders.FromBufferCopyNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object CDataType_from_buffer_copy(Object type, Object buffer, int offset, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
                if (offset < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.OFFSET_CANNOT_BE_NEGATIVE);
                }
                int bufferLen = bufferLib.getBufferLength(buffer);
                if (dict.size > bufferLen - offset) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BUFFER_SIZE_TOO_SMALL_D_INSTEAD_OF_AT_LEAST_D_BYTES, bufferLen, dict.size + offset);
                }
                auditNode.audit(inliningTarget, "ctypes.cdata/buffer", 0, bufferLen, offset);
                CDataObject result = pyCDataNewNode.execute(inliningTarget, type, dict);
                byte[] slice = new byte[dict.size];
                bufferLib.readIntoByteArray(buffer, offset, slice, 0, dict.size);
                writeBytesNode.execute(inliningTarget, result.b_ptr, slice);
                CDataObject cDataObject = result;
                return cDataObject;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @Builtin(name="from_buffer", minNumOfPositionalArgs=2, parameterNames={"self", "buffer", "offset"}, declaresExplicitSelf=true)
    @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class FromBufferNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CDataTypeBuiltinsClinicProviders.FromBufferNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object CDataType_from_buffer(VirtualFrame frame, Object type, Object obj, int offset, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.MemoryViewNode memoryViewNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PyCDataAtAddress atAddress, @Cached KeepRefNode keepRefNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            PMemoryView mv = memoryViewNode.execute(frame, obj);
            if (mv.isReadOnly()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNDERLYING_BUFFER_IS_NOT_WRITABLE);
            }
            if (!mv.isCContiguous()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNDERLYING_BUFFER_IS_NOT_C_CONTIGUOUS);
            }
            if (offset < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.OFFSET_CANNOT_BE_NEGATIVE);
            }
            if (dict.size > mv.getLength() - offset) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BUFFER_SIZE_TOO_SMALL_D_INSTEAD_OF_AT_LEAST_D_BYTES, mv.getLength(), dict.size + offset);
            }
            auditNode.audit(inliningTarget, "ctypes.cdata/buffer", mv, mv.getLength(), offset);
            CDataObject result = atAddress.execute(type, Pointer.memoryView(mv).withOffset(offset));
            keepRefNode.execute(frame, inliningTarget, result, -1, mv);
            return result;
        }
    }

    @Builtin(name="from_address", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class FromAddressNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object CDataType_from_address(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached PyCDataAtAddress atAddress) {
            return atAddress.execute(type, pointerFromLongNode.execute(inliningTarget, value));
        }
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @GenerateNodeFactory
    public static abstract class FromParamNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object CDataType_from_param(VirtualFrame frame, Object type, Object value, @Cached CDataTypeFromParamNode fromParamNode) {
            return fromParamNode.execute(frame, type, value);
        }
    }

    @ImportStatic(value={CDataTypeBuiltins.class})
    protected static abstract class CDataTypeFromParamNode
    extends Node {
        protected CDataTypeFromParamNode() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static Object CDataType_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PyObjectLookupAttr lookupAttr, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (isInstanceNode.executeWith(frame, value, type)) {
                return value;
            }
            if (PGuards.isPyCArg(value)) {
                PyCArgObject p = (PyCArgObject)value;
                Object ob = p.obj;
                StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, type);
                if (dict != null && ob != null && isInstanceNode.executeWith(frame, ob, dict.proto)) {
                    return value;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_P_INSTANCE_INSTEAD_OF_POINTER_TO_P, type, ob != null ? ob : PNone.NONE);
            }
            Object as_parameter = lookupAttr.execute((Frame)frame, inliningTarget, value, T__AS_PARAMETER_);
            if (as_parameter != PNone.NO_VALUE) {
                return CDataTypeFromParamNode.CDataType_from_param(frame, type, as_parameter, inliningTarget, pyTypeStgDictNode, lookupAttr, isInstanceNode, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_P_INSTANCE_INSTEAD_OF_P, type, value);
        }
    }
}

