/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public final class CThunkObject
extends PythonBuiltinObject {
    Object pcl_write;
    Object pcl_exec;
    Object cif;
    int flags;
    Object[] converters;
    Object callable;
    Object restype;
    FFIType.FieldSet setfunc;
    FFIType ffi_restype;
    FFIType[] atypes;

    public CThunkObject(Object cls, Shape instanceShape, int nArgs) {
        super(cls, instanceShape);
        this.atypes = new FFIType[nArgs];
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class CtypeCallback
    implements TruffleObject {
        private final CThunkObject thunk;

        public CtypeCallback(CThunkObject thunk) {
            this.thunk = thunk;
        }

        protected static void checkArity(Object[] arguments, int expectedArity) throws ArityException {
            if (arguments.length != expectedArity) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)expectedArity, (int)expectedArity, (int)arguments.length);
            }
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] pArgs, @CachedLibrary(limit="2") InteropLibrary lib, @Cached GilNode gil, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Bind(value="$node") Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached CFieldBuiltins.GetFuncNode getFuncNode, @Cached CallNode callNode, @Cached WriteUnraisableNode writeUnraisableNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PointerNodes.MemcpyNode memcpyNode, @Cached PRaiseNode raiseNode) throws ArityException {
            Object[] converters = this.thunk.converters;
            int nArgs = converters.length;
            CtypeCallback.checkArity(pArgs, nArgs);
            FFIType restype = this.thunk.ffi_restype;
            FFIType.FieldSet setfunc = this.thunk.setfunc;
            Object callable = this.thunk.callable;
            boolean mustRelease = gil.acquire();
            try {
                Object object;
                Object[] arglist = new Object[nArgs];
                for (int i = 0; i < nArgs; ++i) {
                    Object arg = pArgs[i];
                    if (lib.isPointer(arg)) {
                        try {
                            arg = lib.asPointer(arg);
                        }
                        catch (UnsupportedMessageException e) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                        }
                    }
                    FFIType argType = this.thunk.atypes[i];
                    Pointer value = Pointer.create(argType, argType.size, arg, 0);
                    StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, converters[i]);
                    if (dict != null && dict.getfunc != FFIType.FieldGet.nil && !pyTypeCheck.ctypesSimpleInstance(inliningTarget, converters[i], getBaseClassNode, isSameTypeNode)) {
                        arglist[i] = getFuncNode.execute(dict.getfunc, value, dict.size);
                        continue;
                    }
                    if (dict != null) {
                        CDataObject obj = (CDataObject)callNode.executeWithoutFrame(converters[i], new Object[0]);
                        memcpyNode.execute(inliningTarget, obj.b_ptr, value, dict.size);
                        arglist[i] = obj;
                        continue;
                    }
                    throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_BUILD_PARAMETER);
                }
                Object result = null;
                try {
                    result = callNode.executeWithoutFrame(callable, arglist, PKeyword.EMPTY_KEYWORDS);
                }
                catch (PException e) {
                    writeUnraisableNode.execute(e.getEscapedException(), ErrorMessages.ON_CALLING_CTYPES_CALLBACK_FUNCTION, callable);
                }
                if (restype.type != FFIType.FFI_TYPES.FFI_TYPE_VOID && result != null) {
                    assert (setfunc != FFIType.FieldSet.nil);
                    Object keep = PNone.NONE;
                    try {
                        Pointer mem = Pointer.allocate(restype, restype.size);
                        keep = setFuncNode.execute(null, setfunc, mem, result, 0);
                    }
                    catch (PException e) {
                        writeUnraisableNode.execute(e.getEscapedException(), ErrorMessages.ON_CONVERTING_RESULT_OF_CTYPES_CALLBACK_FUNCTION, callable);
                    }
                    if (keep != PNone.NONE && setfunc != FFIType.FieldDesc.O.setfunc) {
                        try {
                            warnNode.warnEx(null, (Object)PythonErrorType.RuntimeWarning, ErrorMessages.MEMORY_LEAK_IN_CALLBACK_FUNCTION, 1);
                        }
                        catch (PException e) {
                            writeUnraisableNode.execute(e.getEscapedException(), ErrorMessages.ON_CONVERTING_RESULT_OF_CTYPES_CALLBACK_FUNCTION, callable);
                        }
                    }
                } else {
                    object = 0;
                    return object;
                }
                object = result;
                return object;
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }
}

