/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldObject;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.StgDict})
public final class StgDictBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TpSlots.createEmpty();
    protected static final TruffleString T__ANONYMOUS_ = PythonUtils.tsLiteral("_anonymous_");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StgDictBuiltinsFactory.getFactories();
    }

    @ImportStatic(value={StgDictBuiltins.class})
    protected static abstract class MakeAnonFieldsNode
    extends Node {
        protected MakeAnonFieldsNode() {
        }

        abstract void execute(VirtualFrame var1, Object var2, PythonObjectFactory var3);

        @Specialization
        static void MakeAnonFields(VirtualFrame frame, Object type, PythonObjectFactory factory, @Bind(value="this") Node inliningTarget, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectGetItem getItemNode, @Cached MakeFieldsNode makeFieldsNode, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttrO getAttr, @Cached PyObjectLookupAttr lookupAnon, @Cached PRaiseNode.Lazy raiseNode) {
            Object anon = lookupAnon.execute((Frame)frame, inliningTarget, type, T__ANONYMOUS_);
            if (PGuards.isPNone(anon)) {
                return;
            }
            if (!sequenceCheckNode.execute(inliningTarget, anon)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ANONYMOUS_MUST_BE_A_SEQUENCE);
            }
            for (int i = 0; i < sizeNode.execute((Frame)frame, inliningTarget, anon); ++i) {
                Object fname = getItemNode.execute((Frame)frame, inliningTarget, anon, i);
                CFieldObject descr = (CFieldObject)getAttr.execute((Frame)frame, inliningTarget, type, fname);
                if (getClassNode.execute(inliningTarget, descr) != PythonBuiltinClassType.CField) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.S_IS_SPECIFIED_IN_ANONYMOUS_BUT_NOT_IN_FIELDS, fname);
                }
                descr.anonymous = 1;
                makeFieldsNode.execute(frame, type, descr, descr.index, descr.offset, factory);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class PyObjectStgDictNode
    extends Node {
        protected PyObjectStgDictNode() {
        }

        abstract StgDictObject execute(Node var1, Object var2);

        @Specialization
        static StgDictObject PyObject_stgdict(Node inliningTarget, Object self, @Cached GetClassNode getType, @Cached(inline=false) GetDictIfExistsNode getDict) {
            Object type = getType.execute(inliningTarget, self);
            PDict dict = getDict.execute(type);
            if (!PGuards.isStgDict(dict)) {
                return null;
            }
            return (StgDictObject)dict;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class PyTypeStgDictNode
    extends Node {
        protected PyTypeStgDictNode() {
        }

        abstract StgDictObject execute(Node var1, Object var2);

        static StgDictObject executeUncached(Object type) {
            return StgDictBuiltinsFactory.PyTypeStgDictNodeGen.getUncached().execute(null, type);
        }

        protected StgDictObject checkAbstractClass(Node inliningTarget, Object type, PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = this.execute(inliningTarget, type);
            if (dict == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ABSTRACT_CLASS);
            }
            return dict;
        }

        @Specialization
        static StgDictObject PyType_stgdict(Node inliningTarget, Object obj, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached(inline=false) GetDictIfExistsNode getDict) {
            if (!isTypeNode.execute(inliningTarget, obj)) {
                return null;
            }
            PDict dict = getDict.execute(obj);
            if (!PGuards.isStgDict(dict)) {
                return null;
            }
            return (StgDictObject)dict;
        }
    }

    @ImportStatic(value={StructUnionTypeBuiltins.class})
    protected static abstract class MakeFieldsNode
    extends PNodeWithContext {
        protected MakeFieldsNode() {
        }

        abstract void execute(VirtualFrame var1, Object var2, CFieldObject var3, int var4, int var5, PythonObjectFactory var6);

        @CompilerDirectives.TruffleBoundary
        private void executeBoundary(Object type, CFieldObject descr, int index, int offset, PythonObjectFactory factory) {
            this.execute(null, type, descr, index, offset, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void MakeFields(VirtualFrame frame, Object type, CFieldObject descr, int index, int offset, PythonObjectFactory factory, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttrO getAttributeNode, @Cached PyObjectSetAttrO setAttributeNode, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectGetItem getItemNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached(value="create(T__FIELDS_)") GetAttributeNode getAttrString, @Cached MakeFieldsNode recursiveNode, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PRaiseNode.Lazy raiseNode) {
            Object fields = getAttrString.executeObject(frame, descr.proto);
            if (!sequenceCheckNode.execute(inliningTarget, fields)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.FIELDS_MUST_BE_A_SEQUENCE);
            }
            PythonContext context = PythonContext.get(inliningTarget);
            for (int i = 0; i < sizeNode.execute((Frame)frame, inliningTarget, fields); ++i) {
                PTuple pair = (PTuple)getItemNode.execute((Frame)frame, inliningTarget, fields, i);
                Object[] array = getArray.execute(inliningTarget, pair.getSequenceStorage());
                Object fname = array[0];
                CFieldObject fdescr = (CFieldObject)getAttributeNode.execute((Frame)frame, inliningTarget, descr.proto, fname);
                if (getClassNode.execute(inliningTarget, fdescr) != context.lookupType(PythonBuiltinClassType.CField)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNEXPECTED_TYPE);
                }
                if (fdescr.anonymous != 0) {
                    PythonLanguage language = PythonLanguage.get(inliningTarget);
                    Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
                    try {
                        recursiveNode.executeBoundary(type, fdescr, index + fdescr.index, offset + fdescr.offset, context.factory());
                        continue;
                    }
                    finally {
                        ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
                    }
                }
                CFieldObject new_descr = factory.createCFieldObject((Object)PythonBuiltinClassType.CField);
                new_descr.size = fdescr.size;
                new_descr.offset = fdescr.offset + offset;
                new_descr.index = fdescr.index + index;
                new_descr.proto = fdescr.proto;
                new_descr.getfunc = fdescr.getfunc;
                new_descr.setfunc = fdescr.setfunc;
                setAttributeNode.execute((Frame)frame, inliningTarget, type, fname, new_descr);
            }
        }
    }

    @Builtin(name="__sizeof__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class SizeOfNode
    extends PythonUnaryBuiltinNode {
        protected SizeOfNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, StgDictObject self, @Bind(value="this") Node inliningTarget, @Cached GetDictIfExistsNode getDict, @Cached ObjectBuiltins.SizeOfNode sizeOfNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            long size = asSizeNode.executeLossy((Frame)frame, inliningTarget, sizeOfNode.execute(frame, getDict.execute(self)));
            if (self.format != null) {
                size += (long)(codePointLengthNode.execute((AbstractTruffleString)self.format, PythonUtils.TS_ENCODING) + 1);
            }
            size += (long)(self.ndim * 4);
            if (self.ffi_type_pointer.elements != null) {
                size += (long)(self.ffi_type_pointer.elements.length * FFIType.typeSize());
            }
            return size;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        Object init(VirtualFrame frame, StgDictObject self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached CallNode callNode) {
            Object[] dictArgs;
            Object initMethod = lookup.execute((Frame)frame, inliningTarget, (Object)PythonBuiltinClassType.PDict, SpecialMethodNames.T___INIT__);
            if (args.length > 0) {
                dictArgs = new Object[args.length + 1];
                dictArgs[0] = self;
                PythonUtils.arraycopy(args, 0, dictArgs, 1, args.length);
            } else {
                dictArgs = new Object[]{self};
            }
            callNode.execute((Frame)frame, initMethod, dictArgs, kwargs);
            self.format = null;
            self.ndim = 0;
            self.shape = null;
            return PNone.NONE;
        }
    }
}

