/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PTextIOBase;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;

public final class PTextIO
extends PTextIOBase {
    private boolean detached;
    private int chunkSize;
    private Object buffer;
    private TruffleString encoding;
    private Object encoder;
    private TruffleString errors;
    private boolean lineBuffering;
    private boolean writeThrough;
    private boolean writetranslate;
    private boolean seekable;
    private boolean hasRead1;
    private boolean telling;
    private boolean finalizing;
    private Object encodefunc;
    private boolean encodingStartOfStream;
    private TruffleString decodedChars;
    private int decodedCharsUsed;
    private int decodedCharsLen;
    private ByteArrayOutputStream pendingBytes = BytesUtils.createOutputStream();
    private int snapshotDecFlags;
    private byte[] snapshotNextInput;
    private double b2cratio;
    private PFileIO raw;

    public PTextIO(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.detached = false;
        this.buffer = null;
        this.encoding = null;
        this.encoder = null;
        this.errors = null;
        this.raw = null;
        this.clearDecodedChars();
        this.clearPendingBytes();
        this.clearSnapshot();
        this.encodefunc = null;
        this.b2cratio = 0.0;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Object getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Object buffer) {
        this.buffer = buffer;
    }

    public TruffleString getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TruffleString encoding) {
        this.encoding = encoding;
    }

    public boolean hasEncoding() {
        return this.encoding != null;
    }

    public Object getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Object encoder) {
        this.encoder = encoder;
    }

    public boolean hasEncoder() {
        return this.encoder != null;
    }

    public TruffleString getErrors() {
        return this.errors;
    }

    public void setErrors(TruffleString errors) {
        this.errors = errors;
    }

    public boolean isLineBuffering() {
        return this.lineBuffering;
    }

    public void setLineBuffering(boolean lineBuffering) {
        this.lineBuffering = lineBuffering;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
    }

    public boolean isWriteTranslate() {
        return this.writetranslate;
    }

    public void setWriteTranslate(boolean writetranslate) {
        this.writetranslate = writetranslate;
    }

    public boolean isSeekable() {
        return this.seekable;
    }

    public void setSeekable(boolean seekable) {
        this.seekable = seekable;
    }

    public boolean isHasRead1() {
        return this.hasRead1;
    }

    public void setHasRead1(boolean hasRead1) {
        this.hasRead1 = hasRead1;
    }

    public boolean isTelling() {
        return this.telling;
    }

    public void setTelling(boolean telling) {
        this.telling = telling;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void setFinalizing(boolean finalizing) {
        this.finalizing = finalizing;
    }

    public Object getEncodefunc() {
        return this.encodefunc;
    }

    public void setEncodefunc(Object encodefunc) {
        this.encodefunc = encodefunc;
    }

    public boolean isEncodingStartOfStream() {
        return this.encodingStartOfStream;
    }

    public void setEncodingStartOfStream(boolean encodingStartOfStream) {
        this.encodingStartOfStream = encodingStartOfStream;
    }

    public TruffleString getDecodedChars() {
        return this.decodedChars;
    }

    public boolean hasDecodedChars() {
        return this.decodedChars != null;
    }

    public boolean hasDecodedCharsAvailable() {
        return this.decodedChars != null && this.decodedCharsUsed < this.decodedCharsLen;
    }

    public int getDecodedCharsUsed() {
        return this.decodedCharsUsed;
    }

    public int setDecodedChars(TruffleString decodedChars, TruffleString.CodePointLengthNode codePointLengthNode) {
        assert (!this.hasDecodedCharsAvailable());
        this.decodedChars = decodedChars;
        this.decodedCharsLen = codePointLengthNode.execute((AbstractTruffleString)decodedChars, PythonUtils.TS_ENCODING);
        this.decodedCharsUsed = 0;
        return this.decodedCharsLen;
    }

    public void incDecodedCharsUsed(int n) {
        assert (this.decodedCharsUsed + n <= this.decodedCharsLen);
        this.decodedCharsUsed += n;
    }

    public void clearDecodedChars() {
        this.decodedChars = null;
        this.decodedCharsUsed = 0;
        this.decodedCharsLen = 0;
    }

    TruffleString consumeDecodedChars(int n, TruffleString.SubstringNode substringNode, boolean lazy) {
        assert (n >= 0);
        if (this.decodedChars == null || n == 0) {
            return StringLiterals.T_EMPTY_STRING;
        }
        int avail = this.decodedCharsLen - this.decodedCharsUsed;
        if (n >= avail) {
            return this.consumeAllDecodedChars(substringNode, lazy);
        }
        TruffleString chars = substringNode.execute((AbstractTruffleString)this.decodedChars, this.decodedCharsUsed, n, PythonUtils.TS_ENCODING, lazy);
        this.decodedCharsUsed += n;
        return chars;
    }

    TruffleString consumeAllDecodedChars(TruffleString.SubstringNode substringNode, boolean lazy) {
        if (this.decodedChars == null || this.decodedCharsUsed == this.decodedCharsLen) {
            return StringLiterals.T_EMPTY_STRING;
        }
        TruffleString chars = this.decodedCharsUsed > 0 ? substringNode.execute((AbstractTruffleString)this.decodedChars, this.decodedCharsUsed, this.decodedCharsLen - this.decodedCharsUsed, PythonUtils.TS_ENCODING, lazy) : this.decodedChars;
        this.decodedCharsUsed = this.decodedCharsLen;
        return chars;
    }

    public void clearPendingBytes() {
        this.pendingBytes = BytesUtils.createOutputStream();
    }

    public byte[] getAndClearPendingBytes() {
        byte[] b = BytesUtils.toByteArray(this.pendingBytes);
        this.clearPendingBytes();
        return b;
    }

    public boolean hasPendingBytes() {
        return this.pendingBytes.size() != 0;
    }

    public void appendPendingBytes(byte[] bytes, int len) {
        BytesUtils.append(this.pendingBytes, bytes, len);
    }

    public int getPendingBytesCount() {
        return this.pendingBytes.size();
    }

    public int getSnapshotDecFlags() {
        return this.snapshotDecFlags;
    }

    public void setSnapshotDecFlags(int snapshotDecFlags) {
        this.snapshotDecFlags = snapshotDecFlags;
    }

    public byte[] getSnapshotNextInput() {
        return this.snapshotNextInput;
    }

    public boolean hasSnapshotNextInput() {
        return this.snapshotNextInput != null;
    }

    public void setSnapshotNextInput(byte[] snapshotNextInput) {
        this.snapshotNextInput = snapshotNextInput;
    }

    public void clearSnapshot() {
        this.snapshotNextInput = null;
        this.snapshotDecFlags = 0;
    }

    public double getB2cratio() {
        return this.b2cratio;
    }

    public void setB2cratio(double b2cratio) {
        this.b2cratio = b2cratio;
    }

    public PFileIO getFileIO() {
        return this.raw;
    }

    public boolean isFileIO() {
        return this.raw != null;
    }

    public void setFileIO(PFileIO raw) {
        this.raw = raw;
    }

    public static PTextIO createTextIO(Object cls, Shape instanceShape) {
        return new PTextIO(cls, instanceShape);
    }

    @CompilerDirectives.ValueType
    protected static class CookieType {
        private static final ByteArraySupport SERIALIZE = ByteArraySupport.littleEndian();
        private static final int COOKIE_BUF_LEN = 21;
        protected long startPos = 0L;
        protected int decFlags = 0;
        protected int bytesToFeed = 0;
        protected int charsToSkip = 0;
        protected byte needEOF = 0;

        CookieType() {
        }

        @CompilerDirectives.TruffleBoundary
        public static Object build(CookieType cookie) {
            byte[] buffer = new byte[21];
            SERIALIZE.putLong(buffer, 0, cookie.startPos);
            SERIALIZE.putInt(buffer, 8, cookie.decFlags);
            SERIALIZE.putInt(buffer, 12, cookie.bytesToFeed);
            SERIALIZE.putInt(buffer, 16, cookie.charsToSkip);
            SERIALIZE.putByte(buffer, 20, cookie.needEOF);
            return IntNodes.PyLongFromByteArray.executeUncached(buffer, true, false);
        }

        public static CookieType parse(long v, Node inliningTarget, InlinedConditionProfile overflow, PRaiseNode.Lazy raise) {
            byte[] buffer = IntBuiltins.ToBytesNode.fromLong(v, 21, false, false, inliningTarget, overflow, raise);
            return CookieType.parse(buffer);
        }

        public static CookieType parse(PInt v, Node inliningTarget, InlinedConditionProfile overflow, PRaiseNode.Lazy raise) {
            byte[] buffer = IntBuiltins.ToBytesNode.fromBigInteger(v, 21, false, false, inliningTarget, overflow, raise);
            return CookieType.parse(buffer);
        }

        public static CookieType parse(byte[] buffer) {
            CookieType cookie = new CookieType();
            cookie.startPos = SERIALIZE.getLong(buffer, 0);
            cookie.decFlags = SERIALIZE.getInt(buffer, 8);
            cookie.bytesToFeed = SERIALIZE.getInt(buffer, 12);
            cookie.charsToSkip = SERIALIZE.getInt(buffer, 16);
            cookie.needEOF = SERIALIZE.getByte(buffer, 20);
            return cookie;
        }
    }
}

