/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;

public final class GraalHPyTracker {
    private static final int HPYTRACKER_INITIAL_SIZE = 5;
    private GraalHPyHandle[] handles;
    private int cursor;

    public GraalHPyTracker(int capacity) {
        int size = capacity == 0 ? 5 : capacity;
        this.handles = new GraalHPyHandle[size];
    }

    public void add(GraalHPyHandle h) throws OverflowException {
        this.handles[this.cursor++] = h;
        if (this.handles.length <= this.cursor) {
            this.resize();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void resize() throws OverflowException {
        this.handles = Arrays.copyOf(this.handles, PythonUtils.multiplyExact(this.handles.length, 2) - 1);
    }

    public void free(Node inliningTarget, GraalHPyNodes.HPyCloseHandleNode closeHandleNode) {
        assert (this.cursor <= this.handles.length);
        for (int i = 0; i < this.cursor; ++i) {
            closeHandleNode.execute(inliningTarget, this.handles[i]);
        }
        this.cursor = 0;
    }

    public void removeAll() {
        for (int i = 0; i < this.handles.length; ++i) {
            this.handles[i] = null;
        }
        this.cursor = 0;
    }
}

