/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.structs;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import sun.misc.Unsafe;

public class CStructAccess {
    public static final long POINTER_SIZE = 8L;
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();

    private static boolean validPointer(Object pointer) {
        return !(pointer instanceof PythonAbstractObject) && !(pointer instanceof PythonNativeWrapper);
    }

    static long asPointer(Object value, InteropLibrary lib) {
        assert (CStructAccess.validPointer(value) || value instanceof PySequenceArrayWrapper);
        try {
            return lib.asPointer(value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static interface CStructAccessNode {
        public boolean accepts(ArgDescriptor var1);

        default public boolean accepts(CFields field) {
            return this.accepts(field.type);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteObjectNewRefNode
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, Object var4);

        public final void write(Object pointer, CFields field, Object value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void writeToObject(PythonNativeObject self, CFields field, Object value) {
            this.write(self.getPtr(), field, value);
        }

        public final void write(Object pointer, Object value) {
            this.execute(pointer, 0L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isPyObject();
        }

        public final void writeArray(Object pointer, Object[] values, int length, int sourceOffset, long targetOffset) {
            if (length > values.length) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, ((long)i + targetOffset) * 8L, values[i + sourceOffset]);
            }
        }

        public final void writeArrayElement(Object pointer, long element, Object value) {
            this.execute(pointer, element * 8L, value);
        }

        @Specialization
        static void writeLong(long pointer, long offset, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CApiTransitions.NativePtrToPythonNode toPython, @Cached.Shared @Cached CApiTransitions.PythonToNativeNewRefNode toNative, @Cached.Shared @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            assert (offset >= 0L);
            long old = UNSAFE.getLong(pointer + offset);
            if (old != 0L) {
                toPython.execute(old, true);
            }
            long lvalue = coerceToLongNode.execute(inliningTarget, toNative.execute(value));
            UNSAFE.putLong(pointer + offset, lvalue);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"})
        static void writePointer(Object pointer, long offset, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CApiTransitions.NativePtrToPythonNode toPython, @Cached.Shared @Cached CApiTransitions.PythonToNativeNewRefNode toNative, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            WriteObjectNewRefNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value, inliningTarget, toPython, toNative, coerceToLongNode);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, Object value, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached CApiTransitions.PythonToNativeNode toNative, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_OBJECT_MEMBER, pointer, offset, toNative.execute(value));
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WritePointerNode
    extends Node
    implements CStructAccessNode {
        public static void writeUncached(Object pointer, CFields field, Object value) {
            CStructAccessFactory.WritePointerNodeGen.getUncached().write(pointer, field, value);
        }

        public static void writeUncached(Object pointer, long offset, Object value) {
            CStructAccessFactory.WritePointerNodeGen.getUncached().execute(pointer, offset, value);
        }

        public static void writeArrayElementUncached(long pointer, long element, long value) {
            UNSAFE.putLong(pointer + element * 8L, value);
        }

        abstract void execute(Object var1, long var2, Object var4);

        public final void write(Object pointer, CFields field, Object value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void writeToObj(PythonAbstractNativeObject obj, CFields field, Object value) {
            this.write(obj.getPtr(), field, value);
        }

        public final void write(Object pointer, Object value) {
            this.execute(pointer, 0L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isPyObjectOrPointer();
        }

        public final void writeArrayElement(Object pointer, long element, Object value) {
            this.execute(pointer, element * 8L, value);
        }

        public final void writePointerArray(Object pointer, long[] values, int length, int sourceOffset, long targetOffset) {
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, ((long)i + targetOffset) * 8L, values[i + sourceOffset]);
            }
        }

        @Specialization
        static void writeLong(long pointer, long offset, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            assert (offset >= 0L);
            UNSAFE.putLong(pointer + offset, coerceToLongNode.execute(inliningTarget, value));
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached.Shared @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            WritePointerNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value, inliningTarget, coerceToLongNode);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, Object value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_POINTER_MEMBER, pointer, offset, value);
        }

        public static WritePointerNode getUncached() {
            return CStructAccessFactory.WritePointerNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteLongNode
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, long var4);

        public final void write(Object pointer, CFields field, long value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void writeToObject(PythonNativeObject self, CFields field, long value) {
            this.write(self.getPtr(), field, value);
        }

        public final void write(Object pointer, long value) {
            this.execute(pointer, 0L, value);
        }

        public final void writeLongArray(Object pointer, long[] values) {
            this.writeLongArray(pointer, values, values.length, 0, 0L);
        }

        public final void writeLongArray(Object pointer, long[] values, int length, int sourceOffset, long targetOffset) {
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, ((long)i + targetOffset) * 8L, values[i + sourceOffset]);
            }
        }

        public final void writeIntArray(Object pointer, int[] values) {
            this.writeIntArray(pointer, values, values.length, 0, 0L);
        }

        public final void writeIntArray(Object pointer, int[] values, int length, int sourceOffset, long targetOffset) {
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, ((long)i + targetOffset) * 8L, values[i + sourceOffset]);
            }
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI64();
        }

        @Specialization
        static void writeLong(long pointer, long offset, long value) {
            assert (offset >= 0L);
            UNSAFE.putLong(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, long value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteLongNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, long value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_LONG_MEMBER, pointer, offset, value);
        }

        public static WriteLongNode getUncached() {
            return CStructAccessFactory.WriteLongNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteIntNode
    extends Node
    implements CStructAccessNode {
        public static void writeUncached(Object pointer, CFields field, int value) {
            CStructAccessFactory.WriteIntNodeGen.getUncached().write(pointer, field, value);
        }

        abstract void execute(Object var1, long var2, int var4);

        public final void write(Object pointer, CFields field, int value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void write(Object pointer, int value) {
            this.execute(pointer, 0L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI32();
        }

        public final void writeArray(Object pointer, int[] values) {
            this.writeArray(pointer, values, values.length, 0, 0L);
        }

        public final void writeArray(Object pointer, int[] values, int length, int sourceOffset, long targetOffset) {
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, ((long)i + targetOffset) * 4L, values[i + sourceOffset]);
            }
        }

        public final void writeArrayElement(Object pointer, long element, int value) {
            this.execute(pointer, element * 4L, value);
        }

        public final void writeStructArrayElement(Object pointer, long element, CFields field, int value) {
            this.execute(pointer, element * (long)field.struct.size() + field.offset(), value);
        }

        @Specialization
        static void writeLong(long pointer, long offset, int value) {
            assert (offset >= 0L);
            UNSAFE.putInt(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, int value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteIntNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, int value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_INT_MEMBER, pointer, offset, value);
        }

        public static WriteIntNode getUncached() {
            return CStructAccessFactory.WriteIntNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteI16Node
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, short var4);

        public final void write(Object pointer, CFields field, short value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void write(Object pointer, short value) {
            this.execute(pointer, 0L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI16();
        }

        @Specialization
        static void writeLong(long pointer, long offset, short value) {
            assert (offset >= 0L);
            UNSAFE.putShort(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, short value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteI16Node.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, short value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_SHORT_MEMBER, pointer, offset, value);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteFloatNode
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, float var4);

        public final void write(Object pointer, CFields field, float value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void write(Object pointer, float value) {
            this.execute(pointer, 0L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isFloat();
        }

        @Specialization
        static void writeLong(long pointer, long offset, float value) {
            assert (offset >= 0L);
            UNSAFE.putFloat(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, float value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteFloatNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, float value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_FLOAT_MEMBER, pointer, offset, Float.valueOf(value));
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteDoubleNode
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, double var4);

        public final void write(Object pointer, CFields field, double value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void write(Object pointer, double value) {
            this.execute(pointer, 0L, value);
        }

        public final void writeArrayElement(Object pointer, long element, double value) {
            this.execute(pointer, element * 8L, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isDouble();
        }

        @Specialization
        static void writeLong(long pointer, long offset, double value) {
            assert (offset >= 0L);
            UNSAFE.putDouble(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, double value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteDoubleNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, double value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_DOUBLE_MEMBER, pointer, offset, value);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class WriteByteNode
    extends Node
    implements CStructAccessNode {
        abstract void execute(Object var1, long var2, byte var4);

        public final void write(Object pointer, CFields field, byte value) {
            assert (this.accepts(field));
            this.execute(pointer, field.offset(), value);
        }

        public final void write(Object pointer, byte value) {
            this.execute(pointer, 0L, value);
        }

        public final void writeToObject(PythonNativeObject self, CFields field, byte value) {
            this.write(self.getPtr(), field, value);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI8();
        }

        public final void writeByteArray(Object pointer, byte[] values) {
            this.writeByteArray(pointer, values, values.length, 0, 0);
        }

        public final void writeByteArray(Object pointer, byte[] values, int length, int sourceOffset, int targetOffset) {
            for (int i = 0; i < length; ++i) {
                this.execute(pointer, (i + targetOffset) * 1, values[i + sourceOffset]);
            }
        }

        public final void writeArrayElement(Object pointer, long element, byte value) {
            this.execute(pointer, element * 1L, value);
        }

        @Specialization
        static void writeLong(long pointer, long offset, byte value) {
            assert (offset >= 0L);
            UNSAFE.putByte(pointer + offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void writePointer(Object pointer, long offset, byte value, @CachedLibrary(value="pointer") InteropLibrary lib) {
            WriteByteNode.writeLong(CStructAccess.asPointer(pointer, lib), offset, value);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void writeManaged(Object pointer, long offset, byte value, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_WRITE_CHAR_MEMBER, pointer, offset, value);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadCharPtrNode
    extends ReadBaseNode {
        abstract TruffleString execute(Object var1, long var2);

        public final TruffleString read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final TruffleString readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isCharPtr();
        }

        public final TruffleString readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 8L);
        }

        public final TruffleString readStructArrayElement(Object pointer, long element, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, element * (long)field.struct.size() + field.offset());
        }

        @Specialization
        static TruffleString readLong(long pointer, long offset, @Cached.Shared @Cached CExtNodes.FromCharPointerNode toPython) {
            assert (offset >= 0L);
            return toPython.execute(UNSAFE.getLong(pointer + offset));
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static TruffleString readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached.Shared @Cached CExtNodes.FromCharPointerNode toPython) {
            return ReadCharPtrNode.readLong(CStructAccess.asPointer(pointer, lib), offset, toPython);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static TruffleString readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call, @Cached.Shared @Cached CExtNodes.FromCharPointerNode toPython) {
            assert (CStructAccess.validPointer(pointer));
            return toPython.execute(call.call(NativeCAPISymbol.FUN_READ_POINTER_MEMBER, pointer, offset));
        }

        public static ReadCharPtrNode getUncached() {
            return CStructAccessFactory.ReadCharPtrNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadObjectNode
    extends ReadBaseNode {
        abstract Object execute(Object var1, long var2);

        public final Object read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final Object readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isPyObject();
        }

        public final Object readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 8L);
        }

        public final Object[] readPyObjectArray(Object pointer, int elements) {
            return this.readPyObjectArray(pointer, elements, 0);
        }

        public final Object[] readPyObjectArray(Object pointer, int elements, int offset) {
            Object[] result = new Object[elements];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.execute(pointer, (long)(i + offset) * 8L);
            }
            return result;
        }

        @Specialization
        static Object readLong(long pointer, long offset, @Cached.Shared @Cached CApiTransitions.NativePtrToPythonNode toPython) {
            assert (offset >= 0L);
            return toPython.execute(UNSAFE.getLong(pointer + offset), false);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static Object readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached.Shared @Cached CApiTransitions.NativePtrToPythonNode toPython) {
            return ReadObjectNode.readLong(CStructAccess.asPointer(pointer, lib), offset, toPython);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static Object readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call, @Cached CApiTransitions.NativeToPythonNode toPython) {
            assert (CStructAccess.validPointer(pointer));
            return toPython.execute(call.call(NativeCAPISymbol.FUN_READ_POINTER_MEMBER, pointer, offset));
        }

        public static ReadObjectNode getUncached() {
            return CStructAccessFactory.ReadObjectNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadPointerNode
    extends ReadBaseNode {
        abstract Object execute(Object var1, long var2);

        public final Object read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public static Object readUncached(Object pointer, CFields field) {
            return ReadPointerNode.getUncached().read(pointer, field);
        }

        public final Object readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isPyObjectOrPointer();
        }

        public final Object readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 8L);
        }

        public final Object readStructArrayElement(Object pointer, long element, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, element * (long)field.struct.size() + field.offset());
        }

        @Specialization
        static Object readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return new NativePointer(UNSAFE.getLong(pointer + offset));
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static Object readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadPointerNode.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static Object readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            return call.call(NativeCAPISymbol.FUN_READ_POINTER_MEMBER, pointer, offset);
        }

        public static ReadPointerNode getUncached() {
            return CStructAccessFactory.ReadPointerNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadDoubleNode
    extends ReadBaseNode {
        abstract double execute(Object var1, long var2);

        public final double read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final double readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isDouble();
        }

        public final double readArrayElement(Object pointer, int element) {
            return this.execute(pointer, element * 8);
        }

        @Specialization
        static double readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return UNSAFE.getDouble(pointer + offset);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static double readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadDoubleNode.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static double readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @CachedLibrary(limit="3") InteropLibrary resultLib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            Object result = call.call(NativeCAPISymbol.FUN_READ_DOUBLE_MEMBER, pointer, offset);
            if (result instanceof Double) {
                return (Double)result;
            }
            try {
                return resultLib.asDouble(result);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        public static ReadDoubleNode getUncached() {
            return CStructAccessFactory.ReadDoubleNodeGen.getUncached();
        }

        @NeverDefault
        public static ReadDoubleNode create() {
            return CStructAccessFactory.ReadDoubleNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadFloatNode
    extends ReadBaseNode {
        abstract double execute(Object var1, long var2);

        public final double read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final double readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isDouble();
        }

        public final double readArrayElement(Object pointer, int element) {
            return this.execute(pointer, element * 4);
        }

        @Specialization
        static double readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return UNSAFE.getFloat(pointer + offset);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static double readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadFloatNode.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static double readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @CachedLibrary(limit="3") InteropLibrary resultLib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            Object result = call.call(NativeCAPISymbol.FUN_READ_FLOAT_MEMBER, pointer, offset);
            if (result instanceof Double) {
                return (Double)result;
            }
            try {
                return resultLib.asFloat(result);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        public static ReadFloatNode getUncached() {
            return CStructAccessFactory.ReadFloatNodeGen.getUncached();
        }

        @NeverDefault
        public static ReadFloatNode create() {
            return CStructAccessFactory.ReadFloatNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadI64Node
    extends ReadBaseNode {
        abstract long execute(Object var1, long var2);

        public final long read(Object pointer) {
            return this.execute(pointer, 0L);
        }

        public final long read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final long readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI64();
        }

        public final long[] readLongArray(Object pointer, int elements) {
            return this.readLongArray(pointer, elements, 0);
        }

        public final long[] readLongArray(Object pointer, int elements, int offset) {
            long[] result = new long[elements];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.execute(pointer, (long)(i + offset) * 8L);
            }
            return result;
        }

        public final int[] readLongAsIntArray(Object pointer, int elements) {
            return this.readLongAsIntArray(pointer, elements, 0);
        }

        public final int[] readLongAsIntArray(Object pointer, int elements, int offset) {
            int[] result = new int[elements];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (int)this.execute(pointer, (long)(i + offset) * 8L);
            }
            return result;
        }

        public final long readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 8L);
        }

        public final long readStructArrayElement(Object pointer, long element, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, element * (long)field.struct.size() + field.offset());
        }

        @Specialization
        static long readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return UNSAFE.getLong(pointer + offset);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static long readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadI64Node.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static long readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @CachedLibrary(limit="3") InteropLibrary resultLib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            Object result = call.call(NativeCAPISymbol.FUN_READ_LONG_MEMBER, pointer, offset);
            if (result instanceof Long) {
                return (Long)result;
            }
            try {
                return resultLib.asLong(result);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        public static ReadI64Node getUncached() {
            return CStructAccessFactory.ReadI64NodeGen.getUncached();
        }

        @NeverDefault
        public static ReadI64Node create() {
            return CStructAccessFactory.ReadI64NodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadI32Node
    extends ReadBaseNode {
        public static int readUncached(Object pointer, CFields field) {
            return CStructAccessFactory.ReadI32NodeGen.getUncached().read(pointer, field);
        }

        abstract int execute(Object var1, long var2);

        public final int read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI32();
        }

        public final int readOffset(Object pointer, long offset) {
            return this.execute(pointer, offset);
        }

        public final int readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 4L);
        }

        public final int readStructArrayElement(Object pointer, long element, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, element * (long)field.struct.size() + field.offset());
        }

        @Specialization
        static int readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return UNSAFE.getInt(pointer + offset);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static int readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadI32Node.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static int readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            return (Integer)call.call(NativeCAPISymbol.FUN_READ_INT_MEMBER, pointer, offset);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadI16Node
    extends ReadBaseNode {
        abstract int execute(Object var1, long var2);

        public final int read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI16();
        }

        public final int readOffset(Object pointer, long offset) {
            return this.execute(pointer, offset);
        }

        public final int readArrayElement(Object pointer, long element) {
            return this.execute(pointer, element * 2L);
        }

        @Specialization
        static int readLong(long pointer, long offset) {
            assert (offset >= 0L);
            return UNSAFE.getShort(pointer + offset);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static int readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return ReadI16Node.readLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static int readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            return (Integer)call.call(NativeCAPISymbol.FUN_READ_SHORT_MEMBER, pointer, offset);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class ReadByteNode
    extends ReadBaseNode {
        abstract int execute(Object var1, long var2);

        public final int read(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        public final int readFromObj(PythonNativeObject self, CFields field) {
            return this.read(self.getPtr(), field);
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return desc.isI8();
        }

        public final byte[] readByteArray(Object pointer, int elements) {
            return this.readByteArray(pointer, elements, 0L);
        }

        public final byte[] readByteArray(Object pointer, int elements, long sourceOffset) {
            byte[] result = new byte[elements];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)this.execute(pointer, ((long)i + sourceOffset) * 1L);
            }
            return result;
        }

        public final void readByteArray(Object pointer, byte[] target, int length, long sourceOffset, int targetOffset) {
            for (int i = 0; i < length; ++i) {
                target[i + targetOffset] = (byte)this.execute(pointer, ((long)i + sourceOffset) * 1L);
            }
        }

        public final byte readArrayElement(Object pointer, long element) {
            return (byte)this.execute(pointer, element);
        }

        @Specialization
        static int readLong(long pointer, long offset, @Cached.Shared @Cached(value="isCharSigned()", allowUncached=true, neverDefault=false) boolean isCharSigned) {
            assert (offset >= 0L);
            byte signedByteValue = UNSAFE.getByte(pointer + offset);
            if (isCharSigned) {
                return signedByteValue;
            }
            return Byte.toUnsignedInt(signedByteValue);
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static int readPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached.Shared @Cached(value="isCharSigned()", allowUncached=true, neverDefault=false) boolean isCharSigned) {
            return ReadByteNode.readLong(CStructAccess.asPointer(pointer, lib), offset, isCharSigned);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static int readManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            return (Integer)call.call(NativeCAPISymbol.FUN_READ_CHAR_MEMBER, pointer, offset);
        }

        protected static boolean isCharSigned() {
            return CConstants.CHAR_MIN.longValue() < 0L;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class GetElementPtrNode
    extends ReadBaseNode {
        abstract Object execute(Object var1, long var2);

        public final Object getElementPtr(Object pointer, CFields field) {
            assert (this.accepts(field));
            return this.execute(pointer, field.offset());
        }

        @Override
        public final boolean accepts(ArgDescriptor desc) {
            return true;
        }

        @Specialization
        static long getLong(long pointer, long offset) {
            return pointer + offset;
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static long getPointer(Object pointer, long offset, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return GetElementPtrNode.getLong(CStructAccess.asPointer(pointer, lib), offset);
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static Object getManaged(Object pointer, long offset, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            return call.call(NativeCAPISymbol.FUN_PTR_ADD, pointer, offset);
        }

        public static GetElementPtrNode getUncached() {
            return CStructAccessFactory.GetElementPtrNodeGen.getUncached();
        }
    }

    public static abstract class ReadBaseNode
    extends Node
    implements CStructAccessNode {
        abstract Object executeGeneric(Object var1, long var2);

        public final Object readGeneric(Object pointer, long offset) {
            return this.executeGeneric(pointer, offset);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class FreeNode
    extends Node {
        public static void executeUncached(Object pointer) {
            CStructAccessFactory.FreeNodeGen.getUncached().execute(pointer);
        }

        abstract void execute(Object var1);

        public final void free(Object pointer) {
            this.execute(pointer);
        }

        @Specialization
        static void freeLong(long pointer) {
            UNSAFE.freeMemory(pointer);
        }

        @Specialization
        static void freeNativePointer(NativePointer pointer) {
            UNSAFE.freeMemory(pointer.asPointer());
        }

        @Specialization(guards={"!isLong(pointer)", "lib.isPointer(pointer)"}, limit="3")
        static void freePointer(Object pointer, @CachedLibrary(value="pointer") InteropLibrary lib) {
            UNSAFE.freeMemory(CStructAccess.asPointer(pointer, lib));
        }

        @Specialization(guards={"!isLong(pointer)", "!lib.isPointer(pointer)"})
        static void freeManaged(Object pointer, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CExtNodes.PCallCapiFunction call) {
            assert (CStructAccess.validPointer(pointer));
            call.call(NativeCAPISymbol.FUN_FREE, pointer);
        }

        @NeverDefault
        public static FreeNode create() {
            return CStructAccessFactory.FreeNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class AllocateNode
    extends Node {
        abstract Object execute(long var1, long var3, boolean var5);

        public final Object alloc(CStructs struct) {
            return this.execute(1L, struct.size(), false);
        }

        public final Object calloc(long count, CStructs elstruct) {
            return this.execute(count, elstruct.size(), false);
        }

        public final Object alloc(CStructs struct, boolean allocatePyMem) {
            return this.execute(1L, struct.size(), allocatePyMem);
        }

        public final Object alloc(long size) {
            return this.execute(1L, size, false);
        }

        public final Object calloc(long count, long elSize) {
            return this.execute(count, elSize, false);
        }

        public Object alloc(int size, boolean allocatePyMem) {
            return this.execute(1L, size, allocatePyMem);
        }

        @NonIdempotent
        final boolean nativeAccess() {
            return PythonContext.get(this).isNativeAccessAllowed();
        }

        @Specialization(guards={"!allocatePyMem", "nativeAccess()"})
        static Object allocLong(long count, long size, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile overflowProfile) {
            assert (count >= 0L);
            assert (size >= 0L);
            try {
                long totalSize = Math.multiplyExact(count, size);
                long memory = UNSAFE.allocateMemory(totalSize == 0L ? 1L : totalSize);
                UNSAFE.setMemory(memory, totalSize, (byte)0);
                return new NativePointer(memory);
            }
            catch (ArithmeticException e) {
                overflowProfile.enter(inliningTarget);
                return NativePointer.createNull();
            }
        }

        @Specialization(guards={"!allocatePyMem", "!nativeAccess()"})
        static Object allocLong(long count, long size, boolean allocatePyMem, @Cached.Shared @Cached CExtNodes.PCallCapiFunction call) {
            assert (size >= 0L);
            return call.call(NativeCAPISymbol.FUN_CALLOC, count, size == 0L ? 1L : size);
        }

        @Specialization(guards={"allocatePyMem"})
        static Object allocLongPyMem(long count, long elsize, boolean allocatePyMem, @Cached.Shared @Cached CExtNodes.PCallCapiFunction call) {
            assert (elsize >= 0L);
            return call.call(NativeCAPISymbol.FUN_PYMEM_ALLOC, count, elsize);
        }

        public static Object allocUncached(CStructs struct) {
            return CStructAccessFactory.AllocateNodeGen.getUncached().alloc(struct);
        }

        public static Object callocUncached(long count, CStructs elstruct) {
            return CStructAccessFactory.AllocateNodeGen.getUncached().calloc(count, elstruct);
        }

        public static Object allocUncached(long size) {
            return CStructAccessFactory.AllocateNodeGen.getUncached().alloc(size);
        }

        public static Object callocUncached(long count, long elSize) {
            return CStructAccessFactory.AllocateNodeGen.getUncached().calloc(count, elSize);
        }
    }
}

