/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.math.BigInteger;

public final class PBigRangeIterator
extends PBuiltinIterator {
    private final PInt start;
    private final PInt stop;
    private final PInt step;
    private final PInt len;
    private BigInteger longIndex;

    public PBigRangeIterator(Object clazz, Shape instanceShape, PInt start, PInt stop, PInt step, PInt len) {
        super(clazz, instanceShape);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.len = len;
        this.longIndex = BigInteger.ZERO;
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger getRemainingLength() {
        return this.len.subtract(this.longIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger nextBigInt() {
        BigInteger nextVal = this.start.add(this.longIndex.multiply(this.step.getValue()));
        this.longIndex = this.longIndex.add(BigInteger.ONE);
        return nextVal;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasNextBigInt() {
        return this.longIndex.compareTo(this.len.getValue()) < 0;
    }

    public PInt getStart() {
        return this.start;
    }

    public PInt getStop() {
        return this.stop;
    }

    public PInt getStep() {
        return this.step;
    }

    public PInt getLen() {
        return this.len;
    }

    public PInt getLongIndex(PythonObjectFactory factory) {
        return factory.createInt(this.longIndex);
    }

    public void setLongIndex(BigInteger idx) {
        this.longIndex = idx;
    }
}

