/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyLongAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyLongAsDoubleNode
extends PNodeWithContext {
    public static double executeUncached(Object object) {
        return PyLongAsDoubleNodeGen.getUncached().execute(null, object);
    }

    public abstract double execute(Node var1, Object var2);

    @Specialization
    static double doBoolean(boolean self) {
        return self ? 1.0 : 0.0;
    }

    @Specialization
    static double doInt(int self) {
        return self;
    }

    @Specialization
    static double doLong(long self) {
        return self;
    }

    @Specialization
    static double doPInt(Node inliningTarget, PInt self) {
        return self.doubleValueWithOverflow(inliningTarget);
    }

    @Specialization(guards={"check.execute(inliningTarget, self)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static double doNative(Node inliningTarget, PythonAbstractNativeObject self, @Cached PyLongCheckNode check) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CASTING_A_NATIVE_INT_OBJECT_IS_NOT_IMPLEMENTED_YET);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static double fallback(Node inliningTarget, Object object, @Cached(inline=false) PRaiseNode raiseNode) {
        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
    }
}

