/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=PyLongFromDoubleNode.class)
public final class PyLongFromDoubleNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2LD(Node thisNode_, Object arg0Value, double arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
    }

    @NeverDefault
    public static PyLongFromDoubleNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static PyLongFromDoubleNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Uncached
    extends PyLongFromDoubleNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Node arg0Value, double arg1Value) {
            if (MathGuards.fitInt(arg1Value)) {
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if (MathGuards.fitLong(arg1Value)) {
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if (!MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                return PyLongFromDoubleNode.doFinite(arg1Value, PythonObjectFactory.getUncached());
            }
            if (!PyLongFromDoubleNode.isFinite(arg1Value)) {
                return PyLongFromDoubleNode.doInfinite(arg1Value, PRaiseNode.getUncached());
            }
            throw PyLongFromDoubleNodeGen.newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }
    }

    @GeneratedBy(value=PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Inlined
    extends PyLongFromDoubleNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;
        private final InlineSupport.ReferenceField<PythonObjectFactory> finite_factory_;
        private final InlineSupport.ReferenceField<PRaiseNode> infinite_raiseNode_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(PyLongFromDoubleNode.class));
            this.state_0_ = target.getState(0, 4);
            this.finite_factory_ = target.getReference(1, PythonObjectFactory.class);
            this.infinite_raiseNode_ = target.getReference(2, PRaiseNode.class);
        }

        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0) {
                PRaiseNode raiseNode__;
                PythonObjectFactory factory__;
                if ((state_0 & 1) != 0 && MathGuards.fitInt(arg1Value)) {
                    return PyLongFromDoubleNode.doInt(arg1Value);
                }
                if ((state_0 & 2) != 0 && MathGuards.fitLong(arg1Value)) {
                    return PyLongFromDoubleNode.doLong(arg1Value);
                }
                if ((state_0 & 4) != 0 && (factory__ = (PythonObjectFactory)((Object)this.finite_factory_.get(arg0Value))) != null && !MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                    return PyLongFromDoubleNode.doFinite(arg1Value, factory__);
                }
                if ((state_0 & 8) != 0 && (raiseNode__ = (PRaiseNode)((Object)this.infinite_raiseNode_.get(arg0Value))) != null && !PyLongFromDoubleNode.isFinite(arg1Value)) {
                    return PyLongFromDoubleNode.doInfinite(arg1Value, raiseNode__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (MathGuards.fitInt(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 1);
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if (MathGuards.fitLong(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 2);
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if (!MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                PythonObjectFactory factory__ = (PythonObjectFactory)arg0Value.insert((Node)PythonObjectFactory.create());
                Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.finite_factory_.set(arg0Value, (Object)factory__);
                this.state_0_.set(arg0Value, state_0 |= 4);
                return PyLongFromDoubleNode.doFinite(arg1Value, factory__);
            }
            if (!PyLongFromDoubleNode.isFinite(arg1Value)) {
                PRaiseNode raiseNode__ = (PRaiseNode)arg0Value.insert((Node)PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.infinite_raiseNode_.set(arg0Value, (Object)raiseNode__);
                this.state_0_.set(arg0Value, state_0 |= 8);
                return PyLongFromDoubleNode.doInfinite(arg1Value, raiseNode__);
            }
            throw PyLongFromDoubleNodeGen.newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }
    }
}

