/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@ImportStatic(value={SpecialMethodSlot.class})
@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyNumberIndexNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3);

    public static Object executeUncached(Object object) {
        return PyNumberIndexNodeGen.getUncached().execute(null, null, object);
    }

    @Specialization
    static int doInt(int object) {
        return object;
    }

    @Specialization
    static long doLong(long object) {
        return object;
    }

    @Specialization
    static PInt doPInt(PInt object) {
        return object;
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    static int doCallIndexInt(VirtualFrame frame, Node inliningTarget, Object object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupIndex") @Cached(parameters={"Index"}, inline=false) LookupSpecialMethodSlotNode lookupIndex, @Cached.Shared(value="callIndex") @Cached(inline=false) CallUnaryMethodNode callIndex, @Cached.Shared(value="isSubtype") @Cached(inline=false) IsSubtypeNode isSubtype, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) throws UnexpectedResultException {
        Object type = getClassNode.execute(inliningTarget, object);
        if (isSubtype.execute(type, (Object)PythonBuiltinClassType.PInt)) {
            throw new UnexpectedResultException(object);
        }
        Object indexDescr = lookupIndex.execute((Frame)frame, type, object);
        if (indexDescr == PNone.NO_VALUE) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, object);
        }
        try {
            return PGuards.expectInteger(callIndex.executeObject((Frame)frame, indexDescr, object));
        }
        catch (UnexpectedResultException e) {
            Object result = PyNumberIndexNode.checkResult(frame, object, e.getResult(), null, GetClassNode.getUncached(), IsSubtypeNode.getUncached(), PyLongCheckExactNode.getUncached(), PRaiseNode.Lazy.getUncached(), WarningsModuleBuiltins.WarnNode.getUncached(), PythonObjectFactory.getUncached());
            throw new UnexpectedResultException(result);
        }
    }

    @Specialization(replaces={"doCallIndexInt"})
    static Object doCallIndex(VirtualFrame frame, Node inliningTarget, Object object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupIndex") @Cached(parameters={"Index"}, inline=false) LookupSpecialMethodSlotNode lookupIndex, @Cached.Shared(value="callIndex") @Cached(inline=false) CallUnaryMethodNode callIndex, @Cached.Shared(value="isSubtype") @Cached(inline=false) IsSubtypeNode isSubtype, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GetClassNode resultClassNode, @Cached.Exclusive @Cached(inline=false) IsSubtypeNode resultSubtype, @Cached PyLongCheckExactNode isInt, @Cached(inline=false) WarningsModuleBuiltins.WarnNode warnNode, @Cached(inline=false) PythonObjectFactory factory) {
        Object type = getClassNode.execute(inliningTarget, object);
        if (isSubtype.execute(type, (Object)PythonBuiltinClassType.PInt)) {
            return object;
        }
        Object indexDescr = lookupIndex.execute((Frame)frame, type, object);
        if (indexDescr == PNone.NO_VALUE) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, object);
        }
        Object result = callIndex.executeObject((Frame)frame, indexDescr, object);
        return PyNumberIndexNode.checkResult(frame, object, result, inliningTarget, resultClassNode, resultSubtype, isInt, raiseNode, warnNode, factory);
    }

    private static Object checkResult(VirtualFrame frame, Object originalObject, Object result, Node inliningTarget, GetClassNode getClassNode, IsSubtypeNode isSubtype, PyLongCheckExactNode isInt, PRaiseNode.Lazy raiseNode, WarningsModuleBuiltins.WarnNode warnNode, PythonObjectFactory factory) {
        if (isInt.execute(inliningTarget, result)) {
            return result;
        }
        if (!isSubtype.execute(getClassNode.execute(inliningTarget, result), (Object)PythonBuiltinClassType.PInt)) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, result);
        }
        warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, originalObject, SpecialMethodNames.T___INDEX__, "int", result, "int");
        if (result instanceof PInt) {
            return factory.createInt(((PInt)result).getValue());
        }
        if (result instanceof Boolean) {
            return (Boolean)result != false ? 1 : 0;
        }
        if (result instanceof PythonAbstractNativeObject) {
            throw CompilerDirectives.shouldNotReachHere((String)"Cannot convert native result from __index__");
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected type returned from __index__");
    }
}

