/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.release_callback;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.arrow.ArrowArray;
import com.oracle.graal.python.nodes.arrow.release_callback.ArrowArrayReleaseCallbackNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

@ExportLibrary(value=InteropLibrary.class)
public class ArrowArrayReleaseCallback
implements TruffleObject {
    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(guards={"isPointer(args)"})
        static Object doRelease(ArrowArrayReleaseCallback self, Object[] args, @Bind(value="$node") Node inliningTarget, @Bind(value="wrapArrowArray(args)") ArrowArray arrowArray, @Cached ArrowArrayReleaseCallbackNode releaseNode) {
            releaseNode.execute(inliningTarget, arrowArray);
            return PNone.NO_VALUE;
        }

        @Fallback
        static Object doError(ArrowArrayReleaseCallback self, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        static ArrowArray wrapArrowArray(Object[] args) {
            long arrowArrayPointer = (Long)args[0];
            return ArrowArray.wrap(arrowArrayPointer);
        }

        static boolean isPointer(Object[] args) {
            return args.length == 1 && args[0] instanceof Long;
        }
    }
}

