/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.ForIterINodeGen;
import com.oracle.graal.python.nodes.bytecode.QuickeningGeneralizeException;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ForIterINode
extends PNodeWithContext {
    public abstract boolean execute(Frame var1, Object var2, int var3) throws QuickeningGeneralizeException;

    @Specialization
    boolean doIntRange(VirtualFrame frame, PIntRangeIterator iterator, int stackTop, @Bind(value="this") Node inliningTarget, @Cached InlinedCountingConditionProfile conditionProfile) {
        if (conditionProfile.profile(inliningTarget, iterator.hasNextInt())) {
            frame.setInt(stackTop, iterator.nextInt());
            return true;
        }
        iterator.setExhausted();
        return false;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static boolean doGeneric(VirtualFrame frame, Object iterator, int stackTop, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(parameters={"Next"}) LookupSpecialMethodSlotNode lookupNext, @Cached CallUnaryMethodNode callNext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached PRaiseNode raiseNode) throws QuickeningGeneralizeException {
        Object nextMethod = lookupNext.execute((Frame)frame, getClassNode.execute(inliningTarget, iterator), iterator);
        if (nextMethod == PNone.NO_VALUE) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, iterator);
        }
        try {
            Object res = callNext.executeObject((Frame)frame, nextMethod, iterator);
            if (res instanceof Integer) {
                frame.setInt(stackTop, ((Integer)res).intValue());
                return true;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            frame.setObject(stackTop, res);
            throw new QuickeningGeneralizeException(1);
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, stopIterationProfile);
            return false;
        }
    }

    public static ForIterINode create() {
        return ForIterINodeGen.create();
    }

    public static ForIterINode getUncached() {
        return ForIterINodeGen.getUncached();
    }
}

