/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.bytecode.ImportStarNodeGen;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ImportStarNode
extends AbstractImportNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString[] T_IMPORT_ALL = PythonUtils.tsArray("*");

    public abstract void execute(VirtualFrame var1, TruffleString var2, int var3);

    @Specialization
    void doImport(VirtualFrame frame, TruffleString moduleName, int level, @Bind(value="this") Node inliningTarget, @Cached AbstractImportNode.ImportName importNameNode, @Cached PyObjectSetItem setItemNode, @Cached PyObjectSetAttr setAttrNode, @Cached GetOrCreateDictNode getDictNode, @Cached PyObjectGetAttr getAttrNode, @Cached PyObjectGetIter getIterNode, @Cached GetNextNode getNextNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectGetItem getItemNode, @Cached InlinedConditionProfile javaImport, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttributeErrorProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile) {
        Object importedModule = this.importModule(frame, moduleName, PArguments.getGlobals((Frame)frame), T_IMPORT_ALL, level, importNameNode);
        Object locals = PArguments.getSpecialArgument((Frame)frame);
        if (locals == null) {
            locals = PArguments.getGlobals((Frame)frame);
        }
        if (javaImport.profile(inliningTarget, this.emulateJython() && this.getContext().getEnv().isHostObject(importedModule))) {
            try {
                InteropLibrary interopLib = (InteropLibrary)InteropLibrary.getFactory().getUncached();
                Object hostAttrs = interopLib.getMembers(importedModule, true);
                int len = (int)interopLib.getArraySize(hostAttrs);
                for (int i = 0; i < len; ++i) {
                    String attrName = interopLib.asString(interopLib.readArrayElement(hostAttrs, (long)i));
                    Object attr = interopLib.readMember(importedModule, attrName);
                    attr = PForeignToPTypeNode.getUncached().executeConvert(attr);
                    ImportStarNode.writeAttribute(frame, inliningTarget, locals, TruffleString.fromJavaStringUncached((String)attrName, (TruffleString.Encoding)PythonUtils.TS_ENCODING), attr, setItemNode, setAttrNode);
                }
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException(e);
            }
        }
        try {
            Object attrAll = getAttrNode.execute((Frame)frame, inliningTarget, importedModule, SpecialAttributeNames.T___ALL__);
            int n = sizeNode.execute((Frame)frame, inliningTarget, attrAll);
            for (int i = 0; i < n; ++i) {
                Object attrName = getItemNode.execute((Frame)frame, inliningTarget, attrAll, i);
                this.writeAttributeToLocals(frame, inliningTarget, moduleName, (PythonModule)importedModule, locals, attrName, true, castToTruffleStringNode, codePointLengthNode, codePointAtIndexNode, getAttrNode, setItemNode, setAttrNode);
            }
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, isAttributeErrorProfile);
            assert (importedModule instanceof PythonModule);
            Object keysIterator = getIterNode.execute((Frame)frame, inliningTarget, getDictNode.execute(inliningTarget, importedModule));
            try {
                while (true) {
                    Object key = getNextNode.execute((Frame)frame, keysIterator);
                    this.writeAttributeToLocals(frame, inliningTarget, moduleName, (PythonModule)importedModule, locals, key, false, castToTruffleStringNode, codePointLengthNode, codePointAtIndexNode, getAttrNode, setItemNode, setAttrNode);
                }
            }
            catch (PException iterException) {
                iterException.expectStopIteration(inliningTarget, isStopIterationProfile);
            }
        }
    }

    private static void writeAttribute(VirtualFrame frame, Node inliningTarget, Object globals, TruffleString name, Object value, PyObjectSetItem setItemNode, PyObjectSetAttr setAttrNode) {
        if (globals instanceof PDict || globals instanceof PMappingproxy) {
            setItemNode.execute((Frame)frame, inliningTarget, globals, name, value);
        } else {
            setAttrNode.execute((Frame)frame, inliningTarget, globals, name, value);
        }
    }

    private void writeAttributeToLocals(VirtualFrame frame, Node inliningTarget, TruffleString moduleName, PythonModule importedModule, Object locals, Object attrName, boolean fromAll, CastToTruffleStringNode castToTruffleStringNode, TruffleString.CodePointLengthNode cpLenNode, TruffleString.CodePointAtIndexNode cpAtIndexNode, PyObjectGetAttr getAttr, PyObjectSetItem dictWriteNode, PyObjectSetAttr setAttrNode) {
        try {
            TruffleString name = castToTruffleStringNode.execute(inliningTarget, attrName);
            if (fromAll || !ImportStarNode.startsWithUnderscore(name, cpLenNode, cpAtIndexNode)) {
                Object moduleAttr = getAttr.execute((Frame)frame, inliningTarget, importedModule, name);
                ImportStarNode.writeAttribute(frame, inliningTarget, locals, name, moduleAttr, dictWriteNode, setAttrNode);
            }
        }
        catch (CannotCastException cce) {
            throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, fromAll ? ErrorMessages.ITEM_IN_S_MUST_BE_STRING : ErrorMessages.KEY_IN_S_MUST_BE_STRING, moduleName, fromAll ? SpecialAttributeNames.T___ALL__ : SpecialAttributeNames.T___DICT__, attrName);
        }
    }

    private static boolean startsWithUnderscore(TruffleString s, TruffleString.CodePointLengthNode cpLenNode, TruffleString.CodePointAtIndexNode cpAtIndexNode) {
        return cpLenNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING) > 0 && cpAtIndexNode.execute((AbstractTruffleString)s, 0, PythonUtils.TS_ENCODING) == 95;
    }

    public static ImportStarNode create() {
        return ImportStarNodeGen.create();
    }

    public static ImportStarNode getUncached() {
        return ImportStarNodeGen.getUncached();
    }
}

