/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TupleConversionNodeGen;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public abstract class TupleConversionNode
extends ArgumentCastNode {
    @Specialization
    static Object[] doNone(PNone none) {
        return PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @Specialization
    static Object[] doTuple(PTuple t, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalArrayNode) {
        return getInternalArrayNode.execute(inliningTarget, t.getSequenceStorage());
    }

    @Fallback
    static Object doOthers(Object value, @Cached PRaiseNode raiseNode) {
        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, value, "a tuple", value);
    }

    @ClinicConverterFactory
    @NeverDefault
    public static TupleConversionNode create() {
        return TupleConversionNodeGen.create();
    }
}

