/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.WritableBufferConversionNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

public abstract class WritableBufferConversionNode
extends ArgumentCastNode {
    private final String builtinName;

    public WritableBufferConversionNode(String builtinName) {
        this.builtinName = builtinName;
    }

    @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
    Object doObject(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="value") PythonBufferAcquireLibrary acquireLib, @Cached PRaiseNode.Lazy raiseNode) {
        try {
            return acquireLib.acquireWritable(value, frame, this.getContext(), this.getLanguage(), indirectCallData);
        }
        catch (PException e) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_READ_WRITE_BYTES_LIKE_NOT_P, this.builtinName, value);
        }
    }

    @ClinicConverterFactory
    @NeverDefault
    public static WritableBufferConversionNode create(@ClinicConverterFactory.BuiltinName String builtinName) {
        return WritableBufferConversionNodeGen.create(builtinName);
    }
}

