/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonContextFactory;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;

public abstract class ExceptionStateNodes {

    public static final class GetCaughtExceptionNode
    extends Node {
        @Node.Child
        private PythonContext.GetThreadStateNode getThreadStateNode;
        private final ConditionProfile nullFrameProfile = ConditionProfile.create();
        private final ConditionProfile hasExceptionProfile = ConditionProfile.create();
        private final ConditionProfile needsStackWalkProfile = ConditionProfile.create();

        public AbstractTruffleException execute(VirtualFrame frame) {
            if (this.nullFrameProfile.profile(frame == null)) {
                return this.getFromContext();
            }
            AbstractTruffleException e = PArguments.getException((Frame)frame);
            if (this.needsStackWalkProfile.profile(e == null)) {
                e = GetCaughtExceptionNode.fromStackWalk();
                if (e == null) {
                    e = PException.NO_EXCEPTION;
                }
                PArguments.setException((Frame)frame, e);
            }
            return this.ensure(e);
        }

        public AbstractTruffleException executeFromNative() {
            return this.getFromContext();
        }

        private AbstractTruffleException getFromContext() {
            PythonContext.PythonThreadState threadState;
            AbstractTruffleException fromContext;
            if (this.getThreadStateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getThreadStateNode = (PythonContext.GetThreadStateNode)this.insert(PythonContextFactory.GetThreadStateNodeGen.create());
            }
            if (this.needsStackWalkProfile.profile((fromContext = (threadState = this.getThreadStateNode.executeCached()).getCaughtException()) == null)) {
                fromContext = GetCaughtExceptionNode.fromStackWalk();
                threadState.setCaughtException(fromContext != null ? fromContext : PException.NO_EXCEPTION);
            }
            return this.ensure(fromContext);
        }

        private static AbstractTruffleException fromStackWalk() {
            return GetCaughtExceptionNode.fullStackWalk();
        }

        @CompilerDirectives.TruffleBoundary
        public static AbstractTruffleException fullStackWalk() {
            return (AbstractTruffleException)((Object)Truffle.getRuntime().iterateFrames(frameInstance -> {
                RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
                RootNode rootNode = target.getRootNode();
                Node callNode = frameInstance.getCallNode();
                IndirectCallData.setEncapsulatingNeedsToPassExceptionState(callNode);
                if (rootNode instanceof PRootNode) {
                    PRootNode pRootNode = (PRootNode)rootNode;
                    pRootNode.setNeedsExceptionState();
                    Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                    return PArguments.getException(frame);
                }
                return null;
            }));
        }

        private AbstractTruffleException ensure(AbstractTruffleException e) {
            if (this.hasExceptionProfile.profile(e == PException.NO_EXCEPTION)) {
                return null;
            }
            return e;
        }

        @NeverDefault
        public static GetCaughtExceptionNode create() {
            return new GetCaughtExceptionNode();
        }
    }
}

