/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.scope;

import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class ScopeEnvironment {
    private static final String GLOBAL_PARAM = "name '%s' is parameter and global";
    private static final String NONLOCAL_PARAM = "name '%s' is parameter and nonlocal";
    private static final String GLOBAL_AFTER_ASSIGN = "name '%s' is assigned to before global declaration";
    private static final String NONLOCAL_AFTER_ASSIGN = "name '%s' is assigned to before nonlocal declaration";
    private static final String GLOBAL_AFTER_USE = "name '%s' is used prior to global declaration";
    private static final String NONLOCAL_AFTER_USE = "name '%s' is used prior to nonlocal declaration";
    private static final String GLOBAL_ANNOT = "annotated name '%s' can't be global";
    private static final String NONLOCAL_ANNOT = "annotated name '%s' can't be nonlocal";
    private static final String IMPORT_STAR_WARNING = "import * only allowed at module level";
    private static final String NAMED_EXPR_COMP_IN_CLASS = "assignment expression within a comprehension cannot be used in a class body";
    private static final String NAMED_EXPR_COMP_CONFLICT = "assignment expression cannot rebind comprehension iteration variable '%s'";
    private static final String NAMED_EXPR_COMP_INNER_LOOP_CONFLICT = "comprehension inner loop cannot rebind assignment expression target '%s'";
    private static final String NAMED_EXPR_COMP_ITER_EXPR = "assignment expression cannot be used in a comprehension iterable expression";
    private static final String DUPLICATE_ARGUMENT = "duplicate argument '%s' in function definition";
    final Scope topScope;
    final HashMap<SSTNode, Scope> blocks = new HashMap();
    final ErrorCallback errorCallback;
    final EnumSet<FutureFeature> futureFeatures;

    public static ScopeEnvironment analyze(ModTy moduleNode, ErrorCallback errorCallback, EnumSet<FutureFeature> futureFeatures) {
        return new ScopeEnvironment(moduleNode, errorCallback, futureFeatures);
    }

    private ScopeEnvironment(ModTy moduleNode, ErrorCallback errorCallback, EnumSet<FutureFeature> futureFeatures) {
        this.errorCallback = errorCallback;
        this.futureFeatures = futureFeatures;
        FirstPassVisitor visitor = new FirstPassVisitor(moduleNode, this);
        this.topScope = visitor.currentScope;
        moduleNode.accept(visitor);
        this.analyzeBlock(this.topScope, null, null, null);
    }

    public String toString() {
        return "ScopeEnvironment\n" + this.topScope.toString(1);
    }

    private void addScope(SSTNode node, Scope scope) {
        this.blocks.put(node, scope);
    }

    public Scope lookupScope(SSTNode node) {
        return this.blocks.get(node);
    }

    private void analyzeBlock(Scope scope, HashSet<String> bound, HashSet<String> free, HashSet<String> global) {
        HashSet<String> local = new HashSet<String>();
        HashMap<String, Scope.DefUse> scopes = new HashMap<String, Scope.DefUse>();
        HashSet<String> newGlobal = new HashSet<String>();
        HashSet<String> newFree = new HashSet<String>();
        HashSet<String> newBound = new HashSet<String>();
        if (scope.type == Scope.ScopeType.Class) {
            if (global != null) {
                newGlobal.addAll(global);
            }
            if (bound != null) {
                newBound.addAll(bound);
            }
        }
        for (Map.Entry<String, EnumSet<Scope.DefUse>> e : scope.symbols.entrySet()) {
            this.analyzeName(scope, scopes, e.getKey(), e.getValue(), bound, local, free, global);
        }
        if (scope.type != Scope.ScopeType.Class) {
            if (scope.type == Scope.ScopeType.Function) {
                newBound.addAll(local);
            }
            if (bound != null) {
                newBound.addAll(bound);
            }
            if (global != null) {
                newGlobal.addAll(global);
            }
        } else {
            newBound.add("__class__");
        }
        HashSet<String> allFree = new HashSet<String>();
        for (Scope s : scope.children) {
            HashSet<String> tempBound = new HashSet<String>(newBound);
            HashSet<String> tempFree = new HashSet<String>(newFree);
            HashSet<String> tempGlobal = new HashSet<String>(newGlobal);
            this.analyzeBlock(s, tempBound, tempFree, tempGlobal);
            allFree.addAll(tempFree);
            if (!s.flags.contains((Object)Scope.ScopeFlags.HasFreeVars) && !s.flags.contains((Object)Scope.ScopeFlags.HasChildWithFreeVars)) continue;
            scope.flags.add(Scope.ScopeFlags.HasChildWithFreeVars);
        }
        newFree.addAll(allFree);
        switch (scope.type) {
            case Function: {
                ScopeEnvironment.analyzeCells(scopes, newFree);
                break;
            }
            case Class: {
                ScopeEnvironment.dropClassFree(scope, newFree);
                break;
            }
        }
        ScopeEnvironment.updateSymbols(scope.symbols, scopes, bound, newFree, scope.type == Scope.ScopeType.Class);
        if (free != null) {
            free.addAll(newFree);
        }
    }

    private void analyzeName(Scope scope, HashMap<String, Scope.DefUse> scopes, String name, EnumSet<Scope.DefUse> flags, HashSet<String> bound, HashSet<String> local, HashSet<String> free, HashSet<String> global) {
        if (flags.contains((Object)Scope.DefUse.DefGlobal)) {
            if (flags.contains((Object)Scope.DefUse.DefNonLocal)) {
                this.errorCallback.onError(ErrorCallback.ErrorType.Syntax, scope.getDirective(name), "name '%s' is nonlocal and global", name);
            }
            scopes.put(name, Scope.DefUse.GlobalExplicit);
            if (global != null) {
                global.add(name);
            }
            if (bound != null) {
                bound.remove(name);
            }
        } else if (flags.contains((Object)Scope.DefUse.DefNonLocal)) {
            if (bound == null) {
                this.errorCallback.onError(ErrorCallback.ErrorType.Syntax, scope.getDirective(name), "nonlocal declaration not allowed at module level");
            } else if (!bound.contains(name)) {
                this.errorCallback.onError(ErrorCallback.ErrorType.Syntax, scope.getDirective(name), "no binding for nonlocal '%s' found", name);
            }
            scopes.put(name, Scope.DefUse.Free);
            scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            if (free != null) {
                free.add(name);
            }
        } else if (!Collections.disjoint(flags, Scope.DefUse.DefBound)) {
            scopes.put(name, Scope.DefUse.Local);
            local.add(name);
            if (global != null) {
                global.remove(name);
            }
        } else if (bound != null && bound.contains(name)) {
            scopes.put(name, Scope.DefUse.Free);
            scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            free.add(name);
        } else if (global != null && global.contains(name)) {
            scopes.put(name, Scope.DefUse.GlobalImplicit);
        } else {
            if (scope.flags.contains((Object)Scope.ScopeFlags.IsNested)) {
                scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            }
            scopes.put(name, Scope.DefUse.GlobalImplicit);
        }
    }

    private static void analyzeCells(HashMap<String, Scope.DefUse> scopes, HashSet<String> free) {
        for (Map.Entry<String, Scope.DefUse> e : scopes.entrySet()) {
            String name;
            if (e.getValue() != Scope.DefUse.Local || !free.contains(name = e.getKey())) continue;
            scopes.put(name, Scope.DefUse.Cell);
            free.remove(name);
        }
    }

    private static void dropClassFree(Scope scope, HashSet<String> free) {
        if (free.remove("__class__")) {
            scope.flags.add(Scope.ScopeFlags.NeedsClassClosure);
        }
    }

    private static void updateSymbols(HashMap<String, EnumSet<Scope.DefUse>> symbols, HashMap<String, Scope.DefUse> scopes, HashSet<String> bound, HashSet<String> free, boolean isClass) {
        for (Map.Entry<String, EnumSet<Scope.DefUse>> e : symbols.entrySet()) {
            String name = e.getKey();
            Scope.DefUse vScope = scopes.get(name);
            assert (!vScope.toString().startsWith("Def"));
            e.getValue().add(vScope);
        }
        for (String name : free) {
            EnumSet<Scope.DefUse> v = symbols.get(name);
            if (v != null) {
                if (!isClass || !v.contains((Object)Scope.DefUse.DefGlobal) && Collections.disjoint(v, Scope.DefUse.DefBound)) continue;
                v.add(Scope.DefUse.DefFreeClass);
                continue;
            }
            if (bound != null && !bound.contains(name)) continue;
            symbols.put(name, EnumSet.of(Scope.DefUse.Free));
        }
    }

    public static String mangle(String className, String name) {
        if (className == null || !name.startsWith("__")) {
            return name;
        }
        if (name.endsWith("__") || name.contains(".")) {
            return name;
        }
        int offset = 0;
        while (className.charAt(offset) == '_') {
            if (++offset < className.length()) continue;
            return name;
        }
        return "_" + className.substring(offset) + name;
    }

    private static final class FirstPassVisitor
    implements SSTreeVisitor<Void> {
        private final Stack<Scope> stack = new Stack();
        private final HashMap<String, EnumSet<Scope.DefUse>> globals;
        private final ScopeEnvironment env;
        private Scope currentScope;
        private String currentClassName;

        private FirstPassVisitor(ModTy moduleNode, ScopeEnvironment env) {
            this.env = env;
            this.enterBlock(null, Scope.ScopeType.Module, moduleNode);
            this.globals = this.currentScope.symbols;
        }

        private void enterBlock(String name, Scope.ScopeType type, SSTNode ast) {
            Scope scope = new Scope(name, type, ast);
            this.env.addScope(ast, scope);
            this.stack.add(scope);
            Scope prev = this.currentScope;
            if (prev != null) {
                scope.comprehensionIterExpression = prev.comprehensionIterExpression;
                if (prev.type == Scope.ScopeType.Function || prev.isNested()) {
                    scope.flags.add(Scope.ScopeFlags.IsNested);
                }
            }
            this.currentScope = scope;
            if (type == Scope.ScopeType.Annotation) {
                return;
            }
            if (prev != null) {
                prev.children.add(scope);
            }
        }

        private void exitBlock() {
            this.stack.pop();
            this.currentScope = this.stack.peek();
        }

        private String mangle(String name) {
            return ScopeEnvironment.mangle(this.currentClassName, name);
        }

        private void addDef(String name, Scope.DefUse flag, SSTNode node) {
            this.addDef(name, flag, this.currentScope, node);
        }

        private void addDef(String name, Scope.DefUse flag, Scope scope, SSTNode node) {
            String mangled = this.mangle(name);
            EnumSet<Scope.DefUse> flags = scope.getUseOfName(mangled);
            if (flags != null) {
                if (flag == Scope.DefUse.DefParam && flags.contains((Object)Scope.DefUse.DefParam)) {
                    this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.DUPLICATE_ARGUMENT, mangled);
                }
                flags.add(flag);
            } else {
                flags = EnumSet.of(flag);
            }
            if (scope.flags.contains((Object)Scope.ScopeFlags.IsVisitingIterTarget)) {
                if (flags.contains((Object)Scope.DefUse.DefGlobal) || flags.contains((Object)Scope.DefUse.DefNonLocal)) {
                    this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_INNER_LOOP_CONFLICT, mangled);
                }
                flags.add(Scope.DefUse.DefCompIter);
            }
            scope.symbols.put(mangled, flags);
            switch (flag) {
                case DefParam: {
                    if (scope.varnames.contains(mangled)) {
                        this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.DUPLICATE_ARGUMENT, mangled);
                    }
                    scope.varnames.add(mangled);
                    break;
                }
                case DefGlobal: {
                    EnumSet<Scope.DefUse> globalFlags = this.globals.get(mangled);
                    if (globalFlags != null) {
                        globalFlags.add(flag);
                    } else {
                        globalFlags = EnumSet.of(flag);
                    }
                    this.globals.put(mangled, globalFlags);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleComprehension(ExprTy e, String scopeName, ComprehensionTy[] generators, ExprTy element, ExprTy value, Scope.ComprehensionType comprehensionType) {
            boolean isAsync;
            boolean isGenerator = e instanceof ExprTy.GeneratorExp;
            ComprehensionTy outermost = generators[0];
            ++this.currentScope.comprehensionIterExpression;
            outermost.iter.accept(this);
            --this.currentScope.comprehensionIterExpression;
            this.enterBlock(scopeName, Scope.ScopeType.Function, e);
            try {
                this.currentScope.comprehensionType = comprehensionType;
                if (outermost.isAsync) {
                    this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
                }
                this.currentScope.flags.add(Scope.ScopeFlags.IsComprehension);
                this.addDef(".0", Scope.DefUse.DefParam, value);
                this.currentScope.flags.add(Scope.ScopeFlags.IsVisitingIterTarget);
                outermost.target.accept(this);
                this.currentScope.flags.remove((Object)Scope.ScopeFlags.IsVisitingIterTarget);
                this.visitSequence(outermost.ifs);
                for (int i = 1; i < generators.length; ++i) {
                    generators[i].accept(this);
                }
                if (value != null) {
                    value.accept(this);
                }
                element.accept(this);
                if (isGenerator) {
                    this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
                }
                isAsync = this.currentScope.isCoroutine() && !isGenerator;
            }
            finally {
                this.exitBlock();
            }
            if (isAsync) {
                this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            }
        }

        private void raiseIfComprehensionBlock(ExprTy node) {
            this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), switch (this.currentScope.comprehensionType) {
                case Scope.ComprehensionType.ListComprehension -> "'yield' inside list comprehension";
                case Scope.ComprehensionType.SetComprehension -> "'yield' inside set comprehension";
                case Scope.ComprehensionType.DictComprehension -> "'yield' inside dict comprehension";
                default -> "'yield' inside generator expression";
            });
        }

        private void raiseIfAnnotationBlock(String name, ExprTy node) {
            if (this.currentScope.type == Scope.ScopeType.Annotation) {
                this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), "'%s' can not be used within an annotation", name);
            }
        }

        private void visitAnnotation(ExprTy expr) {
            boolean futureAnnotations = this.env.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS);
            if (futureAnnotations) {
                this.enterBlock("_annotation", Scope.ScopeType.Annotation, expr);
            }
            try {
                expr.accept(this);
            }
            finally {
                if (futureAnnotations) {
                    this.exitBlock();
                }
            }
        }

        private void visitAnnotations(ArgTy[] args) {
            if (args != null) {
                for (ArgTy arg : args) {
                    if (arg.annotation == null) continue;
                    arg.annotation.accept(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitAnnotations(StmtTy node, ArgumentsTy args, ExprTy returns) {
            boolean futureAnnotations = this.env.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS);
            if (args != null) {
                if (futureAnnotations) {
                    this.enterBlock("_annotation", Scope.ScopeType.Annotation, node);
                }
                try {
                    this.visitAnnotations(args.posOnlyArgs);
                    this.visitAnnotations(args.args);
                    if (args.varArg != null && args.varArg.annotation != null) {
                        args.varArg.annotation.accept(this);
                    }
                    if (args.kwArg != null && args.kwArg.annotation != null) {
                        args.kwArg.annotation.accept(this);
                    }
                    this.visitAnnotations(args.kwOnlyArgs);
                }
                finally {
                    if (futureAnnotations) {
                        this.exitBlock();
                    }
                }
            }
            if (returns != null) {
                this.visitAnnotation(returns);
            }
        }

        @Override
        public Void visit(AliasTy node) {
            String importedName = node.asName == null ? node.name : node.asName;
            int dotIndex = importedName.indexOf(46);
            if (dotIndex >= 0) {
                importedName = importedName.substring(0, dotIndex);
            }
            if ("*".equals(importedName)) {
                if (!this.currentScope.isModule()) {
                    this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.IMPORT_STAR_WARNING);
                }
            } else {
                this.addDef(importedName, Scope.DefUse.DefImport, node);
            }
            return null;
        }

        @Override
        public Void visit(ArgTy node) {
            this.addDef(node.arg, Scope.DefUse.DefParam, node);
            return null;
        }

        @Override
        public Void visit(ArgumentsTy node) {
            this.visitSequence(node.posOnlyArgs);
            this.visitSequence(node.args);
            this.visitSequence(node.kwOnlyArgs);
            if (node.varArg != null) {
                node.varArg.accept(this);
                this.currentScope.flags.add(Scope.ScopeFlags.HasVarArgs);
            }
            if (node.kwArg != null) {
                node.kwArg.accept(this);
                this.currentScope.flags.add(Scope.ScopeFlags.HasVarKeywords);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.Attribute node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Await node) {
            this.raiseIfAnnotationBlock("await expression", node);
            node.value.accept(this);
            this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            return null;
        }

        @Override
        public Void visit(ExprTy.BinOp node) {
            node.left.accept(this);
            node.right.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.BoolOp node) {
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.Call node) {
            node.func.accept(this);
            this.visitSequence(node.args);
            this.visitSequence(node.keywords);
            return null;
        }

        @Override
        public Void visit(ExprTy.Compare node) {
            node.left.accept(this);
            this.visitSequence(node.comparators);
            return null;
        }

        @Override
        public Void visit(ExprTy.Constant node) {
            return null;
        }

        @Override
        public Void visit(ExprTy.Dict node) {
            this.visitSequence(node.keys);
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.DictComp node) {
            this.handleComprehension(node, "dictcomp", node.generators, node.key, node.value, Scope.ComprehensionType.DictComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.FormattedValue node) {
            node.value.accept(this);
            if (node.formatSpec != null) {
                node.formatSpec.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.GeneratorExp node) {
            this.handleComprehension(node, "genexp", node.generators, node.element, null, Scope.ComprehensionType.GeneratorExpression);
            return null;
        }

        @Override
        public Void visit(ExprTy.IfExp node) {
            node.test.accept(this);
            node.body.accept(this);
            node.orElse.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.JoinedStr node) {
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.Lambda node) {
            if (node.args != null) {
                this.visitSequence(node.args.defaults);
                this.visitSequence(node.args.kwDefaults);
            }
            this.enterBlock("lambda", Scope.ScopeType.Function, node);
            try {
                if (node.args != null) {
                    node.args.accept(this);
                }
                node.body.accept(this);
            }
            finally {
                this.exitBlock();
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.List node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.ListComp node) {
            this.handleComprehension(node, "listcomp", node.generators, node.element, null, Scope.ComprehensionType.ListComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.Name node) {
            this.addDef(node.id, node.context == ExprContextTy.Load ? Scope.DefUse.Use : Scope.DefUse.DefLocal, node);
            if (node.context == ExprContextTy.Load && this.currentScope.type == Scope.ScopeType.Function && node.id.equals("super")) {
                this.addDef("__class__", Scope.DefUse.Use, node);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.NamedExpr node) {
            this.raiseIfAnnotationBlock("named expression", node);
            if (this.currentScope.comprehensionIterExpression > 0) {
                this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_ITER_EXPR);
            }
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                String targetName = ((ExprTy.Name)node.target).id;
                for (int i = this.stack.size() - 1; i >= 0; --i) {
                    Scope s = (Scope)this.stack.get(i);
                    if (s.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                        if (!s.getUseOfName(targetName).contains((Object)Scope.DefUse.DefCompIter)) continue;
                        this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_CONFLICT);
                        continue;
                    }
                    if (s.type == Scope.ScopeType.Function) {
                        EnumSet<Scope.DefUse> uses = s.getUseOfName(targetName);
                        if (uses.contains((Object)Scope.DefUse.DefGlobal)) {
                            this.addDef(targetName, Scope.DefUse.DefGlobal, node);
                        } else {
                            this.addDef(targetName, Scope.DefUse.DefNonLocal, node);
                        }
                        this.currentScope.recordDirective(this.mangle(targetName), node.getSourceRange());
                        this.addDef(targetName, Scope.DefUse.DefLocal, s, node);
                        break;
                    }
                    if (s.type == Scope.ScopeType.Module) {
                        this.addDef(targetName, Scope.DefUse.DefGlobal, node);
                        this.currentScope.recordDirective(this.mangle(targetName), node.getSourceRange());
                        this.addDef(targetName, Scope.DefUse.DefGlobal, s, node);
                        break;
                    }
                    if (s.type != Scope.ScopeType.Class) continue;
                    this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_IN_CLASS);
                }
            }
            node.value.accept(this);
            node.target.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Set node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.SetComp node) {
            this.handleComprehension(node, "setcomp", node.generators, node.element, null, Scope.ComprehensionType.SetComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.Slice node) {
            if (node.lower != null) {
                node.lower.accept(this);
            }
            if (node.upper != null) {
                node.upper.accept(this);
            }
            if (node.step != null) {
                node.step.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.Starred node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Subscript node) {
            node.value.accept(this);
            node.slice.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Tuple node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.UnaryOp node) {
            node.operand.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Yield node) {
            this.raiseIfAnnotationBlock("yield expression", node);
            if (node.value != null) {
                node.value.accept(this);
            }
            this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                this.raiseIfComprehensionBlock(node);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.YieldFrom node) {
            this.raiseIfAnnotationBlock("yield expression", node);
            if (node.value != null) {
                node.value.accept(this);
            }
            this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                this.raiseIfComprehensionBlock(node);
            }
            return null;
        }

        @Override
        public Void visit(KeywordTy node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ModTy.Expression node) {
            node.body.accept(this);
            return null;
        }

        @Override
        public Void visit(ModTy.FunctionType node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void visit(ModTy.Interactive node) {
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(ModTy.Module node) {
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(TypeIgnoreTy.TypeIgnore node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void visit(StmtTy.AnnAssign node) {
            if (node.target instanceof ExprTy.Name) {
                ExprTy.Name name = (ExprTy.Name)node.target;
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(this.mangle(name.id));
                if (cur != null && (cur.contains((Object)Scope.DefUse.DefGlobal) || cur.contains((Object)Scope.DefUse.DefNonLocal)) && this.currentScope.symbols != this.globals && node.isSimple) {
                    String msg = cur.contains((Object)Scope.DefUse.DefGlobal) ? ScopeEnvironment.GLOBAL_ANNOT : ScopeEnvironment.NONLOCAL_ANNOT;
                    this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), msg, name.id);
                    return null;
                }
                if (node.isSimple) {
                    this.addDef(name.id, Scope.DefUse.DefAnnot, node);
                    this.addDef(name.id, Scope.DefUse.DefLocal, node);
                } else if (node.value != null) {
                    this.addDef(name.id, Scope.DefUse.DefLocal, node);
                }
            } else {
                node.target.accept(this);
            }
            this.visitAnnotation(node.annotation);
            if (node.value != null) {
                node.value.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Assert node) {
            node.test.accept(this);
            if (node.msg != null) {
                node.msg.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Assign node) {
            this.visitSequence(node.targets);
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncFor node) {
            node.target.accept(this);
            node.iter.accept(this);
            this.visitSequence(node.body);
            if (node.orElse != null) {
                this.visitSequence(node.orElse);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncFunctionDef node) {
            this.addDef(node.name, Scope.DefUse.DefLocal, node);
            if (node.args != null) {
                this.visitSequence(node.args.defaults);
                this.visitSequence(node.args.kwDefaults);
            }
            this.visitAnnotations(node, node.args, node.returns);
            this.visitSequence(node.decoratorList);
            this.enterBlock(node.name, Scope.ScopeType.Function, node);
            try {
                this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
                if (node.args != null) {
                    node.args.accept(this);
                }
                this.visitSequence(node.body);
            }
            finally {
                this.exitBlock();
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncWith node) {
            this.visitSequence(node.items);
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(StmtTy.AugAssign node) {
            node.target.accept(this);
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.ClassDef node) {
            this.addDef(node.name, Scope.DefUse.DefLocal, node);
            this.visitSequence(node.bases);
            this.visitSequence(node.keywords);
            this.visitSequence(node.decoratorList);
            String tmp = this.currentClassName;
            this.enterBlock(node.name, Scope.ScopeType.Class, node);
            try {
                this.currentClassName = node.name;
                this.visitSequence(node.body);
            }
            finally {
                this.currentClassName = tmp;
                this.exitBlock();
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Delete node) {
            this.visitSequence(node.targets);
            return null;
        }

        @Override
        public Void visit(StmtTy.Expr node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.For node) {
            node.target.accept(this);
            node.iter.accept(this);
            this.visitSequence(node.body);
            if (node.orElse != null) {
                this.visitSequence(node.orElse);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.FunctionDef node) {
            this.addDef(node.name, Scope.DefUse.DefLocal, node);
            if (node.args != null) {
                this.visitSequence(node.args.defaults);
                this.visitSequence(node.args.kwDefaults);
            }
            this.visitAnnotations(node, node.args, node.returns);
            this.visitSequence(node.decoratorList);
            this.enterBlock(node.name, Scope.ScopeType.Function, node);
            try {
                if (node.args != null) {
                    node.args.accept(this);
                }
                this.visitSequence(node.body);
            }
            finally {
                this.exitBlock();
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Global node) {
            for (String n : node.names) {
                String mangled = this.mangle(n);
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(mangled);
                if (cur != null) {
                    String msg = null;
                    if (cur.contains((Object)Scope.DefUse.DefParam)) {
                        msg = ScopeEnvironment.GLOBAL_PARAM;
                    } else if (cur.contains((Object)Scope.DefUse.Use)) {
                        msg = ScopeEnvironment.GLOBAL_AFTER_USE;
                    } else if (cur.contains((Object)Scope.DefUse.DefAnnot)) {
                        msg = ScopeEnvironment.GLOBAL_ANNOT;
                    } else if (cur.contains((Object)Scope.DefUse.DefLocal)) {
                        msg = ScopeEnvironment.GLOBAL_AFTER_ASSIGN;
                    }
                    if (msg != null) {
                        this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), msg, n);
                        continue;
                    }
                }
                this.addDef(n, Scope.DefUse.DefGlobal, node);
                this.currentScope.recordDirective(mangled, node.getSourceRange());
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.If node) {
            node.test.accept(this);
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            return null;
        }

        @Override
        public Void visit(StmtTy.Import node) {
            this.visitSequence(node.names);
            return null;
        }

        @Override
        public Void visit(StmtTy.ImportFrom node) {
            this.visitSequence(node.names);
            return null;
        }

        @Override
        public Void visit(StmtTy.Match node) {
            node.subject.accept(this);
            this.visitSequence(node.cases);
            return null;
        }

        @Override
        public Void visit(MatchCaseTy node) {
            node.pattern.accept(this);
            if (node.guard != null) {
                node.guard.accept(this);
            }
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchAs node) {
            if (node.pattern != null) {
                node.pattern.accept(this);
            }
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchClass node) {
            node.cls.accept(this);
            this.visitSequence(node.patterns);
            this.visitSequence(node.kwdPatterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchMapping node) {
            this.visitSequence(node.keys);
            this.visitSequence(node.patterns);
            if (node.rest != null) {
                this.addDef(node.rest, Scope.DefUse.DefLocal, node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchOr node) {
            this.visitSequence(node.patterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchSequence node) {
            this.visitSequence(node.patterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchSingleton node) {
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchStar node) {
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchValue node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.Nonlocal node) {
            for (String n : node.names) {
                String mangled = this.mangle(n);
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(n);
                if (cur != null) {
                    String msg = null;
                    if (cur.contains((Object)Scope.DefUse.DefParam)) {
                        msg = ScopeEnvironment.NONLOCAL_PARAM;
                    } else if (cur.contains((Object)Scope.DefUse.Use)) {
                        msg = ScopeEnvironment.NONLOCAL_AFTER_USE;
                    } else if (cur.contains((Object)Scope.DefUse.DefAnnot)) {
                        msg = ScopeEnvironment.NONLOCAL_ANNOT;
                    } else if (cur.contains((Object)Scope.DefUse.DefLocal)) {
                        msg = ScopeEnvironment.NONLOCAL_AFTER_ASSIGN;
                    }
                    if (msg != null) {
                        this.env.errorCallback.onError(ErrorCallback.ErrorType.Syntax, node.getSourceRange(), msg, n);
                        continue;
                    }
                }
                this.addDef(n, Scope.DefUse.DefNonLocal, node);
                this.currentScope.recordDirective(mangled, node.getSourceRange());
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Raise node) {
            if (node.exc != null) {
                node.exc.accept(this);
                if (node.cause != null) {
                    node.cause.accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Return node) {
            if (node.value != null) {
                node.value.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Try node) {
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            this.visitSequence(node.handlers);
            this.visitSequence(node.finalBody);
            return null;
        }

        @Override
        public Void visit(StmtTy.TryStar node) {
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            this.visitSequence(node.handlers);
            this.visitSequence(node.finalBody);
            return null;
        }

        @Override
        public Void visit(ExceptHandlerTy.ExceptHandler node) {
            if (node.type != null) {
                node.type.accept(this);
            }
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, node);
            }
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(StmtTy.While node) {
            node.test.accept(this);
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            return null;
        }

        @Override
        public Void visit(StmtTy.With node) {
            this.visitSequence(node.items);
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(WithItemTy node) {
            node.contextExpr.accept(this);
            if (node.optionalVars != null) {
                node.optionalVars.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ComprehensionTy node) {
            this.currentScope.flags.add(Scope.ScopeFlags.IsVisitingIterTarget);
            node.target.accept(this);
            this.currentScope.flags.remove((Object)Scope.ScopeFlags.IsVisitingIterTarget);
            ++this.currentScope.comprehensionIterExpression;
            node.iter.accept(this);
            --this.currentScope.comprehensionIterExpression;
            this.visitSequence(node.ifs);
            if (node.isAsync) {
                this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Break aThis) {
            return null;
        }

        @Override
        public Void visit(StmtTy.Continue aThis) {
            return null;
        }

        @Override
        public Void visit(StmtTy.Pass aThis) {
            return null;
        }
    }
}

