/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.arrow;

import com.oracle.graal.python.nodes.arrow.vector.VectorArrowArrayReleaseCallback;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.arrow.ArrowUtil;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public class ArrowVectorSupport {
    private final String FIXED_WIDTH_VECTOR_PATH = "org.apache.arrow.vector.BaseFixedWidthVector";
    public final boolean isJavaArrowImplOnClassPath;
    public final Class<?> baseFixedWidthVectorClass;
    private final PythonContext ctx;
    private Object vectorArrowArrayNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long vectorArrowArrayReleaseCallback;

    public ArrowVectorSupport(PythonContext ctx) {
        Class<?> baseFixedWidthVectorClass;
        this.ctx = ctx;
        try {
            baseFixedWidthVectorClass = Class.forName("org.apache.arrow.vector.BaseFixedWidthVector");
        }
        catch (ClassNotFoundException e) {
            baseFixedWidthVectorClass = null;
        }
        this.baseFixedWidthVectorClass = baseFixedWidthVectorClass;
        this.isJavaArrowImplOnClassPath = baseFixedWidthVectorClass != null;
    }

    public boolean isFixedWidthVector(Object vector) {
        if (!this.isJavaArrowImplOnClassPath) {
            return false;
        }
        TruffleLanguage.Env env = this.ctx.getEnv();
        if (env.isHostObject(vector)) {
            Object hostVector = env.asHostObject(vector);
            return this.baseFixedWidthVectorClass.isInstance(hostVector);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private void initVectorArrowArrayReleaseCallback() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(UINT64):VOID", this.ctx);
        VectorArrowArrayReleaseCallback executable = new VectorArrowArrayReleaseCallback();
        this.vectorArrowArrayNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.vectorArrowArrayReleaseCallback = PythonUtils.coerceToLong(this.vectorArrowArrayNFIClosure, InteropLibrary.getUncached());
    }

    public long getVectorArrowArrayReleaseCallback() {
        if (this.vectorArrowArrayReleaseCallback == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initVectorArrowArrayReleaseCallback();
        }
        return this.vectorArrowArrayReleaseCallback;
    }
}

