/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public final class InitIDVisitor
extends DepthFirstTraversalRegexASTVisitor {
    public static final int REGEX_AST_ROOT_PARENT_ID = 0;
    private final RegexAST ast;
    private final RegexASTNode[] index;
    private int nextID;

    private InitIDVisitor(RegexAST ast, RegexASTNode[] index, int nextID) {
        this.ast = ast;
        this.index = index;
        this.nextID = nextID;
    }

    public static void init(RegexAST ast) {
        int initialID = 3 + ast.getWrappedPrefixLength() * 2;
        InitIDVisitor visitor = new InitIDVisitor(ast, new RegexASTNode[initialID + ast.getNumberOfNodes() + 1], initialID);
        assert (ast.getWrappedRoot().getSubTreeParent().getId() == 0);
        visitor.index[0] = ast.getWrappedRoot().getSubTreeParent();
        visitor.run(ast.getWrappedRoot());
        ast.setIndex(visitor.index);
    }

    private void initID(RegexASTNode node) {
        assert (!node.idInitialized());
        node.setId(this.nextID++);
        this.index[node.getId()] = node;
    }

    @Override
    protected void visit(BackReference backReference) {
        this.initID(backReference);
    }

    @Override
    protected void visit(Group group) {
        if (group.getParent() instanceof RegexASTSubtreeRootNode) {
            this.initID(group.getSubTreeParent().getAnchoredInitialState());
            this.initID(group.getSubTreeParent().getUnAnchoredInitialState());
        }
        this.initID(group);
    }

    @Override
    protected void leave(Group group) {
        if (group.getParent() instanceof RegexASTSubtreeRootNode) {
            this.initID(group.getSubTreeParent().getAnchoredFinalState());
            this.initID(group.getSubTreeParent().getMatchFound());
            this.initID(group.getSubTreeParent().getMatchFoundChecked());
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        this.initID(sequence);
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        this.initID(assertion);
        if (!assertion.isDead()) {
            switch (assertion.type) {
                case CARET: {
                    this.ast.getReachableCarets().add(assertion);
                    break;
                }
                case DOLLAR: {
                    this.ast.getReachableDollars().add(assertion);
                }
            }
        }
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        this.initID(assertion);
    }

    @Override
    protected void leave(LookBehindAssertion assertion) {
        this.leaveSubtreeRootNode(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        this.initID(assertion);
    }

    @Override
    protected void leave(LookAheadAssertion assertion) {
        this.leaveSubtreeRootNode(assertion);
    }

    @Override
    protected void visit(AtomicGroup atomicGroup) {
        this.initID(atomicGroup);
    }

    @Override
    protected void leave(AtomicGroup atomicGroup) {
        this.leaveSubtreeRootNode(atomicGroup);
    }

    private void leaveSubtreeRootNode(RegexASTSubtreeRootNode subtree) {
        if (!subtree.isDead()) {
            this.ast.getSubtrees().add(subtree);
            subtree.getSubTreeParent().getSubtrees().add(subtree);
        }
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        this.initID(characterClass);
    }

    @Override
    protected void visit(SubexpressionCall subexpressionCall) {
        throw CompilerDirectives.shouldNotReachHere((String)"subexpression calls should be expanded by the parser");
    }
}

