/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

public final class Value {
    final Object receiver;
    final AbstractPolyglotImpl.AbstractValueImpl impl;

    Value(AbstractPolyglotImpl.AbstractValueImpl impl, Object value) {
        this.impl = impl;
        this.receiver = value;
    }

    public Value getMetaObject() {
        return this.impl.getMetaObject(this.receiver);
    }

    public boolean isMetaObject() {
        return this.impl.isMetaObject(this.receiver);
    }

    public String getMetaQualifiedName() {
        return this.impl.getMetaQualifiedName(this.receiver);
    }

    public String getMetaSimpleName() {
        return this.impl.getMetaSimpleName(this.receiver);
    }

    public boolean isMetaInstance(Object instance) {
        return this.impl.isMetaInstance(this.receiver, instance);
    }

    public boolean hasArrayElements() {
        return this.impl.hasArrayElements(this.receiver);
    }

    public Value getArrayElement(long index) {
        return this.impl.getArrayElement(this.receiver, index);
    }

    public void setArrayElement(long index, Object value) {
        this.impl.setArrayElement(this.receiver, index, value);
    }

    public boolean removeArrayElement(long index) {
        return this.impl.removeArrayElement(this.receiver, index);
    }

    public long getArraySize() {
        return this.impl.getArraySize(this.receiver);
    }

    public boolean hasBufferElements() {
        return this.impl.hasBufferElements(this.receiver);
    }

    public boolean isBufferWritable() throws UnsupportedOperationException {
        return this.impl.isBufferWritable(this.receiver);
    }

    public long getBufferSize() throws UnsupportedOperationException {
        return this.impl.getBufferSize(this.receiver);
    }

    public byte readBufferByte(long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferByte(this.receiver, byteOffset);
    }

    public void writeBufferByte(long byteOffset, byte value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferByte(this.receiver, byteOffset, value);
    }

    public short readBufferShort(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferShort(this.receiver, order, byteOffset);
    }

    public void writeBufferShort(ByteOrder order, long byteOffset, short value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferShort(this.receiver, order, byteOffset, value);
    }

    public int readBufferInt(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferInt(this.receiver, order, byteOffset);
    }

    public void writeBufferInt(ByteOrder order, long byteOffset, int value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferInt(this.receiver, order, byteOffset, value);
    }

    public long readBufferLong(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferLong(this.receiver, order, byteOffset);
    }

    public void writeBufferLong(ByteOrder order, long byteOffset, long value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferLong(this.receiver, order, byteOffset, value);
    }

    public float readBufferFloat(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferFloat(this.receiver, order, byteOffset);
    }

    public void writeBufferFloat(ByteOrder order, long byteOffset, float value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferFloat(this.receiver, order, byteOffset, value);
    }

    public double readBufferDouble(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.impl.readBufferDouble(this.receiver, order, byteOffset);
    }

    public void writeBufferDouble(ByteOrder order, long byteOffset, double value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.impl.writeBufferDouble(this.receiver, order, byteOffset, value);
    }

    public boolean hasMembers() {
        return this.impl.hasMembers(this.receiver);
    }

    public boolean hasMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.impl.hasMember(this.receiver, identifier);
    }

    public Value getMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.impl.getMember(this.receiver, identifier);
    }

    public Set<String> getMemberKeys() {
        return this.impl.getMemberKeys(this.receiver);
    }

    public void putMember(String identifier, Object value) {
        Objects.requireNonNull(identifier, "identifier");
        this.impl.putMember(this.receiver, identifier, value);
    }

    public boolean removeMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.impl.removeMember(this.receiver, identifier);
    }

    public boolean canExecute() {
        return this.impl.canExecute(this.receiver);
    }

    public Value execute(Object ... arguments) {
        if (arguments.length == 0) {
            return this.impl.execute(this.receiver);
        }
        return this.impl.execute(this.receiver, arguments);
    }

    public void executeVoid(Object ... arguments) {
        if (arguments.length == 0) {
            this.impl.executeVoid(this.receiver);
        } else {
            this.impl.executeVoid(this.receiver, arguments);
        }
    }

    public boolean canInstantiate() {
        return this.impl.canInstantiate(this.receiver);
    }

    public Value newInstance(Object ... arguments) {
        Objects.requireNonNull(arguments, "arguments");
        return this.impl.newInstance(this.receiver, arguments);
    }

    public boolean canInvokeMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.impl.canInvoke(identifier, this.receiver);
    }

    public Value invokeMember(String identifier, Object ... arguments) {
        Objects.requireNonNull(identifier, "identifier");
        if (arguments.length == 0) {
            return this.impl.invoke(this.receiver, identifier);
        }
        return this.impl.invoke(this.receiver, identifier, arguments);
    }

    public boolean isString() {
        return this.impl.isString(this.receiver);
    }

    public String asString() {
        return this.impl.asString(this.receiver);
    }

    public boolean fitsInInt() {
        return this.impl.fitsInInt(this.receiver);
    }

    public int asInt() {
        return this.impl.asInt(this.receiver);
    }

    public boolean isBoolean() {
        return this.impl.isBoolean(this.receiver);
    }

    public boolean asBoolean() {
        return this.impl.asBoolean(this.receiver);
    }

    public boolean isNumber() {
        return this.impl.isNumber(this.receiver);
    }

    public boolean fitsInLong() {
        return this.impl.fitsInLong(this.receiver);
    }

    public long asLong() {
        return this.impl.asLong(this.receiver);
    }

    public boolean fitsInDouble() {
        return this.impl.fitsInDouble(this.receiver);
    }

    public double asDouble() {
        return this.impl.asDouble(this.receiver);
    }

    public boolean fitsInFloat() {
        return this.impl.fitsInFloat(this.receiver);
    }

    public float asFloat() {
        return this.impl.asFloat(this.receiver);
    }

    public boolean fitsInByte() {
        return this.impl.fitsInByte(this.receiver);
    }

    public byte asByte() {
        return this.impl.asByte(this.receiver);
    }

    public boolean fitsInShort() {
        return this.impl.fitsInShort(this.receiver);
    }

    public short asShort() {
        return this.impl.asShort(this.receiver);
    }

    public boolean isNull() {
        return this.impl.isNull(this.receiver);
    }

    public boolean isNativePointer() {
        return this.impl.isNativePointer(this.receiver);
    }

    public long asNativePointer() {
        return this.impl.asNativePointer(this.receiver);
    }

    public boolean isHostObject() {
        return this.impl.isHostObject(this.receiver);
    }

    public <T> T asHostObject() {
        return (T)this.impl.asHostObject(this.receiver);
    }

    public boolean isProxyObject() {
        return this.impl.isProxyObject(this.receiver);
    }

    public <T extends Proxy> T asProxyObject() {
        return (T)((Proxy)this.impl.asProxyObject(this.receiver));
    }

    public <T> T as(Class<T> targetType) throws ClassCastException, IllegalStateException, PolyglotException {
        Objects.requireNonNull(targetType, "targetType");
        if (targetType == Value.class) {
            return (T)this;
        }
        return this.impl.as(this.receiver, targetType);
    }

    public <T> T as(TypeLiteral<T> targetType) {
        Objects.requireNonNull(targetType, "targetType");
        return this.impl.as(this.receiver, targetType);
    }

    public String toString() {
        return this.impl.toString(this.receiver);
    }

    public SourceSection getSourceLocation() {
        return this.impl.getSourceLocation(this.receiver);
    }

    public boolean isDate() {
        return this.impl.isDate(this.receiver);
    }

    public LocalDate asDate() {
        return this.impl.asDate(this.receiver);
    }

    public boolean isTime() {
        return this.impl.isTime(this.receiver);
    }

    public LocalTime asTime() {
        return this.impl.asTime(this.receiver);
    }

    public boolean isInstant() {
        return this.isDate() && this.isTime() && this.isTimeZone();
    }

    public Instant asInstant() {
        return this.impl.asInstant(this.receiver);
    }

    public boolean isTimeZone() {
        return this.impl.isTimeZone(this.receiver);
    }

    public ZoneId asTimeZone() {
        return this.impl.asTimeZone(this.receiver);
    }

    public boolean isDuration() {
        return this.impl.isDuration(this.receiver);
    }

    public Duration asDuration() {
        return this.impl.asDuration(this.receiver);
    }

    public boolean isException() {
        return this.impl.isException(this.receiver);
    }

    public RuntimeException throwException() {
        return this.impl.throwException(this.receiver);
    }

    public Context getContext() {
        return this.impl.getContext();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Value)) {
            return false;
        }
        return this.impl.equalsImpl(this.receiver, ((Value)obj).receiver);
    }

    public int hashCode() {
        return this.impl.hashCodeImpl(this.receiver);
    }

    public boolean hasIterator() {
        return this.impl.hasIterator(this.receiver);
    }

    public Value getIterator() {
        return this.impl.getIterator(this.receiver);
    }

    public boolean isIterator() {
        return this.impl.isIterator(this.receiver);
    }

    public boolean hasIteratorNextElement() {
        return this.impl.hasIteratorNextElement(this.receiver);
    }

    public Value getIteratorNextElement() {
        return this.impl.getIteratorNextElement(this.receiver);
    }

    public boolean hasHashEntries() {
        return this.impl.hasHashEntries(this.receiver);
    }

    public long getHashSize() throws UnsupportedOperationException {
        return this.impl.getHashSize(this.receiver);
    }

    public boolean hasHashEntry(Object key) {
        return this.impl.hasHashEntry(this.receiver, key);
    }

    public Value getHashValue(Object key) throws UnsupportedOperationException {
        return this.impl.getHashValue(this.receiver, key);
    }

    public Value getHashValueOrDefault(Object key, Object defaultValue) throws UnsupportedOperationException {
        return this.impl.getHashValueOrDefault(this.receiver, key, defaultValue);
    }

    public void putHashEntry(Object key, Object value) throws IllegalArgumentException, UnsupportedOperationException {
        this.impl.putHashEntry(this.receiver, key, value);
    }

    public boolean removeHashEntry(Object key) throws UnsupportedOperationException {
        return this.impl.removeHashEntry(this.receiver, key);
    }

    public Value getHashEntriesIterator() throws UnsupportedOperationException {
        return this.impl.getHashEntriesIterator(this.receiver);
    }

    public Value getHashKeysIterator() throws UnsupportedOperationException {
        return this.impl.getHashKeysIterator(this.receiver);
    }

    public Value getHashValuesIterator() throws UnsupportedOperationException {
        return this.impl.getHashValuesIterator(this.receiver);
    }

    public static Value asValue(Object o) {
        if (o instanceof Value) {
            return (Value)o;
        }
        return Engine.getImpl().asValue(o);
    }
}

