/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.engine.FetchTiming;
import org.hibernate.query.results.Builders;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderEmbeddable
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final EmbeddableValuedFetchable fetchable;
    private final Map<NavigablePath, FetchBuilder> fetchBuilders;

    public ImplicitFetchBuilderEmbeddable(NavigablePath fetchPath, EmbeddableValuedFetchable fetchable, DomainResultCreationState creationState) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        NavigablePath relativePath = creationStateImpl.getCurrentRelativePath();
        Function<String, FetchBuilder> fetchBuilderResolver = creationStateImpl.getCurrentExplicitFetchMementoResolver();
        LinkedHashMap<NavigablePath, FetchBuilder> fetchBuilders = new LinkedHashMap<NavigablePath, FetchBuilder>(fetchable.getNumberOfFetchables());
        fetchable.visitFetchables(subFetchable -> {
            NavigablePath subFetchPath = relativePath.append(subFetchable.getFetchableName());
            FetchBuilder explicitFetchBuilder = (FetchBuilder)fetchBuilderResolver.apply(subFetchPath.getFullPath());
            if (explicitFetchBuilder == null) {
                fetchBuilders.put(subFetchPath, Builders.implicitFetchBuilder(fetchPath, subFetchable, creationStateImpl));
            } else {
                fetchBuilders.put(subFetchPath, explicitFetchBuilder);
            }
        }, null);
        this.fetchBuilders = fetchBuilders;
    }

    private ImplicitFetchBuilderEmbeddable(ImplicitFetchBuilderEmbeddable original) {
        Map<NavigablePath, FetchBuilder> fetchBuilders;
        this.fetchPath = original.fetchPath;
        this.fetchable = original.fetchable;
        if (original.fetchBuilders.isEmpty()) {
            fetchBuilders = Collections.emptyMap();
        } else {
            fetchBuilders = new HashMap(original.fetchBuilders.size());
            for (Map.Entry<NavigablePath, FetchBuilder> entry : original.fetchBuilders.entrySet()) {
                fetchBuilders.put(entry.getKey(), entry.getValue().cacheKeyInstance());
            }
        }
        this.fetchBuilders = fetchBuilders;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new ImplicitFetchBuilderEmbeddable(this);
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState creationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().resolveTableGroup(fetchPath, navigablePath -> {
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.fetchable.createTableGroupJoin(fetchPath, parentTableGroup, null, SqlAstJoinType.INNER, true, false, creationStateImpl);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        Fetch fetch = parent.generateFetchableFetch(this.fetchable, fetchPath, FetchTiming.IMMEDIATE, true, null, creationState);
        return fetch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderEmbeddable that = (ImplicitFetchBuilderEmbeddable)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable) && this.fetchBuilders.equals(that.fetchBuilders);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        result = 31 * result + this.fetchBuilders.hashCode();
        return result;
    }

    public String toString() {
        return "ImplicitFetchBuilderEmbeddable(" + this.fetchPath + ")";
    }

    @Override
    public void visitFetchBuilders(BiConsumer<String, FetchBuilder> consumer) {
        this.fetchBuilders.forEach((k, v) -> consumer.accept(k.getLocalName(), (FetchBuilder)v));
    }
}

