/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.AbstractSqmStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public abstract class AbstractSqmDmlStatement<E>
extends AbstractSqmStatement<E>
implements SqmDmlStatement<E> {
    private final Map<String, SqmCteStatement<?>> cteStatements;
    private boolean withRecursiveCte;
    private SqmRoot<E> target;

    public AbstractSqmDmlStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(querySource, nodeBuilder);
        this.cteStatements = new LinkedHashMap();
    }

    public AbstractSqmDmlStatement(SqmRoot<E> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        this(querySource, nodeBuilder);
        this.target = target;
    }

    public AbstractSqmDmlStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, boolean withRecursiveCte, SqmRoot<E> target) {
        super(builder, querySource, parameters);
        this.cteStatements = cteStatements;
        this.withRecursiveCte = withRecursiveCte;
        this.target = target;
    }

    protected Map<String, SqmCteStatement<?>> copyCteStatements(SqmCopyContext context) {
        LinkedHashMap cteStatements = new LinkedHashMap(this.cteStatements.size());
        for (Map.Entry<String, SqmCteStatement<?>> entry : this.cteStatements.entrySet()) {
            cteStatements.put(entry.getKey(), (SqmCteStatement<?>)entry.getValue().copy(context));
        }
        return cteStatements;
    }

    @Override
    public boolean isWithRecursive() {
        return this.withRecursiveCte;
    }

    @Override
    public void setWithRecursive(boolean withRecursiveCte) {
        this.withRecursiveCte = withRecursiveCte;
    }

    @Override
    public Collection<SqmCteStatement<?>> getCteStatements() {
        return this.cteStatements.values();
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public void addCteStatement(SqmCteStatement<?> cteStatement) {
        if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getCteName(), cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists!");
        }
    }

    @Override
    public SqmRoot<E> getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(SqmRoot<E> root) {
        this.target = root;
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }
}

