
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for UnsavedValueCompositeIdEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="UnsavedValueCompositeIdEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="any"/>
 *     <enumeration value="none"/>
 *     <enumeration value="undefined"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "UnsavedValueCompositeIdEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmUnsavedValueCompositeIdEnum {

    @XmlEnumValue("any")
    ANY("any"),
    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("undefined")
    UNDEFINED("undefined");
    private final String value;

    JaxbHbmUnsavedValueCompositeIdEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmUnsavedValueCompositeIdEnum fromValue(String v) {
        for (JaxbHbmUnsavedValueCompositeIdEnum c: JaxbHbmUnsavedValueCompositeIdEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
