
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for UnsavedValueTimestampEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="UnsavedValueTimestampEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="null"/>
 *     <enumeration value="undefined"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "UnsavedValueTimestampEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmUnsavedValueTimestampEnum {

    @XmlEnumValue("null")
    NULL("null"),
    @XmlEnumValue("undefined")
    UNDEFINED("undefined");
    private final String value;

    JaxbHbmUnsavedValueTimestampEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmUnsavedValueTimestampEnum fromValue(String v) {
        for (JaxbHbmUnsavedValueTimestampEnum c: JaxbHbmUnsavedValueTimestampEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
