
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.InheritanceType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *                 See `@jakarta.persistence.Inheritance`
 *             
 * 
 * <p>Java class for inheritance complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="inheritance">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="strategy" type="{http://www.hibernate.org/xsd/orm/mapping}inheritance-type" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "inheritance", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbInheritance
    implements Serializable
{

    @XmlAttribute(name = "strategy")
    @XmlJavaTypeAdapter(Adapter10 .class)
    protected InheritanceType strategy;

    /**
     * Gets the value of the strategy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public InheritanceType getStrategy() {
        return strategy;
    }

    /**
     * Sets the value of the strategy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStrategy(InheritanceType value) {
        this.strategy = value;
    }

}
