
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 The resultset element declares a named resultset mapping definition for SQL queries
 *             
 * 
 * <p>Java class for ResultSetMappingType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ResultSetMappingType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice maxOccurs="unbounded" minOccurs="0">
 *         <group ref="{http://www.hibernate.org/xsd/orm/hbm}NativeQueryReturnGroup"/>
 *       </choice>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResultSetMappingType", namespace = "http://www.hibernate.org/xsd/orm/hbm", propOrder = {
    "valueMappingSources"
})
public class JaxbHbmResultSetMappingType
    implements Serializable, ResultSetMappingBindingDefinition
{

    @XmlElements({
        @XmlElement(name = "return-scalar", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmNativeQueryScalarReturnType.class),
        @XmlElement(name = "return", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmNativeQueryReturnType.class),
        @XmlElement(name = "return-join", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmNativeQueryJoinReturnType.class),
        @XmlElement(name = "load-collection", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmNativeQueryCollectionLoadReturnType.class)
    })
    protected List<Serializable> valueMappingSources;
    @XmlAttribute(name = "name", required = true)
    protected String name;

    /**
     * Gets the value of the valueMappingSources property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the valueMappingSources property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValueMappingSources().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmNativeQueryCollectionLoadReturnType }
     * {@link JaxbHbmNativeQueryJoinReturnType }
     * {@link JaxbHbmNativeQueryReturnType }
     * {@link JaxbHbmNativeQueryScalarReturnType }
     * 
     * 
     * @return
     *     The value of the valueMappingSources property.
     */
    public List<Serializable> getValueMappingSources() {
        if (valueMappingSources == null) {
            valueMappingSources = new ArrayList<>();
        }
        return this.valueMappingSources;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

}
