
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TimestampSourceEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TimestampSourceEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="db"/>
 *     <enumeration value="vm"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TimestampSourceEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmTimestampSourceEnum {

    @XmlEnumValue("db")
    DB("db"),
    @XmlEnumValue("vm")
    VM("vm");
    private final String value;

    JaxbHbmTimestampSourceEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmTimestampSourceEnum fromValue(String v) {
        for (JaxbHbmTimestampSourceEnum c: JaxbHbmTimestampSourceEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
