/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.dialect;

import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BooleanJdbcType;

public class OracleBooleanJdbcType extends BooleanJdbcType {

	public static final OracleBooleanJdbcType INSTANCE = new OracleBooleanJdbcType();

	@Override
	public String getCheckCondition(String columnName, JavaType<?> javaType, Dialect dialect) {
		return columnName + " in (0,1)";
	}
}
