
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.ordering;

/**
 * Grammar for parsing order-by fragments.
 *
 * @implNote While we could re-use the HQL lexer/parser for order fragment parsing, both the HQL lexer and parser
 * are way "heavier" than needed here.  So we use a simplified lexer and parser that defione just what is needed
 * to parse the order fragment
 */

import org.antlr.v4.runtime.tree.ParseTreeListener;

/**
 * This interface defines a complete listener for a parse tree produced by
 * {@link OrderingParser}.
 */
public interface OrderingParserListener extends ParseTreeListener {
	/**
	 * Enter a parse tree produced by {@link OrderingParser#orderByFragment}.
	 * @param ctx the parse tree
	 */
	void enterOrderByFragment(OrderingParser.OrderByFragmentContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#orderByFragment}.
	 * @param ctx the parse tree
	 */
	void exitOrderByFragment(OrderingParser.OrderByFragmentContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#sortSpecification}.
	 * @param ctx the parse tree
	 */
	void enterSortSpecification(OrderingParser.SortSpecificationContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#sortSpecification}.
	 * @param ctx the parse tree
	 */
	void exitSortSpecification(OrderingParser.SortSpecificationContext ctx);
	/**
	 * Enter a parse tree produced by the {@code FunctionExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void enterFunctionExpression(OrderingParser.FunctionExpressionContext ctx);
	/**
	 * Exit a parse tree produced by the {@code FunctionExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void exitFunctionExpression(OrderingParser.FunctionExpressionContext ctx);
	/**
	 * Enter a parse tree produced by the {@code IdentifierExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void enterIdentifierExpression(OrderingParser.IdentifierExpressionContext ctx);
	/**
	 * Exit a parse tree produced by the {@code IdentifierExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void exitIdentifierExpression(OrderingParser.IdentifierExpressionContext ctx);
	/**
	 * Enter a parse tree produced by the {@code DotIdentifierExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void enterDotIdentifierExpression(OrderingParser.DotIdentifierExpressionContext ctx);
	/**
	 * Exit a parse tree produced by the {@code DotIdentifierExpression}
	 * labeled alternative in {@link OrderingParser#expression}.
	 * @param ctx the parse tree
	 */
	void exitDotIdentifierExpression(OrderingParser.DotIdentifierExpressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#function}.
	 * @param ctx the parse tree
	 */
	void enterFunction(OrderingParser.FunctionContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#function}.
	 * @param ctx the parse tree
	 */
	void exitFunction(OrderingParser.FunctionContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#simpleFunction}.
	 * @param ctx the parse tree
	 */
	void enterSimpleFunction(OrderingParser.SimpleFunctionContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#simpleFunction}.
	 * @param ctx the parse tree
	 */
	void exitSimpleFunction(OrderingParser.SimpleFunctionContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#packagedFunction}.
	 * @param ctx the parse tree
	 */
	void enterPackagedFunction(OrderingParser.PackagedFunctionContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#packagedFunction}.
	 * @param ctx the parse tree
	 */
	void exitPackagedFunction(OrderingParser.PackagedFunctionContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#functionArguments}.
	 * @param ctx the parse tree
	 */
	void enterFunctionArguments(OrderingParser.FunctionArgumentsContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#functionArguments}.
	 * @param ctx the parse tree
	 */
	void exitFunctionArguments(OrderingParser.FunctionArgumentsContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#functionArgument}.
	 * @param ctx the parse tree
	 */
	void enterFunctionArgument(OrderingParser.FunctionArgumentContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#functionArgument}.
	 * @param ctx the parse tree
	 */
	void exitFunctionArgument(OrderingParser.FunctionArgumentContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#literal}.
	 * @param ctx the parse tree
	 */
	void enterLiteral(OrderingParser.LiteralContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#literal}.
	 * @param ctx the parse tree
	 */
	void exitLiteral(OrderingParser.LiteralContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#collationSpecification}.
	 * @param ctx the parse tree
	 */
	void enterCollationSpecification(OrderingParser.CollationSpecificationContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#collationSpecification}.
	 * @param ctx the parse tree
	 */
	void exitCollationSpecification(OrderingParser.CollationSpecificationContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#direction}.
	 * @param ctx the parse tree
	 */
	void enterDirection(OrderingParser.DirectionContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#direction}.
	 * @param ctx the parse tree
	 */
	void exitDirection(OrderingParser.DirectionContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 */
	void enterNullsPrecedence(OrderingParser.NullsPrecedenceContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 */
	void exitNullsPrecedence(OrderingParser.NullsPrecedenceContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#identifier}.
	 * @param ctx the parse tree
	 */
	void enterIdentifier(OrderingParser.IdentifierContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#identifier}.
	 * @param ctx the parse tree
	 */
	void exitIdentifier(OrderingParser.IdentifierContext ctx);
	/**
	 * Enter a parse tree produced by {@link OrderingParser#dotIdentifier}.
	 * @param ctx the parse tree
	 */
	void enterDotIdentifier(OrderingParser.DotIdentifierContext ctx);
	/**
	 * Exit a parse tree produced by {@link OrderingParser#dotIdentifier}.
	 * @param ctx the parse tree
	 */
	void exitDotIdentifier(OrderingParser.DotIdentifierContext ctx);
}
