/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultRefreshEventListener.class);

    @Override
    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, RefreshContext.create());
    }

    @Override
    public void onRefresh(RefreshEvent event, RefreshContext refreshedAlready) {
        Object object;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        if (persistenceContext.reassociateIfUninitializedProxy(object = event.getObject())) {
            if (DefaultRefreshEventListener.isTransient(event, source, object)) {
                source.setReadOnly(object, source.isDefaultReadOnly());
            }
        } else {
            Object entity = persistenceContext.unproxyAndReassociate(object);
            if (refreshedAlready.add(entity)) {
                DefaultRefreshEventListener.refresh(event, refreshedAlready, entity);
            } else {
                LOG.trace("Already refreshed");
            }
        }
    }

    private static boolean isTransient(RefreshEvent event, EventSource source, Object object) {
        String entityName = event.getEntityName();
        return entityName != null ? !source.contains(entityName, object) : !source.contains(object);
    }

    private static void refresh(RefreshEvent event, RefreshContext refreshedAlready, Object object) {
        EntityKey key;
        Object id;
        EntityPersister persister;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(object);
        if (entry == null) {
            persister = source.getEntityPersister(event.getEntityName(), object);
            id = persister.getIdentifier(object, event.getSession());
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(persister, id, source.getFactory()));
            }
            if (persistenceContext.getEntry(key = source.generateEntityKey(id, persister)) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", MessageHelper.infoString(entry.getPersister(), entry.getId(), source.getFactory()));
            }
            if (!entry.isExistsInDatabase()) {
                throw new UnresolvableObjectException(entry.getId(), "this instance does not yet exist as a row in the database");
            }
            persister = entry.getPersister();
            id = entry.getId();
        }
        Cascade.cascade(CascadingActions.REFRESH, CascadePoint.BEFORE_REFRESH, source, persister, object, refreshedAlready);
        if (entry != null) {
            key = source.generateEntityKey(id, persister);
            persistenceContext.removeEntity(key);
            if (persister.hasCollections()) {
                new EvictVisitor(source, object).process(object, persister);
            }
        }
        DefaultRefreshEventListener.evictEntity(object, persister, id, source);
        DefaultRefreshEventListener.evictCachedCollections(persister, id, source);
        Object result = source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.REFRESH, () -> DefaultRefreshEventListener.doRefresh(event, source, object, entry, persister, id, persistenceContext));
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    private static void evictEntity(Object object, EntityPersister persister, Object id, EventSource source) {
        if (persister.canWriteToCache()) {
            Object previousVersion = null;
            if (persister.isVersionPropertyGenerated()) {
                previousVersion = persister.getVersion(object);
            }
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, source.getFactory(), source.getTenantIdentifier());
            SoftLock lock = cache.lockItem(source, ck, previousVersion);
            cache.remove(source, ck);
            source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
        }
    }

    private static Object doRefresh(RefreshEvent event, EventSource source, Object object, EntityEntry entry, EntityPersister persister, Object id, PersistenceContext persistenceContext) {
        Object result;
        LockMode currentLockMode;
        LockOptions lockOptionsToUse = event.getLockOptions();
        LockMode requestedLockMode = lockOptionsToUse.getLockMode();
        LockMode postRefreshLockMode = null;
        if (entry != null && (currentLockMode = entry.getLockMode()).greaterThan(requestedLockMode)) {
            lockOptionsToUse = event.getLockOptions().makeCopy();
            if (currentLockMode == LockMode.WRITE || currentLockMode == LockMode.PESSIMISTIC_WRITE || currentLockMode == LockMode.PESSIMISTIC_READ) {
                lockOptionsToUse.setLockMode(LockMode.READ);
                postRefreshLockMode = currentLockMode;
            } else {
                lockOptionsToUse.setLockMode(currentLockMode);
            }
        }
        if ((result = persister.load(id, object, lockOptionsToUse, (SharedSessionContractImplementor)source)) != null) {
            if (postRefreshLockMode != null) {
                persistenceContext.getEntry(result).setLockMode(postRefreshLockMode);
            }
            if (!persister.isMutable()) {
                source.setReadOnly(result, true);
            } else {
                source.setReadOnly(result, entry == null ? source.isDefaultReadOnly() : entry.isReadOnly());
            }
        }
        return result;
    }

    private static void evictCachedCollections(EntityPersister persister, Object id, EventSource source) {
        DefaultRefreshEventListener.evictCachedCollections(persister.getPropertyTypes(), id, source);
    }

    private static void evictCachedCollections(Type[] types, Object id, EventSource source) throws HibernateException {
        ActionQueue actionQueue = source.getActionQueue();
        SessionFactoryImplementor factory = source.getFactory();
        MappingMetamodelImplementor metamodel = factory.getRuntimeMetamodels().getMappingMetamodel();
        for (Type type : types) {
            if (type.isCollectionType()) {
                String role = ((CollectionType)type).getRole();
                CollectionPersister collectionPersister = metamodel.getCollectionDescriptor(role);
                if (!collectionPersister.hasCache()) continue;
                CollectionDataAccess cache = collectionPersister.getCacheAccessStrategy();
                Object ck = cache.generateCacheKey(id, collectionPersister, factory, source.getTenantIdentifier());
                SoftLock lock = cache.lockItem(source, ck, null);
                cache.remove(source, ck);
                actionQueue.registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
                continue;
            }
            if (!type.isComponentType()) continue;
            CompositeType compositeType = (CompositeType)type;
            DefaultRefreshEventListener.evictCachedCollections(compositeType.getSubtypes(), id, source);
        }
    }
}

