/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.criteria.JpaWindow;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.criteria.spi.CriteriaBuilderExtension;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCoalesce;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmModifiedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.SqmWindow;
import org.hibernate.query.sqm.tree.expression.SqmWindowFrame;
import org.hibernate.query.sqm.tree.expression.ValueBindJpaCriteriaParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmCriteriaNodeBuilder
implements NodeBuilder,
SqmCreationContext,
Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SqmCriteriaNodeBuilder.class);
    private final String uuid;
    private final String name;
    private final transient boolean jpaComplianceEnabled;
    private final transient QueryEngine queryEngine;
    private final transient ServiceRegistry serviceRegistry;
    private final transient Supplier<SessionFactoryImplementor> sessionFactory;
    private final transient ValueHandlingMode criteriaValueHandlingMode;
    private transient BasicType<Boolean> booleanType;
    private transient BasicType<Integer> integerType;
    private transient BasicType<Character> characterType;
    private final transient Map<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder> extensions;

    public SqmCriteriaNodeBuilder(String uuid, String name, QueryEngine queryEngine, boolean jpaComplianceEnabled, ValueHandlingMode criteriaValueHandlingMode, ServiceRegistry serviceRegistry, Supplier<SessionFactoryImplementor> sessionFactory) {
        this.serviceRegistry = serviceRegistry;
        this.sessionFactory = sessionFactory;
        this.queryEngine = queryEngine;
        this.uuid = uuid;
        this.name = name;
        this.jpaComplianceEnabled = jpaComplianceEnabled;
        this.criteriaValueHandlingMode = criteriaValueHandlingMode;
        this.extensions = new HashMap<Class<? extends HibernateCriteriaBuilder>, HibernateCriteriaBuilder>();
        for (CriteriaBuilderExtension extension : ServiceLoader.load(CriteriaBuilderExtension.class)) {
            HibernateCriteriaBuilder builder = extension.extend(this);
            this.extensions.put(extension.getRegistrationKey(), builder);
        }
    }

    @Override
    public JpaMetamodel getDomainModel() {
        return this.getSessionFactory().getJpaMetamodel();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.queryEngine.getTypeConfiguration();
    }

    @Override
    public boolean isJpaQueryComplianceEnabled() {
        return this.jpaComplianceEnabled;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory.get();
    }

    public static boolean areTypesComparable(SqmExpressible<?> lhsType, SqmExpressible<?> rhsType) {
        JavaType<?> rhsJavaType;
        if (lhsType == null || rhsType == null || lhsType == rhsType || SqmCriteriaNodeBuilder.isDiscriminatorComparison(lhsType, rhsType) || lhsType instanceof EmbeddedSqmPathSource && rhsType instanceof TupleType || rhsType instanceof EmbeddedSqmPathSource && lhsType instanceof TupleType || lhsType instanceof MultiValueParameterType || rhsType instanceof MultiValueParameterType) {
            return true;
        }
        JavaType<?> lhsJavaType = lhsType.getExpressibleJavaType();
        return lhsJavaType == (rhsJavaType = rhsType.getExpressibleJavaType()) || JavaTypeHelper.isUnknown(lhsJavaType) || JavaTypeHelper.isUnknown(rhsJavaType) || JavaTypeHelper.isTemporal(lhsJavaType) && JavaTypeHelper.isTemporal(rhsJavaType) || lhsJavaType.isWider(rhsJavaType) || rhsJavaType.isWider(lhsJavaType) || lhsJavaType.getJavaTypeClass().isAssignableFrom(rhsJavaType.getJavaTypeClass()) || rhsJavaType.getJavaTypeClass().isAssignableFrom(lhsJavaType.getJavaTypeClass());
    }

    private static boolean isDiscriminatorComparison(SqmExpressible<?> lhsType, SqmExpressible<?> rhsType) {
        SqmExpressible<?> nonDiscriminator;
        if (lhsType instanceof DiscriminatorSqmPathSource) {
            nonDiscriminator = rhsType;
        } else if (rhsType instanceof DiscriminatorSqmPathSource) {
            nonDiscriminator = lhsType;
        } else {
            return false;
        }
        if (nonDiscriminator instanceof EntityType) {
            return true;
        }
        JavaType<?> nonDiscriminatorJavaType = nonDiscriminator.getExpressibleJavaType();
        switch (nonDiscriminatorJavaType.getJavaTypeClass().getTypeName()) {
            case "java.lang.String": 
            case "char": 
            case "java.lang.Character": 
            case "int": 
            case "java.lang.Integer": {
                return true;
            }
        }
        return false;
    }

    @Override
    public BasicType<Boolean> getBooleanType() {
        BasicType<Boolean> booleanType = this.booleanType;
        if (booleanType == null) {
            this.booleanType = this.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
            return this.booleanType;
        }
        return booleanType;
    }

    @Override
    public BasicType<Integer> getIntegerType() {
        BasicType<Integer> integerType = this.integerType;
        if (integerType == null) {
            this.integerType = this.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
            return this.integerType;
        }
        return integerType;
    }

    @Override
    public BasicType<Character> getCharacterType() {
        BasicType<Character> characterType = this.characterType;
        if (characterType == null) {
            this.characterType = this.getTypeConfiguration().getBasicTypeForJavaType(Character.class);
            return this.characterType;
        }
        return characterType;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.getSessionFactory().getJpaMetamodel();
    }

    public void close() {
    }

    @Override
    public SqmSelectStatement<Object> createQuery() {
        return new SqmSelectStatement<Object>(Object.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmSelectStatement<T> createQuery(Class<T> resultClass) {
        return new SqmSelectStatement<T>(resultClass, (NodeBuilder)this);
    }

    @Override
    public SqmSelectStatement<Tuple> createTupleQuery() {
        return new SqmSelectStatement<Tuple>(Tuple.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmUpdateStatement<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new SqmUpdateStatement<T>(targetEntity, this);
    }

    @Override
    public <T> SqmDeleteStatement<T> createCriteriaDelete(Class<T> targetEntity) {
        return new SqmDeleteStatement<T>(targetEntity, SqmQuerySource.CRITERIA, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInsertSelectStatement<T> createCriteriaInsertSelect(Class<T> targetEntity) {
        return new SqmInsertSelectStatement<T>(targetEntity, (NodeBuilder)this);
    }

    @Override
    public <T> JpaCriteriaQuery<T> union(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.UNION_ALL : SetOperator.UNION, query1, queries);
    }

    @Override
    public <T> JpaCriteriaQuery<T> intersect(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT, query1, queries);
    }

    @Override
    public <T> JpaCriteriaQuery<T> except(boolean all, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        return this.setOperation(all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT, query1, queries);
    }

    @Override
    public <T> JpaSubQuery<T> union(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.UNION_ALL : SetOperator.UNION, query1, queries);
    }

    @Override
    public <T> JpaSubQuery<T> intersect(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT, query1, queries);
    }

    @Override
    public <T> JpaSubQuery<T> except(boolean all, Subquery<? extends T> query1, Subquery<?> ... queries) {
        return this.setOperation(all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT, query1, queries);
    }

    private <T> JpaCriteriaQuery<T> setOperation(SetOperator operator, CriteriaQuery<? extends T> query1, CriteriaQuery<?> ... queries) {
        Class resultType = query1.getResultType();
        ArrayList<SqmQueryPart<T>> queryParts = new ArrayList<SqmQueryPart<T>>(queries.length + 1);
        LinkedHashMap cteStatements = new LinkedHashMap();
        SqmSelectStatement selectStatement1 = (SqmSelectStatement)query1;
        this.collectQueryPartsAndCtes(selectStatement1, queryParts, cteStatements);
        for (CriteriaQuery<?> query : queries) {
            if (query.getResultType() != resultType) {
                throw new IllegalArgumentException("Result type of all operands must match");
            }
            this.collectQueryPartsAndCtes((SqmSelectQuery)query, queryParts, cteStatements);
        }
        return new SqmSelectStatement<T>(new SqmQueryGroup<T>(this, operator, queryParts), resultType, cteStatements, selectStatement1.getQuerySource(), this);
    }

    private <T> JpaSubQuery<T> setOperation(SetOperator operator, Subquery<? extends T> query1, Subquery<?> ... queries) {
        Class resultType = query1.getResultType();
        SqmQuery parent = (SqmQuery)query1.getParent();
        ArrayList<SqmQueryPart<T>> queryParts = new ArrayList<SqmQueryPart<T>>(queries.length + 1);
        LinkedHashMap cteStatements = new LinkedHashMap();
        this.collectQueryPartsAndCtes((SqmSelectQuery)query1, queryParts, cteStatements);
        for (Subquery<?> query : queries) {
            if (query.getResultType() != resultType) {
                throw new IllegalArgumentException("Result type of all operands must match");
            }
            if (query.getParent() != parent) {
                throw new IllegalArgumentException("Subquery parent of all operands must match");
            }
            this.collectQueryPartsAndCtes((SqmSelectQuery)query, queryParts, cteStatements);
        }
        return new SqmSubQuery<T>(parent, new SqmQueryGroup<T>(this, operator, queryParts), resultType, cteStatements, this);
    }

    private <T> void collectQueryPartsAndCtes(SqmSelectQuery<T> query, List<SqmQueryPart<T>> queryParts, Map<String, SqmCteStatement<?>> cteStatements) {
        queryParts.add((SqmQueryPart<T>)query.getQueryPart());
        for (SqmCteStatement cteStatement : query.getCteStatements()) {
            String name = cteStatement.getCteTable().getCteName();
            SqmCteStatement old = cteStatements.put(name, cteStatement);
            if (old == null || old == cteStatement) continue;
            throw new IllegalArgumentException(String.format("Different CTE with same name [%s] found in different set operands!", name));
        }
    }

    @Override
    public <X, T> SqmExpression<X> cast(JpaExpression<T> expression, Class<X> castTargetJavaType) {
        BasicType<X> type = this.getTypeConfiguration().standardBasicTypeForJavaType(castTargetJavaType);
        return this.getFunctionDescriptor("cast").generateSqmExpression(Arrays.asList((SqmTypedNode)((Object)expression), new SqmCastTarget<X>(type, this)), type, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmPredicate wrap(Expression<Boolean> expression) {
        if (expression instanceof SqmPredicate) {
            return (SqmPredicate)expression;
        }
        return new SqmBooleanExpressionPredicate((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    @SafeVarargs
    public final SqmPredicate wrap(Expression<Boolean> ... expressions) {
        if (expressions.length == 1) {
            return this.wrap((Expression)expressions[0]);
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(expressions.length);
        for (Expression<Boolean> expression : expressions) {
            predicates.add((SqmPredicate)this.wrap((Expression)expression));
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, this);
    }

    @Override
    public <T extends HibernateCriteriaBuilder> T unwrap(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    @Override
    public <P, F> SqmExpression<F> fk(Path<P> path) {
        if (path.getModel().getBindableType() != Bindable.BindableType.SINGULAR_ATTRIBUTE) {
            throw new SemanticException("Path should refer to a to-one attribute : " + path);
        }
        if (!(path instanceof SqmEntityValuedSimplePath)) {
            throw new SemanticException("Path should refer to a to-one attribute : " + path);
        }
        return new SqmFkExpression((SqmEntityValuedSimplePath)path, (NodeBuilder)this);
    }

    @Override
    public <X, T extends X> SqmPath<T> treat(Path<X> path, Class<T> type) {
        return ((SqmPath)path).treatAs(type);
    }

    @Override
    public <X, T extends X> SqmRoot<T> treat(Root<X> root, Class<T> type) {
        return ((SqmRoot)root).treatAs(type);
    }

    @Override
    public <X, T, V extends T> SqmSingularJoin<X, V> treat(Join<X, T> join, Class<V> type) {
        return ((SqmSingularJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmBagJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return ((SqmBagJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return ((SqmSetJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return ((SqmListJoin)join).treatAs(type);
    }

    @Override
    public <X, K, T, V extends T> SqmMapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        return ((SqmMapJoin)join).treatAs(type);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression) {
        return new SqmSortSpecification((SqmExpression)sortExpression);
    }

    @Override
    public SqmSortSpecification asc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.ASCENDING);
    }

    @Override
    public SqmSortSpecification desc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.DESCENDING);
    }

    @Override
    public JpaOrder asc(Expression<?> x, boolean nullsFirst) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.ASCENDING, nullsFirst ? NullPrecedence.FIRST : NullPrecedence.LAST);
    }

    @Override
    public JpaOrder desc(Expression<?> x, boolean nullsFirst) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.DESCENDING, nullsFirst ? NullPrecedence.FIRST : NullPrecedence.LAST);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression, SortOrder sortOrder) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, sortOrder, NullPrecedence.NONE);
    }

    @Override
    public JpaSearchOrder search(JpaCteCriteriaAttribute sortExpression) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)sortExpression, SortOrder.ASCENDING, NullPrecedence.NONE);
    }

    @Override
    public JpaSearchOrder asc(JpaCteCriteriaAttribute x) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortOrder.ASCENDING, NullPrecedence.NONE);
    }

    @Override
    public JpaSearchOrder desc(JpaCteCriteriaAttribute x) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortOrder.DESCENDING, NullPrecedence.NONE);
    }

    @Override
    public JpaSearchOrder asc(JpaCteCriteriaAttribute x, boolean nullsFirst) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortOrder.ASCENDING, nullsFirst ? NullPrecedence.FIRST : NullPrecedence.LAST);
    }

    @Override
    public JpaSearchOrder desc(JpaCteCriteriaAttribute x, boolean nullsFirst) {
        return new SqmSearchClauseSpecification((SqmCteTableColumn)x, SortOrder.DESCENDING, nullsFirst ? NullPrecedence.FIRST : NullPrecedence.LAST);
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(Selection<?>[] selections) {
        return this.tuple(Arrays.asList(selections));
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(List<? extends JpaSelection<?>> selections) {
        this.checkMultiselect(selections);
        return new SqmJpaCompoundSelection<Tuple>(selections, this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Tuple.class)), this);
    }

    @Override
    public <R> SqmTuple<R> tuple(Class<R> tupleType, SqmExpression<?> ... expressions) {
        return this.tuple(tupleType, Arrays.asList(expressions));
    }

    @Override
    public <R> SqmTuple<R> tuple(Class<R> tupleType, List<? extends SqmExpression<?>> expressions) {
        TypeConfiguration typeConfiguration = this.getTypeConfiguration();
        List<? extends SqmExpression<?>> sqmExpressions = expressions;
        DomainType expressibleType = tupleType == null || tupleType == Object[].class ? (DomainType)typeConfiguration.resolveTupleType(sqmExpressions) : this.getDomainModel().embeddable(tupleType);
        return this.tuple(expressibleType, sqmExpressions);
    }

    @Override
    public <R> SqmTuple<R> tuple(SqmExpressible<R> tupleType, SqmExpression<?> ... expressions) {
        return this.tuple(tupleType, Arrays.asList(expressions));
    }

    @Override
    public <R> SqmTuple<R> tuple(SqmExpressible<R> tupleType, List<? extends SqmExpression<?>> sqmExpressions) {
        if (tupleType == null) {
            tupleType = (DomainType)this.getTypeConfiguration().resolveTupleType(sqmExpressions);
        }
        return new SqmTuple(new ArrayList(sqmExpressions), tupleType, this);
    }

    @Override
    public JpaCompoundSelection<Object[]> array(Selection<?>[] selections) {
        return this.array(Arrays.asList(selections));
    }

    @Override
    public JpaCompoundSelection<Object[]> array(List<? extends JpaSelection<?>> selections) {
        return this.array(Object[].class, selections);
    }

    @Override
    public <Y> JpaCompoundSelection<Y> array(Class<Y> resultClass, Selection<?>[] selections) {
        return this.array(resultClass, Arrays.asList(selections));
    }

    @Override
    public <Y> JpaCompoundSelection<Y> array(Class<Y> resultClass, List<? extends JpaSelection<?>> selections) {
        this.checkMultiselect(selections);
        return new SqmJpaCompoundSelection(selections, this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(resultClass), this);
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, Selection<?>[] arguments) {
        return this.construct(resultClass, Arrays.asList(arguments));
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, List<? extends JpaSelection<?>> arguments) {
        this.checkMultiselect(arguments);
        SqmDynamicInstantiation<Object> instantiation = List.class.equals(resultClass) ? SqmDynamicInstantiation.forListInstantiation(this) : (Map.class.equals(resultClass) ? SqmDynamicInstantiation.forMapInstantiation(this) : SqmDynamicInstantiation.forClassInstantiation(resultClass, (NodeBuilder)this));
        for (Selection selection : arguments) {
            instantiation.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)selection, selection.getAlias(), this));
        }
        return instantiation;
    }

    void checkMultiselect(List<? extends JpaSelection<?>> selections) {
        HashSet<String> aliases = new HashSet<String>(CollectionHelper.determineProperSizing(selections.size()));
        for (JpaSelection<?> selection : selections) {
            boolean added;
            if (selection.isCompoundSelection()) {
                if (selection.getJavaType().isArray()) {
                    throw new IllegalArgumentException("Selection items in a multi-select cannot contain compound array-valued elements");
                }
                if (Tuple.class.isAssignableFrom(selection.getJavaType())) {
                    throw new IllegalArgumentException("Selection items in a multi-select cannot contain compound tuple-valued elements");
                }
            }
            if (!StringHelper.isNotEmpty(selection.getAlias()) || (added = aliases.add(selection.getAlias()))) continue;
            throw new IllegalArgumentException("Multi-select expressions defined duplicate alias : " + selection.getAlias());
        }
    }

    @Override
    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument) {
        return this.getFunctionDescriptor("avg").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<N> argument) {
        SqmTypedNode typedNode = (SqmTypedNode)argument;
        return this.getFunctionDescriptor("sum").generateSqmExpression(typedNode, (ReturnableType)typedNode.getNodeType(), this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<Long> sumAsLong(Expression<Integer> argument) {
        return this.getFunctionDescriptor("sum").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<Double> sumAsDouble(Expression<Float> argument) {
        return this.getFunctionDescriptor("sum").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> SqmExpression<N> max(Expression<N> argument) {
        return this.getFunctionDescriptor("max").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> SqmExpression<N> min(Expression<N> argument) {
        return this.getFunctionDescriptor("min").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> greatest(Expression<X> argument) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("max").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getTypeConfiguration());
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> least(Expression<X> argument) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("min").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getTypeConfiguration());
    }

    @Override
    public SqmExpression<Long> count(Expression<?> argument) {
        return this.getFunctionDescriptor("count").generateSqmExpression((SqmTypedNode)argument, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<Long> countDistinct(Expression<?> argument) {
        return this.getFunctionDescriptor("count").generateSqmExpression(new SqmDistinct((SqmExpression)argument, this.getQueryEngine().getCriteriaBuilder()), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<Integer> sign(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sign").generateSqmExpression((SqmExpression)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> JpaExpression<N> ceiling(Expression<N> x) {
        return this.getFunctionDescriptor("ceiling").generateSqmExpression((SqmExpression)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> JpaExpression<N> floor(Expression<N> x) {
        return this.getFunctionDescriptor("floor").generateSqmExpression((SqmExpression)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<Double> exp(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("exp").generateSqmExpression((SqmExpression)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<Double> ln(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("ln").generateSqmExpression((SqmExpression)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<Double> power(Expression<? extends Number> x, Expression<? extends Number> y) {
        return this.getFunctionDescriptor("power").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)y), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<Double> power(Expression<? extends Number> x, Number y) {
        return this.getFunctionDescriptor("power").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(y)), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <T extends Number> JpaExpression<T> round(Expression<T> x, Integer n) {
        return this.getFunctionDescriptor("round").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(n)), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <T extends Number> JpaExpression<T> truncate(Expression<T> x, Integer n) {
        return this.getFunctionDescriptor("truncate").generateSqmExpression(Arrays.asList((SqmExpression)x, this.value(n)), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> SqmExpression<N> neg(Expression<N> x) {
        SqmExpression sqmExpression = (SqmExpression)x;
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, sqmExpression);
    }

    @Override
    public <N extends Number> SqmExpression<N> abs(Expression<N> x) {
        return this.getFunctionDescriptor("abs").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression)y);
    }

    private <N extends Number> SqmExpression<N> createSqmArithmeticNode(BinaryArithmeticOperator operator, SqmExpression<?> leftHandExpression, SqmExpression<?> rightHandExpression) {
        return new SqmBinaryArithmetic(operator, leftHandExpression, rightHandExpression, this.getDomainModel().getTypeConfiguration().resolveArithmeticType(leftHandExpression.getNodeType(), rightHandExpression.getNodeType(), operator), (NodeBuilder)this);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, this.value(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)x, this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MULTIPLY, this.value(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, this.value(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Number y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, this.value(y));
    }

    @Override
    public SqmExpression<Number> quot(Number x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Integer y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, this.value(y));
    }

    @Override
    public SqmExpression<Integer> mod(Integer x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, this.value(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Double> sqrt(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sqrt").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<Long> toLong(Expression<? extends Number> number) {
        return ((SqmExpression)number).asLong();
    }

    @Override
    public SqmExpression<Integer> toInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asInteger();
    }

    @Override
    public SqmExpression<Float> toFloat(Expression<? extends Number> number) {
        return ((SqmExpression)number).asFloat();
    }

    @Override
    public SqmExpression<Double> toDouble(Expression<? extends Number> number) {
        return ((SqmExpression)number).asDouble();
    }

    @Override
    public SqmExpression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigDecimal();
    }

    @Override
    public SqmExpression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigInteger();
    }

    @Override
    public SqmExpression<String> toString(Expression<Character> character) {
        return ((SqmExpression)character).asString();
    }

    public <T> SqmLiteral<T> literal(T value, SqmExpression<? extends T> typeInferenceSource) {
        if (value == null) {
            return new SqmLiteralNull(this);
        }
        SqmExpressible<T> expressible = SqmCriteriaNodeBuilder.resolveInferredType(value, typeInferenceSource, this.getTypeConfiguration());
        if (expressible.getExpressibleJavaType().isInstance(value)) {
            return new SqmLiteral<T>(value, expressible, this);
        }
        T coercedValue = expressible.getExpressibleJavaType().coerce(value, this::getTypeConfiguration);
        if (expressible.getExpressibleJavaType().isInstance(coercedValue)) {
            return new SqmLiteral<T>(coercedValue, expressible, this);
        }
        return this.literal((Object)value);
    }

    private static <T> SqmExpressible<T> resolveInferredType(T value, SqmExpression<? extends T> typeInferenceSource, TypeConfiguration typeConfiguration) {
        if (typeInferenceSource != null) {
            return typeInferenceSource.getNodeType();
        }
        if (value == null) {
            return null;
        }
        return typeConfiguration.getBasicTypeForJavaType(value.getClass());
    }

    public <T> SqmLiteral<T> literal(T value) {
        if (value == null) {
            if (this.jpaComplianceEnabled) {
                throw new IllegalArgumentException("literal value cannot be null");
            }
            return new SqmLiteralNull(this);
        }
        BindableType<T> valueParamType = this.getMappingMetamodel().resolveParameterBindType(value);
        SqmExpressible<T> sqmExpressible = valueParamType == null ? null : valueParamType.resolveExpressible(this.getSessionFactory());
        return new SqmLiteral<T>(value, sqmExpressible, this);
    }

    private MappingMetamodelImplementor getMappingMetamodel() {
        return this.getSessionFactory().getMappingMetamodel();
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(T[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(List<T> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> SqmExpression<T> nullLiteral(Class<T> resultClass) {
        if (resultClass.isEnum()) {
            return new SqmLiteralNull(this);
        }
        ManagedType basicTypeForJavaType = this.getTypeConfiguration().getBasicTypeForJavaType(resultClass);
        ManagedType sqmExpressible = basicTypeForJavaType == null ? this.getDomainModel().managedType(resultClass) : basicTypeForJavaType;
        return new SqmLiteralNull(sqmExpressible, (NodeBuilder)this);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass) {
        return this.parameter((Class)paramClass, (String)null);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass, String name) {
        BasicType<T> basicType = this.getTypeConfiguration().getBasicTypeForJavaType(paramClass);
        if (basicType == null) {
            MultiValueParameterType<Collection> parameterType = Collection.class.isAssignableFrom(paramClass) ? new MultiValueParameterType<Collection>(Collection.class) : null;
            return new JpaCriteriaParameter<Collection>(name, parameterType, true, this);
        }
        return new JpaCriteriaParameter<T>(name, basicType, false, this);
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, Expression<String> y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression ySqmExpression = (SqmExpression)y;
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, String y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression<String> ySqmExpression = this.value(y, xSqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<String> concat(String x, Expression<String> y) {
        SqmExpression ySqmExpression = (SqmExpression)y;
        SqmExpression<String> xSqmExpression = this.value(x, ySqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<String> concat(String x, String y) {
        SqmExpression<String> xSqmExpression = this.value(x);
        SqmExpression<String> ySqmExpression = this.value(y, xSqmExpression);
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(xSqmExpression, ySqmExpression), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, null);
    }

    private SqmFunction<String> createSubstringNode(SqmExpression<String> source, SqmExpression<Integer> from, SqmExpression<Integer> len) {
        return this.getFunctionDescriptor("substring").generateSqmExpression(len == null ? Arrays.asList(source, from) : Arrays.asList(source, from, len), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from) {
        return this.createSubstringNode((SqmExpression)source, this.value(from), null);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from, Expression<Integer> len) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, (SqmExpression)len);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from, int len) {
        return this.createSubstringNode((SqmExpression)source, this.value(from), this.value(len));
    }

    @Override
    public SqmFunction<String> trim(Expression<String> source) {
        return this.createTrimNode(null, null, (SqmExpression)source);
    }

    private SqmFunction<String> createTrimNode(TrimSpec trimSpecification, SqmExpression<Character> trimCharacter, SqmExpression<String> source) {
        if (trimSpecification == null) {
            trimSpecification = TrimSpec.BOTH;
        }
        if (trimCharacter == null) {
            trimCharacter = new SqmLiteral<Character>(Character.valueOf(' '), this.getTypeConfiguration().standardBasicTypeForJavaType(Character.class), this);
        }
        ArrayList<SqmTypedNode<Object>> arguments = new ArrayList<SqmTypedNode<Object>>(3);
        arguments.add(new SqmTrimSpecification(trimSpecification, this));
        arguments.add(trimCharacter);
        arguments.add(source);
        return this.getFunctionDescriptor("trim").generateSqmExpression(arguments, null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), null, (SqmExpression)source);
    }

    private static TrimSpec convertTrimSpec(CriteriaBuilder.Trimspec jpaTs) {
        if (jpaTs == null) {
            return null;
        }
        switch (jpaTs) {
            case BOTH: {
                return TrimSpec.BOTH;
            }
            case LEADING: {
                return TrimSpec.LEADING;
            }
            case TRAILING: {
                return TrimSpec.TRAILING;
            }
        }
        throw new QueryException("Could not resolve JPA TrimSpec : " + jpaTs);
    }

    @Override
    public SqmFunction<String> trim(Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(null, (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(char trimChar, Expression<String> source) {
        return this.createTrimNode(null, this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, char trimChar, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> lower(Expression<String> x) {
        return this.getFunctionDescriptor("lower").generateSqmExpression((SqmExpression)x, null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<String> upper(Expression<String> x) {
        return this.getFunctionDescriptor("upper").generateSqmExpression((SqmExpression)x, null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Integer> length(Expression<String> argument) {
        return this.getFunctionDescriptor("length").generateSqmExpression((SqmExpression)argument, null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, null);
    }

    private SqmFunction<Integer> createLocateFunctionNode(SqmExpression<String> source, SqmExpression<String> pattern, SqmExpression<Integer> startPosition) {
        List<SqmTypedNode> arguments = startPosition == null ? Arrays.asList(pattern, source) : Arrays.asList(pattern, source, startPosition);
        return this.getFunctionDescriptor("locate").generateSqmExpression(arguments, null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, this.value(pattern), null);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern, Expression<Integer> startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, (SqmExpression)startPosition);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern, int startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, this.value(pattern), this.value(startPosition));
    }

    @Override
    public SqmFunction<Date> currentDate() {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Timestamp> currentTimestamp() {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Time> currentTime() {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmFunction<Instant> currentInstant() {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.getJpaMetamodel().getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT), this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<LocalDate> localDate() {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<LocalDateTime> localDateTime() {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public JpaExpression<LocalTime> localTime() {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public <T> SqmFunction<T> function(String name, Class<T> type, Expression<?>[] args) {
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(name);
        BasicType<T> resultType = this.getTypeConfiguration().getBasicTypeForJavaType(type);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(name, true, null, StandardFunctionReturnTypeResolvers.invariant(resultType), null);
        }
        return functionTemplate.generateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), resultType, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    private static List<SqmExpression<?>> expressionList(Expression<?>[] jpaExpressions) {
        if (jpaExpressions == null || jpaExpressions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList sqmExpressions = new ArrayList();
        for (Expression<?> jpaExpression : jpaExpressions) {
            sqmExpressions.add((SqmExpression)jpaExpression);
        }
        return sqmExpressions;
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> all(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.ALL, this);
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> some(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.SOME, this);
    }

    @Override
    public <Y> SqmModifiedSubQueryExpression<Y> any(Subquery<Y> subquery) {
        return new SqmModifiedSubQueryExpression((SqmSubQuery)subquery, SqmModifiedSubQueryExpression.Modifier.ANY, this);
    }

    @Override
    public <K, M extends Map<K, ?>> SqmExpression<Set<K>> keys(M map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, L extends List<?>> SqmExpression<Set<K>> indexes(L list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SqmExpression<T> value(T value, SqmExpression<? extends T> typeInferenceSource) {
        if (value instanceof SqmExpression) {
            return (SqmExpression)value;
        }
        if (this.criteriaValueHandlingMode == ValueHandlingMode.INLINE) {
            return this.literal((Object)value, (SqmExpression)typeInferenceSource);
        }
        BindableType<T> bindableType = SqmCriteriaNodeBuilder.resolveInferredParameterType(value, typeInferenceSource, this.getTypeConfiguration());
        if (bindableType == null || this.isInstance(bindableType, value)) {
            return new ValueBindJpaCriteriaParameter<T>(bindableType, value, this);
        }
        SqmExpressible<T> expressible = bindableType.resolveExpressible(this.getSessionFactory());
        T coercedValue = expressible.getExpressibleJavaType().coerce(value, this::getTypeConfiguration);
        if (this.isInstance(bindableType, coercedValue)) {
            return new ValueBindJpaCriteriaParameter<T>(bindableType, coercedValue, this);
        }
        return new ValueBindJpaCriteriaParameter<T>(this.getMappingMetamodel().resolveParameterBindType(value), value, this);
    }

    private <T> boolean isInstance(BindableType<T> bindableType, T value) {
        if (bindableType instanceof SqmExpressible) {
            return ((SqmExpressible)bindableType).getExpressibleJavaType().isInstance(value);
        }
        if (bindableType.getBindableJavaType().isInstance(value)) {
            return true;
        }
        return bindableType.resolveExpressible(this.getSessionFactory()).getExpressibleJavaType().isInstance(value);
    }

    private static <T> BindableType<T> resolveInferredParameterType(T value, SqmExpression<? extends T> typeInferenceSource, TypeConfiguration typeConfiguration) {
        if (typeInferenceSource != null) {
            if (typeInferenceSource instanceof BindableType) {
                return (BindableType)((Object)typeInferenceSource);
            }
            SqmExpressible<?> nodeType = SqmCriteriaNodeBuilder.getNodeType(typeInferenceSource);
            if (nodeType != null) {
                return nodeType;
            }
        }
        return value == null ? null : typeConfiguration.getBasicTypeForJavaType(value.getClass());
    }

    private static SqmExpressible<?> getNodeType(SqmExpression<?> expression) {
        if (expression instanceof SqmPath) {
            SqmPathSource pathSource = ((SqmPath)expression).getResolvedModel();
            return pathSource instanceof SingularPersistentAttribute ? ((SingularPersistentAttribute)pathSource).getPathSource() : pathSource;
        }
        return expression.getNodeType();
    }

    @Override
    public <T> SqmExpression<T> value(T value) {
        if (value instanceof SqmExpression) {
            return (SqmExpression)value;
        }
        if (this.criteriaValueHandlingMode == ValueHandlingMode.INLINE) {
            return this.literal((Object)value);
        }
        return new ValueBindJpaCriteriaParameter<T>(this.getMappingMetamodel().resolveParameterBindType(value), value, this);
    }

    @Override
    public <V, C extends Collection<V>> SqmExpression<Collection<V>> values(C collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(Expression<C> collection) {
        return new SqmCollectionSize((SqmPath)collection, (NodeBuilder)this);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(C collection) {
        return new SqmLiteral<Integer>(collection.size(), this.getIntegerType(), this);
    }

    @Override
    public <T> SqmCoalesce<T> coalesce() {
        return new SqmCoalesce(this);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        SqmExpressible sqmExpressible = QueryHelper.highestPrecedenceType(((SqmExpression)x).getNodeType(), ((SqmExpression)y).getNodeType());
        return ((SqmCoalesce)new SqmCoalesce(sqmExpressible, 2, this).value((Expression)x)).value((Expression)y);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Y y) {
        return this.coalesce((Expression)x, this.value(y, (SqmExpression)x));
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return this.createNullifFunctionNode((SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Y y) {
        return this.createNullifFunctionNode((SqmExpression)x, this.value(y, (SqmExpression)x));
    }

    private <Y> SqmExpression<Y> createNullifFunctionNode(SqmExpression<Y> first, SqmExpression<Y> second) {
        ReturnableType type = (ReturnableType)QueryHelper.highestPrecedenceType(first.getNodeType(), second.getNodeType());
        return this.getFunctionDescriptor("nullif").generateSqmExpression(Arrays.asList(first, second), type, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    public <C, R> SqmCaseSimple<C, R> selectCase(Expression<? extends C> expression) {
        return new SqmCaseSimple((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <R> SqmCaseSearched<R> selectCase() {
        return new SqmCaseSearched(this);
    }

    @Override
    public <M extends Map<?, ?>> SqmExpression<Integer> mapSize(JpaExpression<M> mapExpression) {
        return new SqmCollectionSize((SqmPath)mapExpression, (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmExpression<Integer> mapSize(M map) {
        return new SqmLiteral<Integer>(map.size(), this.getIntegerType(), this);
    }

    @Override
    public SqmPredicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, (SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate and(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.conjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.length);
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.AND, predicates, this);
    }

    @Override
    public SqmPredicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmJunctionPredicate(Predicate.BooleanOperator.OR, (SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate or(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.disjunction();
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(restrictions.length);
        for (Predicate expression : restrictions) {
            predicates.add((SqmPredicate)expression);
        }
        return new SqmJunctionPredicate(Predicate.BooleanOperator.OR, predicates, this);
    }

    @Override
    public SqmPredicate not(Expression<Boolean> restriction) {
        JpaPredicate predicate = this.wrap((Expression)restriction);
        return predicate.not();
    }

    @Override
    public SqmPredicate conjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, this.getIntegerType(), this), ComparisonOperator.EQUAL, new SqmLiteral<Integer>(1, this.getIntegerType(), this), this);
    }

    @Override
    public SqmPredicate disjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, this.getIntegerType(), this), ComparisonOperator.NOT_EQUAL, new SqmLiteral<Integer>(1, this.getIntegerType(), this), this);
    }

    @Override
    public SqmPredicate isTrue(Expression<Boolean> x) {
        return this.wrap((Expression)x);
    }

    @Override
    public SqmPredicate isFalse(Expression<Boolean> x) {
        return this.wrap((Expression)x).not();
    }

    @Override
    public SqmPredicate isNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate isNotNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this).not();
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Expression<? extends Y> lower, Expression<? extends Y> upper) {
        this.assertComparable(value, lower);
        this.assertComparable(value, upper);
        return new SqmBetweenPredicate((SqmExpression)value, (SqmExpression)lower, (SqmExpression)upper, false, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Y lower, Y upper) {
        SqmExpression valueExpression = (SqmExpression)value;
        SqmExpression<Y> lowerExpr = this.value(lower, valueExpression);
        SqmExpression<Y> upperExpr = this.value(upper, valueExpression);
        this.assertComparable(valueExpression, lowerExpr);
        this.assertComparable(valueExpression, upperExpr);
        return new SqmBetweenPredicate(valueExpression, lowerExpr, upperExpr, false, this);
    }

    public void assertComparable(Expression<?> x, Expression<?> y) {
        SqmExpressible rhsType;
        SqmExpressible lhsType = ((SqmExpression)x).getNodeType();
        if (!SqmCriteriaNodeBuilder.areTypesComparable(lhsType, rhsType = ((SqmExpression)y).getNodeType())) {
            throw new IllegalArgumentException(String.format("Can't compare test expression of type [%s] with element of type [%s]", lhsType, rhsType));
        }
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Expression<?> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Expression<?> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate distinctFrom(Expression<?> x, Expression<?> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.DISTINCT_FROM, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate distinctFrom(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.DISTINCT_FROM, yExpr, this);
    }

    @Override
    public SqmPredicate notDistinctFrom(Expression<?> x, Expression<?> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_DISTINCT_FROM, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate notDistinctFrom(Expression<?> x, Object y) {
        SqmExpression<Object> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_DISTINCT_FROM, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, yExpr, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        SqmExpression<Y> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, yExpr, this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, yExpr, this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        this.assertComparable(x, y);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Number y) {
        SqmExpression<Number> yExpr = this.value(y, (SqmExpression)x);
        this.assertComparable(x, yExpr);
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, yExpr, this);
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isEmpty(Expression<C> collection) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)collection, false, (NodeBuilder)this);
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isNotEmpty(Expression<C> collection) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)collection, true, (NodeBuilder)this);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(Expression<E> elem, Expression<C> collection) {
        return new SqmMemberOfPredicate((SqmExpression)elem, (SqmPath)collection, false, this);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(E elem, Expression<C> collection) {
        return new SqmMemberOfPredicate(this.value(elem), (SqmPath)collection, false, this);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(Expression<E> elem, Expression<C> collection) {
        return new SqmMemberOfPredicate((SqmExpression)elem, (SqmPath)collection, true, this);
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(E elem, Expression<C> collection) {
        return new SqmMemberOfPredicate(this.value(elem), (SqmPath)collection, true, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (NodeBuilder)this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, false, false, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), false, false, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (SqmExpression)escapeChar, false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, Expression<String> pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this.literal(Character.valueOf(escapeChar)), false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), (SqmExpression)escapeChar, false, false, this);
    }

    @Override
    public SqmPredicate ilike(Expression<String> searchString, String pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.value(pattern, (SqmExpression)searchString), this.literal(Character.valueOf(escapeChar)), false, false, this);
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern) {
        return this.not(this.like((Expression)x, (Expression)pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern) {
        return this.not(this.like((Expression)x, pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not(this.like((Expression)x, (Expression)pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not(this.like((Expression)x, (Expression)pattern, escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not(this.like((Expression)x, pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return this.not(this.like((Expression)x, pattern, escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern) {
        return this.not(this.ilike((Expression)x, (Expression)pattern));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern) {
        return this.not(this.ilike((Expression)x, pattern));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not(this.ilike((Expression)x, (Expression)pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not(this.ilike((Expression)x, (Expression)pattern, escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not(this.ilike((Expression)x, pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notIlike(Expression<String> x, String pattern, char escapeChar) {
        return this.not(this.ilike((Expression)x, pattern, escapeChar));
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression) {
        return new SqmInListPredicate((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, Expression<? extends T> ... values) {
        ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(values.length);
        for (Expression<? extends T> value : values) {
            listExpressions.add((SqmExpression)value);
        }
        return new SqmInListPredicate((SqmExpression)expression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, T ... values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        ArrayList<SqmExpression<T>> listExpressions = new ArrayList<SqmExpression<T>>(values.length);
        for (T value : values) {
            listExpressions.add(this.value(value, sqmExpression));
        }
        return new SqmInListPredicate(sqmExpression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, Collection<T> values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        ArrayList<SqmExpression<T>> listExpressions = new ArrayList<SqmExpression<T>>(values.size());
        for (T value : values) {
            listExpressions.add(this.value(value, sqmExpression));
        }
        return new SqmInListPredicate(sqmExpression, listExpressions, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate<T> in(Expression<? extends T> expression, SqmSubQuery<T> subQuery) {
        return new SqmInSubQueryPredicate<T>((SqmExpression)expression, subQuery, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate exists(Subquery<?> subQuery) {
        return new SqmExistsPredicate((SqmExpression)subQuery, (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapEmpty(JpaExpression<M> mapExpression) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)mapExpression, false, (NodeBuilder)this);
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapNotEmpty(JpaExpression<M> mapExpression) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)mapExpression, true, (NodeBuilder)this);
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SqmCriteriaNodeBuilder");
        return SqmCriteriaNodeBuilder.locateSessionFactoryOnDeserialization(this.uuid, this.name).getCriteriaBuilder();
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactoryImplementor namedResult;
        SessionFactoryImplementor uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    public <T> SqmFunction<T> sql(String pattern, Class<T> type, Expression<?> ... arguments) {
        ArrayList sqmArguments = new ArrayList(SqmCriteriaNodeBuilder.expressionList(arguments));
        sqmArguments.add(0, this.literal(pattern));
        return this.getFunctionDescriptor("sql").generateSqmExpression(sqmArguments, this.getTypeConfiguration().getBasicTypeForJavaType(type), this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> format(Expression<? extends TemporalAccessor> datetime, String pattern) {
        SqmFormat sqmFormat = new SqmFormat(pattern, null, (NodeBuilder)this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList((SqmExpression)datetime, sqmFormat), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    private <T> SqmFunction<T> extract(Expression<? extends TemporalAccessor> datetime, TemporalUnit temporalUnit, Class<T> type) {
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(new SqmExtractUnit<T>(temporalUnit, this.getTypeConfiguration().standardBasicTypeForJavaType(type), this), (SqmTypedNode)datetime), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Integer> year(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.YEAR, Integer.class);
    }

    public SqmFunction<Integer> month(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.MONTH, Integer.class);
    }

    public SqmFunction<Integer> day(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.DAY, Integer.class);
    }

    public SqmFunction<Integer> hour(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.HOUR, Integer.class);
    }

    public SqmFunction<Integer> minute(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.MINUTE, Integer.class);
    }

    public SqmFunction<Float> second(Expression<? extends TemporalAccessor> datetime) {
        return this.extract(datetime, TemporalUnit.SECOND, Float.class);
    }

    public <T extends TemporalAccessor> SqmFunction<T> truncate(Expression<T> datetime, TemporalUnit temporalUnit) {
        return this.getFunctionDescriptor("trunc").generateSqmExpression(Arrays.asList((SqmTypedNode)datetime, new SqmExtractUnit<Integer>(temporalUnit, this.getIntegerType(), this)), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start) {
        return this.overlay((Expression)string, replacement, (Expression)this.value(start), (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value(start), (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)start, (Expression)null);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start, int length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)this.value(start), (Expression)this.value(length));
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start, int length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value(start), (Expression)this.value(length));
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start, int length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)this.value(length));
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start, int length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)start, (Expression)this.value(length));
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, int start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)this.value(start), (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, int start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)replacement, (Expression)this.value(start), (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, String replacement, Expression<Integer> start, Expression<Integer> length) {
        return this.overlay((Expression)string, (Expression)this.value(replacement), (Expression)start, (Expression)length);
    }

    public SqmFunction<String> overlay(Expression<String> string, Expression<String> replacement, Expression<Integer> start, Expression<Integer> length) {
        SqmExpression sqmString = (SqmExpression)string;
        SqmExpression sqmReplacement = (SqmExpression)replacement;
        SqmExpression sqmStart = (SqmExpression)start;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(sqmString, sqmReplacement, sqmStart) : Arrays.asList(sqmString, sqmReplacement, sqmStart, (SqmExpression)length), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> pad(Expression<String> x, int length) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value(length), (Expression)null);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length) {
        return this.pad(ts, (Expression)x, (Expression)this.value(length), (Expression)null);
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)null);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length) {
        return this.pad(ts, (Expression)x, (Expression)length, (Expression)null);
    }

    public SqmFunction<String> pad(Expression<String> x, int length, char padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value(length), (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length, char padChar) {
        return this.pad(ts, (Expression)x, (Expression)this.value(length), (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(Expression<String> x, int length, Expression<Character> padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)this.value(length), (Expression)padChar);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, int length, Expression<Character> padChar) {
        return this.pad(ts, (Expression)x, (Expression)this.value(length), (Expression)padChar);
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length, char padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length, char padChar) {
        return this.pad(ts, (Expression)x, (Expression)length, (Expression)this.value(Character.valueOf(padChar)));
    }

    public SqmFunction<String> pad(Expression<String> x, Expression<Integer> length, Expression<Character> padChar) {
        return this.pad((CriteriaBuilder.Trimspec)null, (Expression)x, (Expression)length, (Expression)padChar);
    }

    public SqmFunction<String> pad(CriteriaBuilder.Trimspec ts, Expression<String> x, Expression<Integer> length, Expression<Character> padChar) {
        SqmExpression source = (SqmExpression)x;
        SqmExpression sqmLength = (SqmExpression)length;
        SqmTrimSpecification padSpec = new SqmTrimSpecification(ts == null ? TrimSpec.TRAILING : SqmCriteriaNodeBuilder.convertTrimSpec(ts), this);
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, sqmLength, padSpec, (SqmExpression)padChar) : Arrays.asList(source, sqmLength, padSpec), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> left(Expression<String> x, int length) {
        return this.left((Expression)x, this.value(length));
    }

    public SqmFunction<String> left(Expression<String> x, Expression<Integer> length) {
        return this.getFunctionDescriptor("left").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)length), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> right(Expression<String> x, int length) {
        return this.right((Expression)x, this.value(length));
    }

    public SqmFunction<String> right(Expression<String> x, Expression<Integer> length) {
        return this.getFunctionDescriptor("right").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)length), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> replace(Expression<String> x, String pattern, String replacement) {
        SqmExpression<String> sqmPattern = this.value(pattern);
        return this.replace((Expression)x, (Expression)sqmPattern, (Expression)this.value(replacement, sqmPattern));
    }

    public SqmFunction<String> replace(Expression<String> x, String pattern, Expression<String> replacement) {
        return this.replace((Expression)x, (Expression)this.value(pattern), (Expression)replacement);
    }

    public SqmFunction<String> replace(Expression<String> x, Expression<String> pattern, String replacement) {
        return this.replace((Expression)x, (Expression)pattern, (Expression)this.value(replacement));
    }

    public SqmFunction<String> replace(Expression<String> x, Expression<String> pattern, Expression<String> replacement) {
        return this.getFunctionDescriptor("replace").generateSqmExpression(Arrays.asList((SqmExpression)x, (SqmExpression)pattern, (SqmExpression)replacement), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<String> collate(Expression<String> x, String collation) {
        SqmCollation sqmCollation = new SqmCollation(collation, null, (NodeBuilder)this);
        return this.getFunctionDescriptor("collate").generateSqmExpression(Arrays.asList((SqmExpression)x, sqmCollation), null, this.getQueryEngine(), this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> log10(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("log10").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> log(Number b, Expression<? extends Number> x) {
        return this.log(this.value(b), (Expression)x);
    }

    public SqmFunction<Double> log(Expression<? extends Number> b, Expression<? extends Number> x) {
        return this.getFunctionDescriptor("log").generateSqmExpression(Arrays.asList((SqmTypedNode)b, (SqmTypedNode)x), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> pi() {
        return this.getFunctionDescriptor("pi").generateSqmExpression(null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> sin(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sin").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> cos(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("cos").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> tan(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("tan").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> asin(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("asin").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> acos(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("acos").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> atan(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("atan").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> atan2(Number y, Expression<? extends Number> x) {
        return this.atan2((Expression)this.value(y), (Expression)x);
    }

    public SqmFunction<Double> atan2(Expression<? extends Number> y, Number x) {
        return this.atan2((Expression)y, (Expression)this.value(x));
    }

    public SqmFunction<Double> atan2(Expression<? extends Number> y, Expression<? extends Number> x) {
        return this.getFunctionDescriptor("atan2").generateSqmExpression(Arrays.asList((SqmTypedNode)y, (SqmTypedNode)x), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> sinh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("sinh").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> cosh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("cosh").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> tanh(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("tanh").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> degrees(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("degrees").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    public SqmFunction<Double> radians(Expression<? extends Number> x) {
        return this.getFunctionDescriptor("radians").generateSqmExpression((SqmTypedNode)x, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmWindow createWindow() {
        return new SqmWindow(this);
    }

    @Override
    public SqmWindowFrame frameUnboundedPreceding() {
        return new SqmWindowFrame(this, FrameKind.UNBOUNDED_PRECEDING);
    }

    @Override
    public SqmWindowFrame frameBetweenPreceding(int offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_PRECEDING, this.literal((Object)offset));
    }

    @Override
    public SqmWindowFrame frameBetweenPreceding(Expression<?> offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_PRECEDING, (SqmExpression)offset);
    }

    @Override
    public SqmWindowFrame frameCurrentRow() {
        return new SqmWindowFrame(this, FrameKind.CURRENT_ROW);
    }

    @Override
    public SqmWindowFrame frameBetweenFollowing(int offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_FOLLOWING, this.literal((Object)offset));
    }

    @Override
    public SqmWindowFrame frameBetweenFollowing(Expression<?> offset) {
        return new SqmWindowFrame(this, FrameKind.OFFSET_FOLLOWING, (SqmExpression)offset);
    }

    @Override
    public SqmWindowFrame frameUnboundedFollowing() {
        return new SqmWindowFrame(this, FrameKind.UNBOUNDED_FOLLOWING);
    }

    public <T> SqmExpression<T> windowFunction(String name, Class<T> type, JpaWindow window, Expression<?> ... args) {
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
        return new SqmOver(function, (SqmWindow)window);
    }

    public SqmExpression<Long> rowNumber(JpaWindow window) {
        return this.windowFunction("row_number", Long.class, window, new Expression[0]);
    }

    public <T> SqmExpression<T> firstValue(Expression<T> argument, JpaWindow window) {
        return this.windowFunction("first_value", argument.getJavaType(), window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> lastValue(Expression<T> argument, JpaWindow window) {
        return this.windowFunction("last_value", argument.getJavaType(), window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> nthValue(Expression<T> argument, int n, JpaWindow window) {
        return this.nthValue((Expression)argument, this.literal((Object)n), window);
    }

    public <T> SqmExpression<T> nthValue(Expression<T> argument, Expression<Integer> n, JpaWindow window) {
        return this.windowFunction("nth_value", argument.getJavaType(), window, new Expression[]{argument, n});
    }

    public SqmExpression<Long> rank(JpaWindow window) {
        return this.windowFunction("rank", Long.class, window, new Expression[0]);
    }

    public SqmExpression<Long> denseRank(JpaWindow window) {
        return this.windowFunction("dense_rank", Long.class, window, new Expression[0]);
    }

    public SqmExpression<Double> percentRank(JpaWindow window) {
        return this.windowFunction("percent_rank", Double.class, window, new Expression[0]);
    }

    public SqmExpression<Double> cumeDist(JpaWindow window) {
        return this.windowFunction("cume_dist", Double.class, window, new Expression[0]);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaPredicate filter, Expression<?> ... args) {
        return this.functionAggregate(name, (Class)type, filter, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaWindow window, Expression<?> ... args) {
        return this.functionAggregate(name, (Class)type, (JpaPredicate)null, window, (Expression[])args);
    }

    public <T> SqmExpression<T> functionAggregate(String name, Class<T> type, JpaPredicate filter, JpaWindow window, Expression<?> ... args) {
        SqmPredicate sqmFilter = filter != null ? (SqmPredicate)filter : null;
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateAggregateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), sqmFilter, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
        if (window == null) {
            return function;
        }
        return new SqmOver(function, (SqmWindow)window);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaPredicate filter) {
        return this.sum((Expression)argument, filter, (JpaWindow)null);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaWindow window) {
        return this.sum((Expression)argument, (JpaPredicate)null, window);
    }

    public <N extends Number> SqmExpression<Number> sum(Expression<N> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("sum", Number.class, filter, window, new Expression[]{argument});
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaPredicate filter) {
        return this.avg((Expression)argument, filter, (JpaWindow)null);
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaWindow window) {
        return this.avg((Expression)argument, (JpaPredicate)null, window);
    }

    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("avg", Double.class, filter, window, new Expression[]{argument});
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaPredicate filter) {
        return this.count((Expression)argument, filter, (JpaWindow)null);
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaWindow window) {
        return this.count((Expression)argument, (JpaPredicate)null, window);
    }

    public SqmExpression<Long> count(Expression<?> argument, JpaPredicate filter, JpaWindow window) {
        return this.functionAggregate("count", Long.class, filter, window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, (JpaPredicate)null, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaPredicate filter, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, filter, (JpaWindow)null, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaWindow window, Expression<?> ... args) {
        return this.functionWithinGroup(name, (Class)type, order, (JpaPredicate)null, window, (Expression[])args);
    }

    public <T> SqmExpression<T> functionWithinGroup(String name, Class<T> type, JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... args) {
        SqmOrderByClause withinGroupClause = new SqmOrderByClause();
        if (order != null) {
            withinGroupClause.addSortSpecification((SqmSortSpecification)order);
        }
        SqmPredicate sqmFilter = filter != null ? (SqmPredicate)filter : null;
        SelfRenderingSqmFunction function = this.getFunctionDescriptor(name).generateOrderedSetAggregateSqmExpression(SqmCriteriaNodeBuilder.expressionList(args), sqmFilter, withinGroupClause, null, this.queryEngine, this.getJpaMetamodel().getTypeConfiguration());
        if (window == null) {
            return function;
        }
        return new SqmOver(function, (SqmWindow)window);
    }

    public SqmExpression<String> listagg(JpaOrder order, Expression<String> argument, String separator) {
        return this.listagg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, (JpaPredicate)null, (JpaWindow)null, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, Expression<String> argument, String separator) {
        return this.listagg(order, filter, (JpaWindow)null, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, filter, (JpaWindow)null, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaWindow window, Expression<String> argument, String separator) {
        return this.listagg(order, (JpaPredicate)null, window, (Expression)argument, separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaWindow window, Expression<String> argument, Expression<String> separator) {
        return this.listagg(order, (JpaPredicate)null, window, (Expression)argument, (Expression)separator);
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<String> argument, String separator) {
        return this.listagg(order, filter, window, (Expression)argument, this.literal(separator));
    }

    public SqmExpression<String> listagg(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<String> argument, Expression<String> separator) {
        return this.functionWithinGroup("listagg", String.class, order, filter, window, new Expression[]{argument, separator});
    }

    public <T> SqmExpression<T> mode(Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.mode((JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaPredicate filter, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.mode(filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.mode((JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> mode(JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.functionWithinGroup("mode", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[0]);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileCont((Expression)argument, (JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaPredicate filter, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileCont((Expression)argument, filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileCont((Expression)argument, (JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileCont(Expression<? extends Number> argument, JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.functionWithinGroup("percentile_cont", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[]{argument});
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileDisc((Expression)argument, (JpaPredicate)null, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaPredicate filter, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileDisc((Expression)argument, filter, (JpaWindow)null, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.percentileDisc((Expression)argument, (JpaPredicate)null, window, (Expression)sortExpression, sortOrder, nullPrecedence);
    }

    public <T> SqmExpression<T> percentileDisc(Expression<? extends Number> argument, JpaPredicate filter, JpaWindow window, Expression<T> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return this.functionWithinGroup("percentile_disc", sortExpression.getJavaType(), this.sort((JpaExpression)((SqmExpression)sortExpression), sortOrder, nullPrecedence), filter, window, new Expression[]{argument});
    }

    public SqmExpression<Long> rank(JpaOrder order, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, (JpaPredicate)null, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaPredicate filter, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, filter, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, (JpaPredicate)null, window, (Expression[])arguments);
    }

    public SqmExpression<Long> rank(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("rank", Long.class, order, filter, window, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, Expression<?> ... arguments) {
        return this.percentRank(order, (JpaPredicate)null, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaPredicate filter, Expression<?> ... arguments) {
        return this.percentRank(order, filter, (JpaWindow)null, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaWindow window, Expression<?> ... arguments) {
        return this.percentRank(order, (JpaPredicate)null, window, (Expression[])arguments);
    }

    public SqmExpression<Double> percentRank(JpaOrder order, JpaPredicate filter, JpaWindow window, Expression<?> ... arguments) {
        return this.functionWithinGroup("percent_rank", Double.class, order, filter, window, (Expression[])arguments);
    }

    class MultiValueParameterType<T>
    implements SqmExpressible<T> {
        private final JavaType<T> javaType;

        public MultiValueParameterType(Class<T> type) {
            this.javaType = SqmCriteriaNodeBuilder.this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(type);
        }

        @Override
        public JavaType<T> getExpressibleJavaType() {
            return this.javaType;
        }

        @Override
        public Class<T> getBindableJavaType() {
            return this.javaType.getJavaTypeClass();
        }
    }
}

