/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.LoadContexts;

public class EntitySelectFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private static final String CONCRETE_NAME = EntitySelectFetchInitializer.class.getSimpleName();
    protected final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final boolean isEnhancedForLazyLoading;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler<?> keyAssembler;
    private final ToOneAttributeMapping toOneMapping;
    protected boolean isInitialized;
    protected Object entityInstance;

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    public EntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping toOneMapping, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> keyAssembler) {
        this.parentAccess = parentAccess;
        this.toOneMapping = toOneMapping;
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.keyAssembler = keyAssembler;
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.toOneMapping;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        for (NavigablePath np = this.navigablePath.getParent(); np != null; np = np.getParent()) {
            if (!(np instanceof EntityIdentifierNavigablePath) && !"{fk}".equals(np.getLocalName()) && !"{fk-target}".equals(np.getLocalName())) continue;
            this.initializeInstance(rowProcessingState);
            return;
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null || this.isInitialized) {
            return;
        }
        EntityInitializer parentEntityInitializer = this.parentAccess.findFirstEntityInitializer();
        if (parentEntityInitializer != null && parentEntityInitializer.isEntityInitialized()) {
            this.isInitialized = true;
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object entityIdentifier = this.keyAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            this.isInitialized = true;
            return;
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        String entityName = this.concreteDescriptor.getEntityName();
        EntityKey entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(entityKey);
        if (this.entityInstance != null && Hibernate.isInitialized(this.entityInstance)) {
            this.isInitialized = true;
            return;
        }
        LoadContexts loadContexts = session.getPersistenceContext().getLoadContexts();
        LoadingEntityEntry existingLoadingEntry = loadContexts.findLoadingEntityEntry(entityKey);
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            EntityInitializer entityInitializer = existingLoadingEntry.getEntityInitializer();
            if (entityInitializer != this) {
                if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                    EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)entityInitializer);
                }
                this.isInitialized = true;
                return;
            }
            if (this.entityInstance == null) {
                this.isInitialized = true;
                return;
            }
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Invoking session#internalLoad for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        this.entityInstance = session.internalLoad(entityName, entityIdentifier, true, this.toOneMapping.isInternalLoadNullable());
        if (this.entityInstance == null) {
            if (this.toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                throw new FetchNotFoundException(entityName, entityIdentifier);
            }
            rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(entityKey, new LoadingEntityEntry(this, entityKey, this.concreteDescriptor, this.entityInstance));
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] : %s has being loaded by session.internalLoad.", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        boolean unwrapProxy = this.toOneMapping.isUnwrapProxy() && this.isEnhancedForLazyLoading;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            lazyInitializer.setUnwrap(unwrapProxy);
        }
        this.isInitialized = true;
    }

    protected boolean isAttributeAssignableToConcreteDescriptor() {
        return this.isAttributeAssignableToConcreteDescriptor(this.parentAccess, this.toOneMapping);
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.isInitialized = false;
        this.clearResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEntityInitialized() {
        return this.isInitialized;
    }

    @Override
    public Object getParentKey() {
        return this.parentAccess.getParentKey();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

