/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class AvgFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final SqlAstNodeRenderingMode defaultArgumentRenderingMode;
    private final CastFunction castFunction;
    private final BasicType<Double> doubleType;

    public AvgFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode defaultArgumentRenderingMode) {
        super("avg", FunctionKind.AGGREGATE, new ArgumentTypesValidator(StandardArgumentsValidators.exactly(1), FunctionParameterType.NUMERIC), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.NUMERIC));
        this.defaultArgumentRenderingMode = defaultArgumentRenderingMode;
        this.doubleType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE);
        this.castFunction = new CastFunction(dialect, dialect.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && !translator.supportsFilterClause();
        sqlAppender.appendSql("avg(");
        if (sqlAstArguments.get(0) instanceof Distinct) {
            sqlAppender.appendSql("distinct ");
            arg = ((Distinct)sqlAstArguments.get(0)).getExpression();
        } else {
            arg = (Expression)sqlAstArguments.get(0);
        }
        if (caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            this.renderArgument(sqlAppender, translator, arg);
            sqlAppender.appendSql(" else null end)");
        } else {
            this.renderArgument(sqlAppender, translator, arg);
            sqlAppender.appendSql(')');
            if (filter != null) {
                translator.getCurrentClauseStack().push(Clause.WHERE);
                sqlAppender.appendSql(" filter (where ");
                filter.accept(translator);
                sqlAppender.appendSql(')');
                translator.getCurrentClauseStack().pop();
            }
        }
    }

    private void renderArgument(SqlAppender sqlAppender, SqlAstTranslator<?> translator, Expression realArg) {
        JdbcMapping sourceMapping = realArg.getExpressionType().getSingleJdbcMapping();
        if (sourceMapping.getJdbcType().isInteger()) {
            this.castFunction.render(sqlAppender, Arrays.asList(realArg, new CastTarget(this.doubleType)), translator);
        } else {
            translator.render(realArg, this.defaultArgumentRenderingMode);
        }
    }

    @Override
    public String getArgumentListSignature() {
        return "(NUMERIC arg)";
    }
}

