/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class BasicValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
DomainResultProducer<T> {
    private final ColumnReference columnReference;

    public static <T> BasicValuedPathInterpretation<T> from(SqmBasicValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState, boolean jpaQueryComplianceEnabled) {
        ColumnReference columnReference;
        ModelPartContainer modelPartContainer;
        MappingMetamodelImplementor mappingMetamodel;
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(lhs.getNavigablePath());
        EntityPersister treatTarget = null;
        if (lhs instanceof SqmTreatedPath) {
            EntityDomainType treatTargetDomainType = ((SqmTreatedPath)lhs).getTreatTarget();
            mappingMetamodel = sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
            EntityPersister treatEntityDescriptor = mappingMetamodel.findEntityDescriptor(treatTargetDomainType.getHibernateEntityName());
            MappingType tableGroupMappingType = tableGroup.getModelPart().getPartMappingType();
            if (tableGroupMappingType instanceof EntityMappingType && treatEntityDescriptor.isTypeOrSuperType((EntityMappingType)tableGroupMappingType)) {
                modelPartContainer = tableGroup.getModelPart();
                treatTarget = treatEntityDescriptor;
            } else {
                modelPartContainer = treatEntityDescriptor;
            }
        } else {
            modelPartContainer = tableGroup.getModelPart();
            if (jpaQueryComplianceEnabled && lhs.getNodeType() instanceof EntityDomainType) {
                EntityDomainType entityDomainType = (EntityDomainType)lhs.getNodeType();
                mappingMetamodel = sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
                treatTarget = mappingMetamodel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
            }
        }
        BasicValuedModelPart mapping = SqmUtil.needsTargetTableMapping(sqmPath, modelPartContainer, sqlAstCreationState) ? (BasicValuedModelPart)((ManagedMappingType)modelPartContainer.getPartMappingType()).findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget) : (BasicValuedModelPart)modelPartContainer.findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget);
        if (mapping == null) {
            ModelPart subPart;
            if (jpaQueryComplianceEnabled && (subPart = tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null)) != null) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.IMPLICIT_TREAT);
            }
            throw new SemanticException("`" + sqmPath.getNavigablePath() + "` did not reference a known model part");
        }
        TableReference tableReference = tableGroup.resolveTableReference(sqmPath.getNavigablePath(), mapping, mapping.getContainingTableExpression());
        Expression expression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, mapping);
        if (expression instanceof ColumnReference) {
            columnReference = (ColumnReference)expression;
        } else if (expression instanceof SqlSelectionExpression) {
            Expression selectedExpression = ((SqlSelectionExpression)expression).getSelection().getExpression();
            assert (selectedExpression instanceof ColumnReference);
            columnReference = (ColumnReference)selectedExpression;
        } else {
            throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
        }
        return new BasicValuedPathInterpretation<T>(columnReference, sqmPath.getNavigablePath(), mapping, tableGroup);
    }

    public BasicValuedPathInterpretation(ColumnReference columnReference, NavigablePath navigablePath, BasicValuedModelPart mapping, TableGroup tableGroup) {
        super(navigablePath, mapping, tableGroup);
        assert (columnReference != null);
        this.columnReference = columnReference;
    }

    @Override
    public Expression getSqlExpression() {
        return this.columnReference;
    }

    @Override
    public ColumnReference getColumnReference() {
        return this.columnReference;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.columnReference.accept(sqlTreeWalker);
    }

    public String toString() {
        return "BasicValuedPathInterpretation(" + this.getNavigablePath() + ")";
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this.columnReference);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this.columnReference);
    }
}

