/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Collection;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.loader.LoaderLogging;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.internal.IdentifierLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public abstract class BaseNaturalIdLoadAccessImpl<T>
implements NaturalIdLoadOptions {
    private final LoadAccessContext context;
    private final EntityMappingType entityDescriptor;
    private LockOptions lockOptions;
    private boolean synchronizationEnabled = true;

    protected BaseNaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        this.context = context;
        this.entityDescriptor = entityDescriptor;
        if (entityDescriptor.getNaturalIdMapping() == null) {
            throw new HibernateException(String.format("Entity [%s] did not define a natural id", entityDescriptor.getEntityName()));
        }
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public boolean isSynchronizationEnabled() {
        return this.synchronizationEnabled;
    }

    public BaseNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    protected void synchronizationEnabled(boolean synchronizationEnabled) {
        this.synchronizationEnabled = synchronizationEnabled;
    }

    protected final Object resolveNaturalId(Map<String, Object> naturalIdParameters) {
        this.performAnyNeededCrossReferenceSynchronizations();
        Object resolvedId = this.entityPersister().getNaturalIdLoader().resolveNaturalIdToId(naturalIdParameters, this.context.getSession());
        return resolvedId == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE ? null : resolvedId;
    }

    protected void performAnyNeededCrossReferenceSynchronizations() {
        if (!this.synchronizationEnabled) {
            return;
        }
        NaturalIdMapping naturalIdMapping = this.entityDescriptor.getNaturalIdMapping();
        if (!naturalIdMapping.isMutable()) {
            return;
        }
        SessionImplementor session = this.context.getSession();
        if (!session.isTransactionInProgress()) {
            return;
        }
        PersistenceContext persistenceContext = this.context.getSession().getPersistenceContextInternal();
        Collection<?> cachedPkResolutions = persistenceContext.getNaturalIdResolutions().getCachedPkResolutions(this.entityPersister());
        for (Object pk : cachedPkResolutions) {
            EntityKey entityKey = this.context.getSession().generateEntityKey(pk, this.entityPersister());
            Object entity = persistenceContext.getEntity(entityKey);
            EntityEntry entry = persistenceContext.getEntry(entity);
            if (entry == null) {
                if (!LoaderLogging.DEBUG_ENABLED) continue;
                LoaderLogging.LOADER_LOGGER.debugf("Cached natural-id/pk resolution linked to null EntityEntry in persistence context : %s#%s", (Object)this.entityDescriptor.getEntityName(), pk);
                continue;
            }
            if (!entry.requiresDirtyCheck(entity) || entry.getStatus() != Status.MANAGED) continue;
            persistenceContext.getNaturalIdResolutions().handleSynchronization(pk, entity, this.entityPersister());
        }
    }

    protected final T doGetReference(Object normalizedNaturalIdValue) {
        this.performAnyNeededCrossReferenceSynchronizations();
        this.context.checkOpenOrWaitingForAutoClose();
        this.context.pulseTransactionCoordinator();
        SessionImplementor session = this.context.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object cachedResolution = persistenceContext.getNaturalIdResolutions().findCachedIdByNaturalId(normalizedNaturalIdValue, this.entityPersister());
        if (cachedResolution == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE) {
            return null;
        }
        if (cachedResolution != null) {
            return (T)this.getIdentifierLoadAccess().getReference(cachedResolution);
        }
        LoaderLogging.LOADER_LOGGER.debugf("Selecting entity identifier by natural-id for `#getReference` handling - %s : %s", (Object)this.entityPersister().getEntityName(), normalizedNaturalIdValue);
        Object idFromDatabase = this.entityPersister().getNaturalIdLoader().resolveNaturalIdToId(normalizedNaturalIdValue, session);
        if (idFromDatabase != null) {
            return (T)this.getIdentifierLoadAccess().getReference(idFromDatabase);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T doLoad(Object normalizedNaturalIdValue) {
        this.performAnyNeededCrossReferenceSynchronizations();
        this.context.checkOpenOrWaitingForAutoClose();
        this.context.pulseTransactionCoordinator();
        SessionImplementor session = this.context.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object cachedResolution = persistenceContext.getNaturalIdResolutions().findCachedIdByNaturalId(normalizedNaturalIdValue, this.entityPersister());
        if (cachedResolution == NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE) {
            return null;
        }
        try {
            Object loaded = cachedResolution != null ? this.getIdentifierLoadAccess().load(cachedResolution) : this.entityPersister().getNaturalIdLoader().load(normalizedNaturalIdValue, this, session);
            if (loaded != null) {
                LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(loaded);
                EntityEntry entry = lazyInitializer != null ? persistenceContext.getEntry(lazyInitializer.getImplementation()) : persistenceContext.getEntry(loaded);
                assert (entry != null);
                if (entry.getStatus() == Status.DELETED) {
                    T t = null;
                    return t;
                }
            }
            Object obj = loaded;
            return (T)obj;
        }
        finally {
            this.context.delayedAfterCompletion();
        }
    }

    protected final IdentifierLoadAccess<?> getIdentifierLoadAccess() {
        IdentifierLoadAccessImpl identifierLoadAccess = new IdentifierLoadAccessImpl(this.context, this.entityPersister());
        if (this.lockOptions != null) {
            identifierLoadAccess.with(this.lockOptions);
        }
        return identifierLoadAccess;
    }

    protected LoadAccessContext getContext() {
        return this.context;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected EntityPersister entityPersister() {
        return this.entityDescriptor.getEntityPersister();
    }
}

