/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmCorrelatedEntityJoin<T>
extends SqmEntityJoin<T>
implements SqmCorrelation<T, T> {
    private final SqmCorrelatedRootJoin<T> correlatedRootJoin;
    private final SqmEntityJoin<T> correlationParent;

    public SqmCorrelatedEntityJoin(SqmEntityJoin<T> correlationParent) {
        super(correlationParent.getNavigablePath(), correlationParent.getReferencedPathSource(), correlationParent.getExplicitAlias(), SqmJoinType.INNER, correlationParent.getRoot());
        this.correlatedRootJoin = SqmCorrelatedRootJoin.create(correlationParent, this);
        this.correlationParent = correlationParent;
    }

    public SqmCorrelatedEntityJoin(EntityDomainType<T> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<?> sqmRoot, SqmCorrelatedRootJoin<T> correlatedRootJoin, SqmEntityJoin<T> correlationParent) {
        super(joinedEntityDescriptor, alias, joinType, sqmRoot);
        this.correlatedRootJoin = correlatedRootJoin;
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmCorrelatedEntityJoin<T> copy(SqmCopyContext context) {
        SqmCorrelatedEntityJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedEntityJoin<T> path = context.registerCopy(this, new SqmCorrelatedEntityJoin<T>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot<?>)this.getRoot().copy(context), this.correlatedRootJoin.copy(context), this.correlationParent.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelatedEntityJoin(this);
    }

    @Override
    public SqmEntityJoin<T> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.correlationParent;
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<T> getCorrelatedRoot() {
        return this.correlatedRootJoin;
    }

    @Override
    public SqmCorrelatedEntityJoin<T> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmCorrelatedEntityJoin<T>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot)pathRegistry.findFromByPath(this.getRoot().getNavigablePath()), (SqmCorrelatedRootJoin)pathRegistry.findFromByPath(this.correlatedRootJoin.getNavigablePath()), (SqmEntityJoin)pathRegistry.findFromByPath(this.correlationParent.getNavigablePath()));
    }
}

